/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.impl.gui.main.account.AccountRegWizardContainerImpl;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AccountRightButtonMenu
extends SIPCommPopupMenu
implements ActionListener,
PluginComponentListener,
Skinnable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Logger.getLogger(AccountRightButtonMenu.class);
    private Account account = null;
    private List<PluginComponent> pluginComponents = new ArrayList<PluginComponent>();
    private final JMenuItem editItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.EDIT"));

    public AccountRightButtonMenu() {
        this.setLocation(this.getLocation());
        this.init();
        this.loadSkin();
    }

    public void setAccount(Account account) {
        this.account = account;
        this.editItem.setEnabled(account != null && this.account.isEnabled());
        for (PluginComponent pluginComponent : this.pluginComponents) {
            pluginComponent.setCurrentAccountID(account.getAccountID());
        }
    }

    public Account getAccount() {
        return this.account;
    }

    private void init() {
        this.initPluginComponents();
        this.add(this.editItem);
        this.editItem.addActionListener(this);
    }

    private void initPluginComponents() {
        Collection serRefs;
        String osgiFilter = "(CONTAINER_ID=" + Container.CONTAINER_ACCOUNT_RIGHT_BUTTON_MENU.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            serRefs = null;
            this.logger.error((Object)"Could not obtain plugin reference.", (Throwable)ex);
        }
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                PluginComponent component = factory.getPluginComponentInstance((Object)this);
                if (component.getComponent() == null) continue;
                this.pluginComponents.add(component);
                int positionIndex = factory.getPositionIndex();
                if (positionIndex != -1) {
                    this.add((Component)component.getComponent(), positionIndex);
                    continue;
                }
                this.add((Component)component.getComponent());
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    public void loadSkin() {
        this.editItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ACCOUNT_EDIT_ICON)));
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (!factory.getContainer().equals((Object)Container.CONTAINER_ACCOUNT_RIGHT_BUTTON_MENU)) {
            return;
        }
        PluginComponent c = factory.getPluginComponentInstance((Object)this);
        this.add((Component)c.getComponent());
        this.repaint();
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (factory.getContainer().equals((Object)Container.CONTAINER_ACCOUNT_RIGHT_BUTTON_MENU)) {
            Component c = (Component)factory.getPluginComponentInstance((Object)this).getComponent();
            this.remove(c);
            this.pluginComponents.remove(c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        if (menuItem.equals(this.editItem)) {
            if (this.account == null) {
                return;
            }
            AccountRegWizardContainerImpl wizard = (AccountRegWizardContainerImpl)GuiActivator.getUIService().getAccountRegWizardContainer();
            AccountRegistrationWizard protocolWizard = wizard.getProtocolWizard(this.account.getProtocolProvider());
            ResourceManagementService resources = GuiActivator.getResources();
            if (protocolWizard != null) {
                wizard.setTitle(resources.getI18NString("service.gui.ACCOUNT_REGISTRATION_WIZARD"));
                wizard.modifyAccount(this.account.getProtocolProvider());
                wizard.showDialog(false);
            } else {
                String title = resources.getI18NString("service.gui.ERROR");
                String message = resources.getI18NString("service.gui.EDIT_NOT_SUPPORTED");
                ErrorDialog dialog = new ErrorDialog(null, title, message);
                dialog.setVisible(true);
            }
        }
    }
}

