/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.AbstractCallToggleButton;
import net.java.sip.communicator.impl.gui.main.call.VolumeControlSlider;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.resources.ImageID;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.event.VolumeChangeEvent;
import org.jitsi.service.neomedia.event.VolumeChangeListener;

public class InputVolumeControlButton
extends AbstractCallToggleButton
implements VolumeChangeListener,
Runnable {
    private Thread muteRunner;
    private final VolumeControl volumeControl;
    private final JPopupMenu sliderMenu;
    private boolean mute = false;
    private boolean sliderMenuIsVisible = false;
    private final CallConference callConference;

    public InputVolumeControlButton(CallConference callConference, ImageID iconImageID, ImageID pressedIconImageID, boolean inSettingsPanel, boolean selected) {
        super(null, inSettingsPanel, selected, iconImageID, pressedIconImageID, "service.gui.MUTE_BUTTON_TOOL_TIP");
        this.callConference = callConference;
        this.mute = selected;
        this.volumeControl = this.getVolumeControl();
        this.sliderMenu = new VolumeControlSlider(this.volumeControl, 1).getPopupMenu();
        this.sliderMenu.setInvoker((Component)((Object)this));
        this.addMouseListener(new MouseAdapter(){
            TimerTask timerTask;

            @Override
            public void mousePressed(MouseEvent mouseevent) {
                Timer timer = new Timer();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        InputVolumeControlButton.this.showSliderMenu();
                    }
                };
                timer.schedule(this.timerTask, 1000L);
            }

            @Override
            public void mouseReleased(MouseEvent mouseevent) {
                if (!InputVolumeControlButton.this.sliderMenuIsVisible) {
                    if (this.timerTask != null) {
                        this.timerTask.cancel();
                    }
                } else {
                    InputVolumeControlButton.this.setSelected(!InputVolumeControlButton.this.isSelected());
                }
            }
        });
    }

    private VolumeControl getVolumeControl() {
        VolumeControl volumeControl = GuiActivator.getMediaService().getInputVolumeControl();
        volumeControl.addVolumeChangeListener((VolumeChangeListener)this);
        return volumeControl;
    }

    private void showSliderMenu() {
        Point location = new Point(this.getX(), this.getY() + this.getHeight());
        SwingUtilities.convertPointToScreen(location, this.getParent());
        if (this.isFullScreen()) {
            location.setLocation(location.getX(), location.getY() - this.sliderMenu.getPreferredSize().getHeight() - (double)this.getHeight());
        }
        this.sliderMenu.setLocation(location);
        this.sliderMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
                InputVolumeControlButton.this.sliderMenuIsVisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
                InputVolumeControlButton.this.sliderMenuIsVisible = false;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent ev) {
            }
        });
        this.sliderMenu.setVisible(!this.sliderMenu.isVisible());
    }

    public void toggleMute() {
        if (this.muteRunner == null) {
            this.muteRunner = new Thread((Runnable)this, this.getToolTipText());
            this.muteRunner.setDaemon(true);
            this.setEnabled(false);
            this.muteRunner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.doRun();
        }
        finally {
            InputVolumeControlButton inputVolumeControlButton = this;
            synchronized (inputVolumeControlButton) {
                if (Thread.currentThread().equals(this.muteRunner)) {
                    this.muteRunner = null;
                    this.setEnabled(true);
                }
            }
        }
    }

    private void doRun() {
        if (this.callConference != null) {
            this.mute = !this.mute;
            for (Call call : this.callConference.getCalls()) {
                OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
                telephony.setMute(call, this.mute);
            }
            this.setSelected(this.mute);
            if (!this.mute && this.volumeControl.getVolume() == this.volumeControl.getMinValue()) {
                this.volumeControl.setVolume((this.volumeControl.getMaxValue() - this.volumeControl.getMinValue()) / 2.0f);
            }
        }
    }

    public void volumeChange(VolumeChangeEvent volumeChangeEvent) {
        if (volumeChangeEvent.getLevel() == 0.0f) {
            this.toggleMute();
        } else if (this.mute) {
            this.toggleMute();
        }
    }

    @Override
    public void buttonPressed() {
        if (!this.sliderMenuIsVisible) {
            this.toggleMute();
        }
    }
}

