/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.AbstractCallToggleButton;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;

public class ResizeVideoButton
extends AbstractCallToggleButton {
    private boolean loOptionPresent = false;
    private boolean sdOptionPresent = false;
    private boolean hdOptionPresent = false;

    public ResizeVideoButton(Call call) {
        this(call, false);
    }

    public ResizeVideoButton(Call call, boolean selected) {
        super(call, selected, ImageLoader.SD_VIDEO_BUTTON, "service.gui.CHANGE_VIDEO_QUALITY");
        try {
            CallPeer peer = (CallPeer)call.getCallPeers().next();
            OperationSetVideoTelephony videoOpSet = (OperationSetVideoTelephony)peer.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            QualityControl qualityControls = videoOpSet.getQualityControl(peer);
            QualityPreset maxRemotePreset = qualityControls.getRemoteSendMaxPreset();
            if (maxRemotePreset == null || maxRemotePreset.compareTo(QualityPreset.HD_QUALITY) >= 0) {
                this.hdOptionPresent = true;
            }
            if (maxRemotePreset == null || maxRemotePreset.compareTo(QualityPreset.SD_QUALITY) >= 0) {
                this.sdOptionPresent = true;
            }
            if (maxRemotePreset == null || maxRemotePreset.compareTo(QualityPreset.LO_QUALITY) >= 0) {
                this.loOptionPresent = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void buttonPressed() {
        if (this.call != null) {
            this.setSelected(false);
            JPopupMenu resizeMenu = this.createResizeVideoMenu();
            Point location = new Point(this.getX(), this.getY() + this.getHeight());
            SwingUtilities.convertPointToScreen(location, this.getParent());
            resizeMenu.setLocation(location);
            resizeMenu.setVisible(true);
        }
    }

    private JPopupMenu createResizeVideoMenu() {
        final JPopupMenu popupMenu = new JPopupMenu(GuiActivator.getResources().getI18NString("service.gui.CHANGE_VIDEO_QUALITY"));
        popupMenu.setInvoker((Component)((Object)this));
        popupMenu.setFocusable(true);
        Dimension loDimension = QualityPreset.LO_QUALITY.getResolution();
        Dimension sdDimension = QualityPreset.SD_QUALITY.getResolution();
        Dimension hdDimension = QualityPreset.HD_QUALITY.getResolution();
        JMenuItem lowQuality = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.LOW_QUALITY") + this.getFormattedDimension(loDimension), GuiActivator.getResources().getImage("service.gui.icons.LO_VIDEO_ICON"));
        JMenuItem normalQuality = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SD_QUALITY") + this.getFormattedDimension(sdDimension), GuiActivator.getResources().getImage("service.gui.icons.SD_VIDEO_ICON"));
        JMenuItem hdQuality = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.HD_QUALITY") + this.getFormattedDimension(hdDimension), GuiActivator.getResources().getImage("service.gui.icons.HD_VIDEO_ICON"));
        JLabel titleLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.CHANGE_VIDEO_QUALITY"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        popupMenu.add(titleLabel);
        popupMenu.addSeparator();
        if (this.hdOptionPresent) {
            popupMenu.add(hdQuality);
        }
        if (this.sdOptionPresent) {
            popupMenu.add(normalQuality);
        }
        if (this.loOptionPresent) {
            popupMenu.add(lowQuality);
        }
        lowQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.setVisible(false);
                ResizeVideoButton.this.setIconImageID(ImageLoader.LO_VIDEO_BUTTON);
                CallManager.setVideoQualityPreset((CallPeer)ResizeVideoButton.this.call.getCallPeers().next(), QualityPreset.LO_QUALITY);
            }
        });
        normalQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.setVisible(false);
                ResizeVideoButton.this.setIconImageID(ImageLoader.SD_VIDEO_BUTTON);
                CallManager.setVideoQualityPreset((CallPeer)ResizeVideoButton.this.call.getCallPeers().next(), QualityPreset.SD_QUALITY);
            }
        });
        hdQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.setVisible(false);
                ResizeVideoButton.this.setIconImageID(ImageLoader.HD_VIDEO_BUTTON);
                CallManager.setVideoQualityPreset((CallPeer)ResizeVideoButton.this.call.getCallPeers().next(), QualityPreset.HD_QUALITY);
            }
        });
        return popupMenu;
    }

    private String getFormattedDimension(Dimension d) {
        return " (" + (int)d.getWidth() + "x" + (int)d.getHeight() + ")";
    }

    public int countAvailableOptions() {
        int count = 0;
        if (this.loOptionPresent) {
            ++count;
        }
        if (this.sdOptionPresent) {
            ++count;
        }
        if (this.hdOptionPresent) {
            ++count;
        }
        return count;
    }
}

