/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommMenuItemUI;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.service.replacement.smilies.Smiley;
import net.java.sip.communicator.service.replacement.smilies.SmiliesReplacementService;
import net.java.sip.communicator.util.skin.Skinnable;

public class SmileysSelectorBox
extends SIPCommMenu
implements ActionListener,
MouseListener,
PopupMenuListener,
Skinnable {
    private ChatPanel chatPanel;
    private final JLabel smileyTextLabel = new JLabel();
    private final JLabel smileyDescriptionLabel = new JLabel();
    private final SmiliesReplacementService smiliesService;
    private JPopupMenu popupMenu;

    public SmileysSelectorBox() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.popupMenu = this.getPopupMenu();
        this.popupMenu.setLayout(new GridBagLayout());
        this.popupMenu.setBackground(Color.WHITE);
        this.popupMenu.addPopupMenuListener(this);
        this.smiliesService = GuiActivator.getSmiliesReplacementSource();
        this.loadSkin();
    }

    public void setChat(ChatPanel chatPanel) {
        this.chatPanel = chatPanel;
    }

    private Dimension calculateGridDimensions(int itemsCount) {
        int gridColCount = (int)Math.ceil(Math.sqrt(itemsCount));
        int gridRowCount = itemsCount / gridColCount;
        if (itemsCount > gridRowCount * gridColCount) {
            ++gridColCount;
        }
        return new Dimension(gridColCount, gridRowCount);
    }

    public void open() {
        this.doClick();
    }

    public boolean isMenuSelected() {
        return this.isPopupMenuVisible();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SmileyMenuItem smileyItem = (SmileyMenuItem)e.getSource();
        Smiley smiley = smileyItem.smiley;
        this.chatPanel.getChatWritePanel().appendText(smiley.getDefaultString());
        this.chatPanel.getChatWritePanel().getEditorPane().requestFocus();
        this.clearMouseOverEffects(smileyItem);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        SmileyMenuItem smileyItem = (SmileyMenuItem)e.getSource();
        Smiley smiley = smileyItem.smiley;
        ImageIcon imageIcon = GuiActivator.getResources().getImage(smiley.getImageID());
        smileyItem.setIcon(imageIcon);
        this.smileyDescriptionLabel.setText(smiley.getDescription());
        this.smileyTextLabel.setText("<html>" + smiley.getDefaultString() + "</html>");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        SmileyMenuItem smileyItem = (SmileyMenuItem)e.getSource();
        this.clearMouseOverEffects(smileyItem);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void clearMouseOverEffects(SmileyMenuItem smileyItem) {
        ImageIcon imageIcon = GuiActivator.getResources().getImage(smileyItem.smiley.getImageID());
        smileyItem.setIcon(imageIcon);
        this.smileyTextLabel.setText("");
        this.smileyDescriptionLabel.setText("");
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        JPopupMenu popupMenu = (JPopupMenu)e.getSource();
        for (Component c : popupMenu.getComponents()) {
            ImageIcon ii;
            SmileyMenuItem si;
            if (!(c instanceof SmileyMenuItem) || !((si = (SmileyMenuItem)c).getIcon() instanceof ImageIcon) || (ii = (ImageIcon)si.getIcon()) == null || ii.getImage() == null) continue;
            ii.getImage().flush();
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JPopupMenu popupMenu = (JPopupMenu)e.getSource();
        if (popupMenu.getComponentIndex(this.smileyTextLabel) != -1) {
            return;
        }
        Collection imageList = this.smiliesService.getSmiliesPack();
        Dimension gridDimensions = this.calculateGridDimensions(imageList.size());
        int gridColCount = gridDimensions.width;
        int gridRowCount = gridDimensions.height;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int smileyIndex = 0;
        for (Smiley smiley : imageList) {
            SmileyMenuItem smileyItem = new SmileyMenuItem(smiley);
            smileyItem.setPreferredSize(new Dimension(36, 36));
            smileyItem.addActionListener(this);
            smileyItem.addMouseListener(this);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = smileyIndex % gridColCount;
            gridBagConstraints.gridy = (int)Math.floor(smileyIndex / gridColCount) % gridRowCount;
            popupMenu.add((Component)smileyItem, gridBagConstraints);
            ++smileyIndex;
        }
        this.smileyDescriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridRowCount;
        gridBagConstraints.gridwidth = gridColCount;
        popupMenu.add((Component)this.smileyDescriptionLabel, gridBagConstraints);
        this.smileyTextLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.smileyTextLabel.setHorizontalAlignment(4);
        this.smileyTextLabel.setPreferredSize(new Dimension(50, 25));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = gridColCount / 2;
        gridBagConstraints.gridy = gridRowCount;
        popupMenu.add((Component)this.smileyTextLabel, gridBagConstraints);
    }

    public void loadSkin() {
        this.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.SMILIES_ICON)));
        if (this.popupMenu != null) {
            this.popupMenu = this.getPopupMenu();
            if (this.smiliesService != null) {
                this.smiliesService.reloadSmiliesPack();
            }
            this.popupMenu.removeAll();
        }
    }

    private static class SmileyMenuItem
    extends JMenuItem {
        private static final String uiClassID = SmileyMenuItem.class.getName() + "TreeUI";
        public final Smiley smiley;

        public SmileyMenuItem(Smiley smiley) {
            super(GuiActivator.getResources().getImage(smiley.getImageID()));
            this.smiley = smiley;
        }

        @Override
        public String getUIClassID() {
            return uiClassID;
        }

        static {
            UIManager.getDefaults().put(uiClassID, SIPCommMenuItemUI.class.getName());
        }
    }
}

