/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ProtocolContactSourceServiceImpl;
import net.java.sip.communicator.impl.gui.utils.InviteContactListFilter;
import net.java.sip.communicator.impl.gui.utils.InviteDialog;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;

public class ChatInviteDialog
extends InviteDialog {
    private final ChatPanel chatPanel;
    private ChatTransport inviteChatTransport;

    public ChatInviteDialog(ChatPanel chatPanel) {
        super(GuiActivator.getResources().getI18NString("service.gui.INVITE_CONTACT_TO_CHAT"), true);
        this.chatPanel = chatPanel;
        this.initContactListData();
        this.addInviteButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatInviteDialog.this.inviteContacts();
                ChatInviteDialog.this.dispose();
            }
        });
        this.addCancelButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatInviteDialog.this.dispose();
            }
        });
    }

    private void initContactListData() {
        this.inviteChatTransport = this.chatPanel.findInviteChatTransport();
        this.srcContactList.addContactSource((ContactSourceService)new ProtocolContactSourceServiceImpl(this.inviteChatTransport.getProtocolProvider(), OperationSetMultiUserChat.class));
        this.srcContactList.setDefaultFilter((ContactListFilter)new ChatInviteContactListFilter(this.srcContactList));
        this.srcContactList.applyDefaultFilter();
    }

    private void inviteContacts() {
        ArrayList<String> selectedContactAddresses = new ArrayList<String>();
        Collection contacts = this.destContactList.getContacts(null);
        if (contacts == null) {
            return;
        }
        Iterator selectedContacts = contacts.iterator();
        if (selectedContacts != null) {
            while (selectedContacts.hasNext()) {
                UIContact uiContact = (UIContact)selectedContacts.next();
                Iterator contactsIter = uiContact.getContactDetailsForOperationSet(OperationSetMultiUserChat.class).iterator();
                if (!contactsIter.hasNext()) continue;
                UIContactDetail inviteDetail = (UIContactDetail)contactsIter.next();
                selectedContactAddresses.add(inviteDetail.getAddress());
            }
        }
        if (selectedContactAddresses.size() > 0) {
            this.chatPanel.inviteContacts(this.inviteChatTransport, selectedContactAddresses, this.getReason());
        }
    }

    private class ChatInviteContactListFilter
    extends InviteContactListFilter {
        private OperationSetMultiUserChat opSetMUC;

        public ChatInviteContactListFilter(ContactList sourceContactList) {
            super(sourceContactList);
            this.opSetMUC = (OperationSetMultiUserChat)ChatInviteDialog.this.inviteChatTransport.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class);
        }

        @Override
        public boolean isMatching(UIContact uiContact) {
            SourceContact contact = (SourceContact)uiContact.getDescriptor();
            return !this.opSetMUC.isPrivateMessagingContact(contact.getContactAddress());
        }
    }
}

