/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatContactRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatContactCellRenderer;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatContactListModel;
import net.java.sip.communicator.impl.gui.main.contactlist.CListKeySearchListener;
import net.java.sip.communicator.impl.gui.main.contactlist.DefaultContactList;
import net.java.sip.communicator.plugin.desktoputil.SIPCommScrollPane;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChatRoomMemberListPanel
extends JPanel
implements Skinnable {
    private static final long serialVersionUID = -8250816784228586068L;
    private final DefaultContactList memberList = new DefaultContactList();
    private final ChatContactListModel memberListModel;
    private final ChatPanel chatPanel;

    public ChatRoomMemberListPanel(ChatPanel chatPanel) {
        super(new BorderLayout());
        this.chatPanel = chatPanel;
        this.memberListModel = new ChatContactListModel(chatPanel.getChatSession());
        this.memberList.setModel(this.memberListModel);
        this.memberList.addKeyListener(new CListKeySearchListener(this.memberList));
        this.memberList.setCellRenderer(new ChatContactCellRenderer());
        if (this.chatPanel.getChatSession().getCurrentChatTransport().getProtocolProvider().getSupportedOperationSets().containsKey(OperationSetMultiUserChat.class.getName())) {
            this.memberList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        ChatRoomMemberListPanel.this.memberList.setSelectedIndex(ChatRoomMemberListPanel.this.memberList.locationToIndex(e.getPoint()));
                        ChatContact chatContact = (ChatContact)ChatRoomMemberListPanel.this.memberList.getSelectedValue();
                        if (chatContact != null) {
                            new ChatContactRightButtonMenu(ChatRoomMemberListPanel.this.chatPanel, chatContact).show(ChatRoomMemberListPanel.this.memberList, e.getX(), e.getY());
                        }
                    } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                        if (ConfigurationUtils.isPrivateMessagingInChatRoomDisabled()) {
                            return;
                        }
                        ChatRoomMemberListPanel.this.memberList.setSelectedIndex(ChatRoomMemberListPanel.this.memberList.locationToIndex(e.getPoint()));
                        ChatContact chatContact = (ChatContact)ChatRoomMemberListPanel.this.memberList.getSelectedValue();
                        ChatRoom room = ((ChatRoomWrapper)ChatRoomMemberListPanel.this.chatPanel.getChatSession().getDescriptor()).getChatRoom();
                        if (room.getUserNickname().equals(chatContact.getName())) {
                            return;
                        }
                        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
                        chatWindowManager.openPrivateChatForChatRoomMember(room, chatContact.getName());
                    }
                }
            });
        }
        SIPCommScrollPane contactsScrollPane = new SIPCommScrollPane();
        contactsScrollPane.setHorizontalScrollBarPolicy(31);
        contactsScrollPane.setOpaque(false);
        contactsScrollPane.setBorder(null);
        JViewport viewport = contactsScrollPane.getViewport();
        viewport.setOpaque(false);
        viewport.add(this.memberList);
        this.add((Component)contactsScrollPane);
    }

    public void addContact(ChatContact<?> chatContact) {
        this.memberListModel.addElement(chatContact);
    }

    public void removeContact(ChatContact<?> chatContact) {
        this.memberListModel.removeElement(chatContact);
    }

    public void removeAllChatContacts() {
        this.memberListModel.removeAllElements();
    }

    public void renameContact(ChatContact<?> chatContact) {
    }

    public void loadSkin() {
        ((ChatContactCellRenderer)this.memberList.getCellRenderer()).loadSkin();
    }

    public void dispose() {
        if (this.memberListModel != null) {
            this.memberListModel.dispose();
        }
    }
}

