/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chatroomslist.ChatRoomTableDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.SearchFilter;
import net.java.sip.communicator.impl.gui.utils.OneChoiceInviteDialog;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;

public class ServerChatRoomsChoiceDialog
extends OneChoiceInviteDialog {
    private static final long serialVersionUID = 428358553225114162L;
    private ContactSourceService contactSource;

    public ServerChatRoomsChoiceDialog(String title, ChatRoomProviderWrapper pps) {
        super(title);
        this.contactList.setDefaultFilter((ContactListFilter)new SearchFilter(this.contactList));
        this.contactList.removeAllContactSources();
        this.contactSource = GuiActivator.getMUCService().getServerChatRoomsContactSourceForProvider(pps);
        this.contactList.addContactSource(this.contactSource);
        this.setInfoText(GuiActivator.getResources().getI18NString("service.gui.SERVER_CHAT_ROOMS_DIALOG_TEXT"));
        this.contactList.applyDefaultFilter();
        this.setMinimumSize(new Dimension(300, 300));
        this.addOkButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContact uiContact = ServerChatRoomsChoiceDialog.this.getSelectedContact();
                if (uiContact != null) {
                    ChatRoomTableDialog.setChatRoomField(uiContact.getDisplayName());
                }
                ServerChatRoomsChoiceDialog.this.setVisible(false);
                ServerChatRoomsChoiceDialog.this.dispose();
            }
        });
        this.addCancelButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerChatRoomsChoiceDialog.this.setVisible(false);
                ServerChatRoomsChoiceDialog.this.dispose();
            }
        });
    }

    public void changeProtocolProvider(ChatRoomProviderWrapper provider) {
        this.contactList.removeContactSource(this.contactSource);
        this.contactSource = GuiActivator.getMUCService().getServerChatRoomsContactSourceForProvider(provider);
        this.contactList.addContactSource(this.contactSource);
        this.contactList.applyDefaultFilter();
    }
}

