/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SortedGenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class ProtocolContactSourceServiceImpl
implements ContactSourceService {
    private final ProtocolProviderService protocolProvider;
    private final Class<? extends OperationSet> opSetClass;
    MetaContactListService metaContactListService = GuiActivator.getContactListService();
    private final List<ProtocolCQuery> queries = new LinkedList<ProtocolCQuery>();

    public ProtocolContactSourceServiceImpl(ProtocolProviderService protocolProvider, Class<? extends OperationSet> opSetClass) {
        this.protocolProvider = protocolProvider;
        this.opSetClass = opSetClass;
    }

    public int getType() {
        return 0;
    }

    public String getDisplayName() {
        return GuiActivator.getResources().getI18NString("service.gui.CONTACTS") + " " + this.protocolProvider.getAccountID().getDisplayName();
    }

    public ContactQuery createContactQuery(String queryString) {
        return this.createContactQuery(queryString, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactQuery createContactQuery(String queryString, int contactCount) {
        if (queryString == null) {
            queryString = "";
        }
        ProtocolCQuery contactQuery = new ProtocolCQuery(queryString, contactCount);
        List<ProtocolCQuery> list = this.queries;
        synchronized (list) {
            this.queries.add(contactQuery);
        }
        return contactQuery;
    }

    public synchronized void removeQuery(ContactQuery contactQuery) {
        if (this.queries.remove(contactQuery)) {
            this.queries.notify();
        }
    }

    public int getIndex() {
        return 1;
    }

    private class ProtocolCQuery
    extends AsyncContactQuery<ProtocolContactSourceServiceImpl> {
        private int contactCount;
        private final String queryString;

        public ProtocolCQuery(String queryString, int contactCount) {
            super((ContactSourceService)ProtocolContactSourceServiceImpl.this, Pattern.compile(queryString, 18), true);
            this.queryString = queryString;
            this.contactCount = contactCount;
        }

        protected boolean phoneNumberMatches(String phoneNumber) {
            return false;
        }

        public void run() {
            Iterator contactListIter = ProtocolContactSourceServiceImpl.this.metaContactListService.findAllMetaContactsForProvider(ProtocolContactSourceServiceImpl.this.protocolProvider);
            while (contactListIter.hasNext()) {
                MetaContact metaContact = (MetaContact)contactListIter.next();
                if (this.getStatus() == 1) {
                    return;
                }
                this.addResultContact(metaContact);
            }
            if (this.getStatus() != 1) {
                this.setStatus(0);
            }
        }

        public synchronized void start() {
            boolean queryHasStarted = false;
            try {
                super.start();
                queryHasStarted = true;
            }
            finally {
                if (!queryHasStarted) {
                    ((ProtocolContactSourceServiceImpl)this.getContactSource()).removeQuery((ContactQuery)this);
                }
            }
        }

        private void addResultContact(MetaContact metaContact) {
            Iterator contacts = metaContact.getContactsForProvider(ProtocolContactSourceServiceImpl.this.protocolProvider);
            while (contacts.hasNext()) {
                if (this.getStatus() == 1) {
                    return;
                }
                if (this.contactCount > 0 && this.getQueryResultCount() > this.contactCount) break;
                Contact contact = (Contact)contacts.next();
                String contactAddress = contact.getAddress();
                String contactDisplayName = contact.getDisplayName();
                String queryLowerCase = this.queryString.toLowerCase();
                if (this.queryString != null && this.queryString.length() > 0 && !metaContact.getDisplayName().toLowerCase().contains(queryLowerCase) && !contactAddress.toLowerCase().contains(queryLowerCase) && !contactDisplayName.toLowerCase().contains(queryLowerCase)) continue;
                ContactDetail contactDetail = new ContactDetail(contactAddress);
                ArrayList<Class> supportedOpSets = new ArrayList<Class>();
                supportedOpSets.add(ProtocolContactSourceServiceImpl.this.opSetClass);
                contactDetail.setSupportedOpSets(supportedOpSets);
                ArrayList<ContactDetail> contactDetails = new ArrayList<ContactDetail>();
                contactDetails.add(contactDetail);
                SortedGenericSourceContact sourceContact = new SortedGenericSourceContact((ContactQuery)this, (ContactSourceService)ProtocolContactSourceServiceImpl.this, metaContact.getDisplayName(), contactDetails);
                if (!contactAddress.equals(contactDisplayName)) {
                    sourceContact.setDisplayDetails(contactAddress);
                }
                sourceContact.setImage(metaContact.getAvatar());
                sourceContact.setPresenceStatus(contact.getPresenceStatus());
                sourceContact.setContactAddress(contactAddress);
                this.addQueryResult((SourceContact)sourceContact);
            }
        }
    }
}

