/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.awt.Color;
import java.awt.Image;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.SourceContactRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ExternalContactSource;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.UIContactDetailImpl;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.PrefixedContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.util.ConfigurationUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.StringUtils;

public class SourceUIContact
extends UIContactImpl {
    private final SourceContact sourceContact;
    private ContactNode contactNode;
    private ExternalContactSource.SourceUIGroup uiGroup;
    private final List<String> searchStrings = new LinkedList<String>();
    private static final String FILTER_CALL_DETAILS_TO_NUMBERS_PROP = "net.java.sip.communicator.impl.gui.main.contactlist.contactsource.FILTER_CALL_DETAILS_TO_NUMBERS";

    public SourceUIContact(SourceContact contact, ExternalContactSource.SourceUIGroup parentGroup) {
        this.sourceContact = contact;
        this.uiGroup = parentGroup;
        if (contact.getContactDetails() != null) {
            for (ContactDetail detail : contact.getContactDetails()) {
                if (detail.getDetail() == null) continue;
                this.searchStrings.add(detail.getDetail());
            }
        }
        this.searchStrings.add(contact.getDisplayName());
    }

    @Override
    public String getDisplayName() {
        return this.sourceContact.getDisplayName();
    }

    public UIGroup getParentGroup() {
        return this.uiGroup;
    }

    public void setParentGroup(UIGroup parentGroup) {
    }

    public int getSourceIndex() {
        int contactIndex = this.sourceContact.getIndex();
        int groupIndex = this.getParentGroup().getSourceIndex();
        return contactIndex == -1 ? -1 : (groupIndex == -1 ? contactIndex : groupIndex + contactIndex);
    }

    @Override
    public ImageIcon getStatusIcon() {
        PresenceStatus status = this.sourceContact.getPresenceStatus();
        if (status != null) {
            return new ImageIcon(Constants.getStatusIcon(status));
        }
        return new ImageIcon(GlobalStatusEnum.OFFLINE.getStatusIcon());
    }

    @Override
    public byte[] getAvatar() {
        return this.sourceContact.getImage();
    }

    @Override
    public ImageIcon getScaledAvatar(boolean isSelected, int width, int height) {
        byte[] image = this.sourceContact.getImage();
        if (image != null && image.length > 0) {
            ImageIcon icon = new ImageIcon(image);
            if (icon.getIconWidth() > width || icon.getIconHeight() > height) {
                icon = ImageUtils.getScaledRoundedIcon((Image)icon.getImage(), (int)width, (int)height);
            }
            return icon;
        }
        return null;
    }

    public UIContactDetail getDefaultContactDetail(Class<? extends OperationSet> opSetClass) {
        List<UIContactDetail> details = this.getContactDetailsForOperationSet(opSetClass);
        if (details != null && !details.isEmpty()) {
            return details.get(0);
        }
        return null;
    }

    public Object getDescriptor() {
        return this.sourceContact;
    }

    public String getDisplayDetails() {
        return this.sourceContact.getDisplayDetails();
    }

    public List<UIContactDetail> getContactDetails() {
        LinkedList<UIContactDetail> resultList = new LinkedList<UIContactDetail>();
        for (ContactDetail detail : this.sourceContact.getContactDetails()) {
            resultList.add((UIContactDetail)new SourceContactDetail(detail, this.getInternationalizedLabel(detail.getCategory()), this.getInternationalizedLabels(detail.getSubCategories().iterator()), null, this.sourceContact));
        }
        return resultList;
    }

    public List<UIContactDetail> getContactDetailsForOperationSet(Class<? extends OperationSet> opSetClass) {
        LinkedList<UIContactDetail> resultList = new LinkedList<UIContactDetail>();
        Iterator details = this.sourceContact.getContactDetails().iterator();
        PhoneNumberI18nService phoneNumberService = GuiActivator.getPhoneNumberI18nService();
        boolean filterToNumbers = GuiActivator.getConfigurationService().getBoolean(FILTER_CALL_DETAILS_TO_NUMBERS_PROP, false);
        while (details.hasNext()) {
            ContactDetail detail = (ContactDetail)details.next();
            List supportedOperationSets = detail.getSupportedOperationSets();
            if (supportedOperationSets == null || !supportedOperationSets.contains(opSetClass) || filterToNumbers && opSetClass.equals(OperationSetBasicTelephony.class) && !phoneNumberService.isPhoneNumber(detail.getDetail())) continue;
            resultList.add((UIContactDetail)new SourceContactDetail(detail, this.getInternationalizedLabel(detail.getCategory()), this.getInternationalizedLabels(detail.getSubCategories().iterator()), opSetClass, this.sourceContact));
        }
        return resultList;
    }

    public Iterator<String> getSearchStrings() {
        return this.searchStrings.iterator();
    }

    @Override
    public ContactNode getContactNode() {
        return this.contactNode;
    }

    @Override
    public void setContactNode(ContactNode contactNode) {
        this.contactNode = contactNode;
        if (contactNode == null) {
            this.uiGroup.getParentUISource().removeUIContact(this.sourceContact);
        }
    }

    public JPopupMenu getRightButtonMenu() {
        return new SourceContactRightButtonMenu(this);
    }

    public ExtendedTooltip getToolTip() {
        ExtendedTooltip tip = new ExtendedTooltip(true);
        byte[] avatarImage = this.sourceContact.getImage();
        if (avatarImage != null && avatarImage.length > 0) {
            tip.setImage(new ImageIcon(avatarImage));
        }
        tip.setTitle(this.sourceContact.getDisplayName());
        String displayDetails = this.getDisplayDetails();
        if (displayDetails != null) {
            tip.addLine(new JLabel[]{new JLabel(this.getDisplayDetails())});
        }
        try {
            List details = this.sourceContact.getContactDetails(ContactDetail.Category.Phone);
            if (details != null && details.size() > 0) {
                this.addDetailsToToolTip(details, GuiActivator.getResources().getI18NString("service.gui.PHONES"), tip);
            }
            if ((details = this.sourceContact.getContactDetails(ContactDetail.Category.Email)) != null && details.size() > 0) {
                this.addDetailsToToolTip(details, GuiActivator.getResources().getI18NString("service.gui.EMAILS"), tip);
            }
            if ((details = this.sourceContact.getContactDetails(ContactDetail.Category.InstantMessaging)) != null && details.size() > 0) {
                this.addDetailsToToolTip(details, GuiActivator.getResources().getI18NString("service.gui.INSTANT_MESSAGINGS"), tip);
            }
        }
        catch (OperationNotSupportedException e) {
            List telDetails = this.sourceContact.getContactDetails(OperationSetBasicTelephony.class);
            if (telDetails == null || telDetails.isEmpty()) {
                return tip;
            }
            List allDetails = this.sourceContact.getContactDetails();
            this.addDetailsToToolTip(allDetails, GuiActivator.getResources().getI18NString("service.gui.CALL_WITH"), tip);
        }
        return tip;
    }

    private void addDetailsToToolTip(List<ContactDetail> details, String category, ExtendedTooltip toolTip) {
        JLabel categoryLabel = new JLabel(category, null, 2);
        categoryLabel.setFont(categoryLabel.getFont().deriveFont(1));
        categoryLabel.setForeground(Color.DARK_GRAY);
        toolTip.addLine(null, " ");
        toolTip.addLine(new JLabel[]{categoryLabel});
        for (ContactDetail contactDetail : details) {
            String labelText;
            Collection subCategories = contactDetail.getSubCategories();
            JLabel[] jLabels = new JLabel[subCategories.size() + 1];
            int i = 0;
            if (subCategories != null && subCategories.size() > 0) {
                Iterator labelsIter = subCategories.iterator();
                while (labelsIter.hasNext()) {
                    JLabel label = new JLabel(this.getInternationalizedLabel((ContactDetail.SubCategory)labelsIter.next()));
                    label.setFont(label.getFont().deriveFont(1));
                    label.setForeground(Color.GRAY);
                    jLabels[i] = label;
                    ++i;
                }
            }
            if (ConfigurationUtils.isHideAddressInCallHistoryTooltipEnabled()) {
                labelText = contactDetail.getDisplayName();
                if (StringUtils.isNullOrEmpty((String)labelText)) {
                    labelText = contactDetail.getDetail();
                }
            } else {
                labelText = contactDetail.getDisplayName();
            }
            jLabels[i] = new JLabel(this.filterAddressDisplay(labelText));
            toolTip.addLine(jLabels);
        }
    }

    protected String getInternationalizedLabel(ContactDetail.Category category) {
        if (category == null) {
            return null;
        }
        String categoryString = null;
        ResourceManagementService resources = GuiActivator.getResources();
        switch (category) {
            case Address: {
                categoryString = resources.getI18NString("service.gui.ADDRESS");
                break;
            }
            case Email: {
                categoryString = resources.getI18NString("service.gui.EMAIL");
                break;
            }
            case Personal: {
                categoryString = resources.getI18NString("service.gui.PERSONAL");
                break;
            }
            case Organization: {
                categoryString = resources.getI18NString("service.gui.ORGANIZATION");
                break;
            }
            case Phone: {
                categoryString = resources.getI18NString("service.gui.PHONE");
                break;
            }
            case InstantMessaging: {
                categoryString = resources.getI18NString("service.gui.IM");
            }
        }
        return categoryString;
    }

    protected Collection<String> getInternationalizedLabels(Iterator<ContactDetail.SubCategory> subCategories) {
        LinkedList<String> labels = new LinkedList<String>();
        while (subCategories.hasNext()) {
            labels.add(this.getInternationalizedLabel(subCategories.next()));
        }
        return labels;
    }

    protected String getInternationalizedLabel(ContactDetail.SubCategory subCategory) {
        String label;
        if (subCategory == null) {
            return null;
        }
        ResourceManagementService resources = GuiActivator.getResources();
        switch (subCategory) {
            case City: {
                label = resources.getI18NString("service.gui.CITY");
                break;
            }
            case Country: {
                label = resources.getI18NString("service.gui.COUNTRY");
                break;
            }
            case Fax: {
                label = resources.getI18NString("service.gui.FAX");
                break;
            }
            case Home: {
                label = resources.getI18NString("service.gui.HOME");
                break;
            }
            case HomePage: {
                label = resources.getI18NString("service.gui.HOME_PAGE");
                break;
            }
            case JobTitle: {
                label = resources.getI18NString("service.gui.JOB_TITLE");
                break;
            }
            case LastName: {
                label = resources.getI18NString("service.gui.LAST_NAME");
                break;
            }
            case Mobile: {
                label = resources.getI18NString("service.gui.MOBILE_PHONE");
                break;
            }
            case Name: {
                label = resources.getI18NString("service.gui.NAME");
                break;
            }
            case Nickname: {
                label = resources.getI18NString("service.gui.NICKNAME");
                break;
            }
            case Other: {
                label = resources.getI18NString("service.gui.OTHER");
                break;
            }
            case PostalCode: {
                label = resources.getI18NString("service.gui.POSTAL_CODE");
                break;
            }
            case Street: {
                label = resources.getI18NString("service.gui.STREET");
                break;
            }
            case Work: {
                label = resources.getI18NString("service.gui.WORK_PHONE");
                break;
            }
            case AIM: 
            case ICQ: 
            case Jabber: 
            case Yahoo: 
            case Skype: 
            case GoogleTalk: {
                label = subCategory.value();
                break;
            }
            default: {
                label = null;
            }
        }
        return label;
    }

    public Collection<SIPCommButton> getContactCustomActionButtons() {
        if (this.sourceContact != null) {
            return this.uiGroup.getParentUISource().getContactCustomActionButtons(this.sourceContact);
        }
        return null;
    }

    public Collection<JMenuItem> getContactCustomActionMenuItems(boolean initActions) {
        if (this.sourceContact != null) {
            return this.uiGroup.getParentUISource().getContactCustomActionMenuItems(this.sourceContact, initActions);
        }
        return null;
    }

    protected static class SourceContactDetail
    extends UIContactDetailImpl {
        public SourceContactDetail(ContactDetail detail, String category, Collection<String> subCategories, Class<? extends OperationSet> opSetClass, SourceContact sourceContact) {
            super(detail.getDetail(), detail.getDetail(), category, subCategories, null, null, null, (Object)detail);
            String prefix;
            ContactSourceService contactSource = sourceContact.getContactSource();
            if (contactSource instanceof PrefixedContactSourceService && (prefix = ((PrefixedContactSourceService)contactSource).getPhoneNumberPrefix()) != null) {
                this.setPrefix(prefix);
            }
            this.addPreferredProtocolProvider(opSetClass, detail.getPreferredProtocolProvider(opSetClass));
            this.addPreferredProtocol(opSetClass, detail.getPreferredProtocol(opSetClass));
        }

        public SourceContactDetail(String displayName, SourceContact sourceContact) {
            super(displayName, displayName, null, null, null, null, null, (Object)sourceContact);
        }

        public PresenceStatus getPresenceStatus() {
            return null;
        }
    }
}

