/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.dnsconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.java.sip.communicator.impl.dns.DnsUtilActivator;
import net.java.sip.communicator.impl.dns.SecureResolveMode;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.dnsconfig.DnsConfigActivator;
import net.java.sip.communicator.plugin.dnsconfig.DnssecTableModel;
import net.java.sip.communicator.plugin.dnsconfig.ParallelDnsPanel;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class DnssecPanel
extends TransparentPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(DnssecPanel.class);
    private JComboBox cboDefault;
    private JCheckBox chkEnabled;
    private JCheckBox chkAbsolute;
    private JTable tblDomains;
    private JTextField txtNameservers;
    private ResourceManagementService R;
    private ConfigurationService config;
    private TableModel data = new DnssecTableModel();
    private final ParallelDnsPanel parallelDnsPanel;

    public DnssecPanel(ParallelDnsPanel parallelDnsPanel) {
        this.parallelDnsPanel = parallelDnsPanel;
        this.initServices();
        this.initComponents();
        this.loadData();
        this.updateState();
        this.chkAbsolute.addActionListener(this);
        this.chkEnabled.addActionListener(this);
        this.cboDefault.addActionListener(this);
        this.txtNameservers.addFocusListener(this);
    }

    private void initServices() {
        BundleContext bc = DnsConfigActivator.bundleContext;
        this.R = (ResourceManagementService)ServiceUtils.getService((BundleContext)bc, ResourceManagementService.class);
        this.config = (ConfigurationService)ServiceUtils.getService((BundleContext)bc, ConfigurationService.class);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 0));
        TransparentPanel pnlCommon = new TransparentPanel((LayoutManager)new GridBagLayout());
        pnlCommon.setAlignmentX(0.0f);
        GridBagConstraints cl = new GridBagConstraints();
        GridBagConstraints cr = new GridBagConstraints();
        cr.gridy = 0;
        cl.gridy = 0;
        cr.anchor = 21;
        cl.anchor = 21;
        cl.gridx = 0;
        cl.fill = 2;
        cl.weightx = 0.0;
        cl.insets = new Insets(0, 0, 0, 10);
        cr.gridx = 1;
        cr.fill = 2;
        cr.gridwidth = 0;
        cr.weightx = 1.0;
        this.add((Component)pnlCommon, "North");
        this.chkAbsolute = new SIPCommCheckBox(this.R.getI18NString("plugin.dnsconfig.dnssec.chkAbsolute"));
        cl.gridwidth = 2;
        pnlCommon.add((Component)this.chkAbsolute, cl);
        cl.gridwidth = 1;
        ++cr.gridy;
        cl.gridy = cr.gridy++;
        this.chkEnabled = new SIPCommCheckBox(this.R.getI18NString("plugin.dnsconfig.dnssec.chkEnabled"));
        cl.gridwidth = 2;
        pnlCommon.add((Component)this.chkEnabled, cl);
        cl.gridwidth = 1;
        cl.gridy = cr.gridy++;
        JLabel lblRestart = new JLabel(this.R.getI18NString("plugin.dnsconfig.dnssec.RESTART_WARNING", new String[]{this.R.getSettingsString("service.gui.APPLICATION_NAME")}));
        lblRestart.setBorder(BorderFactory.createEmptyBorder(0, 22, 10, 0));
        cl.gridwidth = 0;
        pnlCommon.add((Component)lblRestart, cl);
        cl.gridwidth = 1;
        cl.gridy = cr.gridy++;
        JLabel lblNameserver = new JLabel(this.R.getI18NString("plugin.dnsconfig.dnssec.lblNameservers"));
        lblNameserver.setBorder(BorderFactory.createEmptyBorder(0, 22, 0, 0));
        pnlCommon.add((Component)lblNameserver, cl);
        this.txtNameservers = new JTextField();
        pnlCommon.add((Component)this.txtNameservers, cr);
        cl.gridy = cr.gridy++;
        JLabel lblNsHint = new JLabel(this.R.getI18NString("plugin.dnsconfig.dnssec.lblNameserversHint"));
        lblNsHint.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        pnlCommon.add((Component)lblNsHint, cr);
        cl.gridy = cr.gridy;
        JLabel lblDefault = new JLabel(this.R.getI18NString("plugin.dnsconfig.dnssec.lblDefault"));
        lblDefault.setBorder(BorderFactory.createEmptyBorder(0, 22, 0, 0));
        pnlCommon.add((Component)lblDefault, cl);
        this.cboDefault = new JComboBox<SecureResolveMode>(SecureResolveMode.values());
        this.cboDefault.setRenderer(this.getResolveModeRenderer());
        pnlCommon.add((Component)this.cboDefault, cr);
        this.tblDomains = new JTable(this.data);
        this.tblDomains.setSelectionMode(0);
        this.tblDomains.setRowHeight(20);
        this.tblDomains.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            protected void setValue(Object value) {
                if (value instanceof SecureResolveMode) {
                    this.setText(DnssecPanel.this.R.getI18NString("net.java.sip.communicator.util.dns." + SecureResolveMode.class.getSimpleName() + "." + ((SecureResolveMode)value).name()));
                } else {
                    super.setValue(value);
                }
            }
        });
        JComboBox<SecureResolveMode> cboTblModeEditor = new JComboBox<SecureResolveMode>(SecureResolveMode.values());
        cboTblModeEditor.setRenderer(this.getResolveModeRenderer());
        this.tblDomains.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(cboTblModeEditor));
        JScrollPane pnlScroller = new JScrollPane(this.tblDomains);
        pnlScroller.setBorder(BorderFactory.createEmptyBorder(0, 22, 0, 0));
        pnlScroller.setOpaque(false);
        this.add(pnlScroller, "Center");
    }

    private void loadData() {
        this.cboDefault.setSelectedItem(Enum.valueOf(SecureResolveMode.class, this.config.getString("net.java.sip.communicator.util.dns.DNSSEC_VALIDATION_MODE", SecureResolveMode.WarnIfBogus.name())));
        this.chkEnabled.setSelected(this.config.getBoolean("net.java.sip.communicator.util.dns.DNSSEC_ENABLED", false));
        this.chkAbsolute.setSelected(this.config.getBoolean("net.java.sip.communicator.util.dns.DNSSEC_ALWAYS_ABSOLUTE", false));
        this.txtNameservers.setText(this.config.getString("net.java.sip.communicator.util.dns.DNSSEC_NAMESERVERS"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cboDefault) {
            if (this.cboDefault.getSelectedItem() == null) {
                return;
            }
            SecureResolveMode oldMode = Enum.valueOf(SecureResolveMode.class, this.config.getString("net.java.sip.communicator.util.dns.DNSSEC_VALIDATION_MODE", SecureResolveMode.WarnIfBogus.name()));
            this.config.setProperty("net.java.sip.communicator.util.dns.DNSSEC_VALIDATION_MODE", (Object)((SecureResolveMode)this.cboDefault.getSelectedItem()).name());
            for (int i = 0; i < this.tblDomains.getModel().getRowCount(); ++i) {
                SecureResolveMode m = (SecureResolveMode)this.data.getValueAt(i, 1);
                if (m != oldMode) continue;
                this.data.setValueAt(this.cboDefault.getSelectedItem(), i, 1);
            }
            this.tblDomains.repaint();
            return;
        }
        if (e.getSource() == this.chkEnabled) {
            try {
                File f = DnsConfigActivator.getFileAccessService().getPrivatePersistentFile(".usednsjava", FileCategory.PROFILE);
                if (this.chkEnabled.isSelected()) {
                    if (!f.createNewFile() && !f.exists()) {
                        this.chkEnabled.setSelected(false);
                    }
                } else if (!f.delete() && f.exists()) {
                    this.chkEnabled.setSelected(true);
                }
                this.config.setProperty("net.java.sip.communicator.util.dns.DNSSEC_ENABLED", (Object)this.chkEnabled.isSelected());
            }
            catch (Exception ex) {
                logger.error((Object)"failed to enable DNSSEC", (Throwable)ex);
                ErrorDialog ed = new ErrorDialog(null, this.R.getI18NString("plugin.dnsconfig.dnssec.ENABLE_FAILED"), this.R.getI18NString("plugin.dnsconfig.dnssec.ENABLE_FAILED_MSG"), (Throwable)ex);
                ed.showDialog();
            }
            this.updateState();
        }
        if (e.getSource() == this.chkAbsolute) {
            this.config.setProperty("net.java.sip.communicator.util.dns.DNSSEC_ALWAYS_ABSOLUTE", (Object)this.chkAbsolute.isSelected());
            this.updateState();
        }
    }

    private void updateState() {
        this.cboDefault.setEnabled(this.chkEnabled.isSelected());
        this.txtNameservers.setEnabled(this.chkEnabled.isSelected());
        this.tblDomains.setEnabled(this.chkEnabled.isSelected());
        this.parallelDnsPanel.updateDnssecState();
    }

    private BasicComboBoxRenderer getResolveModeRenderer() {
        return new BasicComboBoxRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(DnssecPanel.this.R.getI18NString("net.java.sip.communicator.util.dns." + SecureResolveMode.class.getSimpleName() + "." + value));
                return c;
            }
        };
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.txtNameservers) {
            this.config.setProperty("net.java.sip.communicator.util.dns.DNSSEC_NAMESERVERS", (Object)this.txtNameservers.getText());
            DnsUtilActivator.reloadDnsResolverConfig();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

