/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.address.AddressFactoryEx;
import gov.nist.javax.sip.address.AddressFactoryImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.UserAgentHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ClientCapabilities;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSupport;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessor;
import net.java.sip.communicator.impl.protocol.sip.OperationSetAutoAnswerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetAvatarSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicInstantMessagingSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetCusaxUtilsSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetDTMFSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetDesktopSharingClientSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetDesktopSharingServerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetDesktopStreamingSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetIncomingDTMFSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetJitsiMeetToolsSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetMessageWaitingSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetServerStoredAccountInfoSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetTelephonyBLFSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetTelephonyConferencingSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetTelephonyParkSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetTypingNotificationsSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetVideoTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolIconSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderExtensions;
import net.java.sip.communicator.impl.protocol.sip.SipAccountIDImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.SipMessageProcessor;
import net.java.sip.communicator.impl.protocol.sip.SipRegistrarConnection;
import net.java.sip.communicator.impl.protocol.sip.SipRegistrarlessConnection;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.impl.protocol.sip.SipStatusEnum;
import net.java.sip.communicator.impl.protocol.sip.net.AutoProxyConnection;
import net.java.sip.communicator.impl.protocol.sip.net.ProxyConnection;
import net.java.sip.communicator.impl.protocol.sip.security.SipSecurityManager;
import net.java.sip.communicator.service.dns.DnssecException;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetAvatar;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetCusaxUtils;
import net.java.sip.communicator.service.protocol.OperationSetDTMF;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.OperationSetIncomingDTMF;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransformImpl;
import net.java.sip.communicator.service.protocol.OperationSetJitsiMeetTools;
import net.java.sip.communicator.service.protocol.OperationSetMessageWaiting;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetSecureSDesTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureZrtpTelephony;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyBLF;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyPark;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.version.Version;
import org.jitsi.util.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ProtocolProviderServiceSipImpl
extends AbstractProtocolProviderService
implements SipListener,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(ProtocolProviderServiceSipImpl.class);
    private AccountID accountID = null;
    private final Object initializationLock = new Object();
    private boolean isInitialized = false;
    private final List<String> registeredEvents = new ArrayList<String>();
    private AddressFactoryEx addressFactory;
    private HeaderFactory headerFactory;
    private SipMessageFactory messageFactory;
    private static SipStackSharing sipStackSharing = null;
    private final Hashtable<String, List<MethodProcessor>> methodProcessors = new Hashtable();
    private static final String DEFAULT_TRANSPORT = "net.java.sip.communicator.impl.protocol.sip.DEFAULT_TRANSPORT";
    private static final String IS_DESKTOP_STREAMING_DISABLED = "net.java.sip.communicator.impl.protocol.sip.DESKTOP_STREAMING_DISABLED";
    private static final String IS_CALLING_DISABLED = "net.java.sip.communicator.impl.protocol.sip.CALLING_DISABLED";
    private static final String IS_MESSAGING_DISABLED = "net.java.sip.communicator.impl.protocol.sip.MESSAGING_DISABLED";
    public static final String USE_SESSION_LEVEL_DIRECTION_IN_SDP = "net.java.sip.communicator.impl.protocol.sip.USE_SESSION_LEVEL_DIRECTION_IN_SDP";
    private static final int MAX_FORWARDS = 70;
    private MaxForwardsHeader maxForwardsHeader = null;
    private UserAgentHeader userAgentHeader = null;
    private String ourDisplayName = null;
    private SipRegistrarConnection sipRegistrarConnection = null;
    private SipSecurityManager sipSecurityManager = null;
    private ProxyConnection connection;
    private ProtocolIconSipImpl protocolIcon;
    private SipStatusEnum sipStatusEnum;
    private final List<SipMessageProcessor> earlyProcessors = new ArrayList<SipMessageProcessor>();
    private boolean forceLooseRouting = false;
    private ClientCapabilities capabilities;
    private OperationSetPresenceSipImpl opSetPersPresence;
    private OperationSetBasicInstantMessagingSipImpl opSetBasicIM;
    private OperationSetMessageWaitingSipImpl opSetMWI;
    private OperationSetServerStoredAccountInfoSipImpl opSetSSAccountInfo;
    private OperationSetTypingNotificationsSipImpl opSetTypingNotif;

    public AccountID getAccountID() {
        return this.accountID;
    }

    public boolean validateContactAddress(String contactId, List<String> result) {
        if (result == null) {
            throw new IllegalArgumentException("result must be an empty list");
        }
        result.clear();
        try {
            Address address = this.parseAddressString(contactId);
            if (address.toString().equals(contactId)) {
                return true;
            }
            if (((SipUri)address.getURI()).getUser().equals(contactId)) {
                return true;
            }
            if (address.toString().equals(address.getURI().getScheme() + ":" + contactId)) {
                return true;
            }
            result.add(SipActivator.getResources().getI18NString("impl.protocol.sip.INVALID_ADDRESS", new String[]{contactId}));
            result.add(((SipUri)address.getURI()).getUser());
        }
        catch (Exception ex) {
            logger.error((Object)("Validating SIP address failed for " + contactId), (Throwable)ex);
            result.add(SipActivator.getResources().getI18NString("impl.protocol.sip.INVALID_ADDRESS", new String[]{contactId}));
            String user = contactId;
            String remainder = "";
            int at = contactId.indexOf(64);
            if (at > -1) {
                user = contactId.substring(0, at);
                remainder = contactId.substring(at);
            }
            String banned = "([^a-z0-9-_.!~*'()&=+$,;?/])+";
            result.add(user.replaceAll(banned, "") + remainder);
        }
        return false;
    }

    public boolean isRegistrationRequiredForCalling() {
        return this.getAccountID().getAccountPropertyBoolean((Object)"MUST_REGISTER_TO_CALL", true);
    }

    public RegistrationState getRegistrationState() {
        if (this.sipRegistrarConnection == null) {
            return RegistrationState.UNREGISTERED;
        }
        return this.sipRegistrarConnection.getRegistrationState();
    }

    public String getProtocolName() {
        return "SIP";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEvent(String event) {
        List<String> list = this.registeredEvents;
        synchronized (list) {
            if (!this.registeredEvents.contains(event)) {
                this.registeredEvents.add(event);
            }
        }
    }

    public List<String> getKnownEventsList() {
        return this.registeredEvents;
    }

    public void register(SecurityAuthority authority) throws OperationFailedException {
        if (!this.isInitialized) {
            throw new OperationFailedException("Provided must be initialized before being able to register.", 1);
        }
        if (this.isRegistered()) {
            return;
        }
        this.forceLooseRouting = this.getAccountID().getAccountPropertyBoolean((Object)"FORCE_PROXY_BYPASS", false);
        sipStackSharing.addSipListener(this);
        this.addRegistrationStateChangeListener(this);
        authority.setUserNameEditable(true);
        this.sipSecurityManager.setSecurityAuthority(authority);
        this.initRegistrarConnection();
        this.connection = ProxyConnection.create(this);
        if (!this.registerUsingNextAddress()) {
            logger.error((Object)("No address found for " + (Object)((Object)this)));
            this.fireRegistrationStateChanged(RegistrationState.REGISTERING, RegistrationState.CONNECTION_FAILED, 8, "Invalid or inaccessible server address.");
        }
    }

    public void unregister() throws OperationFailedException {
        this.unregister(false);
    }

    public void unregister(boolean userRequest) throws OperationFailedException {
        if (this.getRegistrationState().equals((Object)RegistrationState.UNREGISTERED) || this.getRegistrationState().equals((Object)RegistrationState.UNREGISTERING) || this.getRegistrationState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
            return;
        }
        this.sipRegistrarConnection.unregister(userRequest);
        this.sipSecurityManager.setSecurityAuthority(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(String sipAddress, SipAccountIDImpl accountID) throws OperationFailedException, IllegalArgumentException {
        Object object = this.initializationLock;
        synchronized (object) {
            boolean isMessagingDisabled;
            this.accountID = accountID;
            String protocolIconPath = accountID.getAccountPropertyString("PROTOCOL_ICON_PATH");
            if (protocolIconPath == null) {
                protocolIconPath = "resources/images/protocol/sip";
            }
            this.protocolIcon = new ProtocolIconSipImpl(protocolIconPath);
            this.sipStatusEnum = new SipStatusEnum(protocolIconPath);
            if (sipStackSharing == null) {
                sipStackSharing = new SipStackSharing();
            }
            boolean enablePresence = accountID.getAccountPropertyBoolean("IS_PRESENCE_ENABLED", true);
            boolean forceP2P = accountID.getAccountPropertyBoolean("FORCE_P2P_MODE", true);
            int pollingValue = accountID.getAccountPropertyInt("POLLING_PERIOD", 30);
            int subscriptionExpiration = accountID.getAccountPropertyInt("SUBSCRIPTION_EXPIRATION", 3600);
            this.headerFactory = new HeaderFactoryImpl();
            this.addressFactory = new AddressFactoryImpl();
            this.ourDisplayName = accountID.getAccountPropertyString("DISPLAY_NAME");
            if (this.ourDisplayName == null || this.ourDisplayName.trim().length() == 0) {
                this.ourDisplayName = accountID.getUserID();
            }
            OperationSetBasicTelephonySipImpl opSetBasicTelephonySipImpl = new OperationSetBasicTelephonySipImpl(this);
            boolean isCallingDisabled = SipActivator.getConfigurationService().getBoolean(IS_CALLING_DISABLED, false);
            boolean isCallingDisabledForAccount = accountID.getAccountPropertyBoolean("CALLING_DISABLED", false);
            if (!isCallingDisabled && !isCallingDisabledForAccount) {
                this.addSupportedOperationSet(OperationSetBasicTelephony.class, opSetBasicTelephonySipImpl);
                this.addSupportedOperationSet(OperationSetAdvancedTelephony.class, opSetBasicTelephonySipImpl);
                OperationSetAutoAnswerSipImpl autoAnswerOpSet = new OperationSetAutoAnswerSipImpl(this);
                this.addSupportedOperationSet(OperationSetBasicAutoAnswer.class, autoAnswerOpSet);
                this.addSupportedOperationSet(OperationSetAdvancedAutoAnswer.class, autoAnswerOpSet);
                this.addSupportedOperationSet(OperationSetSecureZrtpTelephony.class, opSetBasicTelephonySipImpl);
                this.addSupportedOperationSet(OperationSetSecureSDesTelephony.class, opSetBasicTelephonySipImpl);
                this.addSupportedOperationSet(OperationSetVideoTelephony.class, new OperationSetVideoTelephonySipImpl(opSetBasicTelephonySipImpl));
                this.addSupportedOperationSet(OperationSetTelephonyConferencing.class, new OperationSetTelephonyConferencingSipImpl(this));
                OperationSetDTMFSipImpl operationSetDTMFSip = new OperationSetDTMFSipImpl(this);
                this.addSupportedOperationSet(OperationSetDTMF.class, operationSetDTMFSip);
                this.addSupportedOperationSet(OperationSetIncomingDTMF.class, new OperationSetIncomingDTMFSipImpl(this, operationSetDTMFSip));
                boolean isDesktopStreamingDisabled = SipActivator.getConfigurationService().getBoolean(IS_DESKTOP_STREAMING_DISABLED, false);
                boolean isAccountDesktopStreamingDisabled = accountID.getAccountPropertyBoolean("DESKTOP_STREAMING_DISABLED", false);
                if (!isDesktopStreamingDisabled && !isAccountDesktopStreamingDisabled) {
                    this.addSupportedOperationSet(OperationSetDesktopStreaming.class, new OperationSetDesktopStreamingSipImpl(opSetBasicTelephonySipImpl));
                    if (!accountID.getAccountPropertyBoolean("DESKTOP_REMOTE_CONTROL_DISABLED", false)) {
                        this.addSupportedOperationSet(OperationSetDesktopSharingServer.class, new OperationSetDesktopSharingServerSipImpl(opSetBasicTelephonySipImpl));
                        this.addSupportedOperationSet(OperationSetDesktopSharingClient.class, new OperationSetDesktopSharingClientSipImpl(this));
                    }
                }
                this.addSupportedOperationSet(OperationSetJitsiMeetTools.class, new OperationSetJitsiMeetToolsSipImpl());
                boolean isParkingEnabled = accountID.getAccountPropertyBoolean("IS_CALL_PARK_ENABLED", false);
                if (isParkingEnabled) {
                    this.addSupportedOperationSet(OperationSetTelephonyPark.class, new OperationSetTelephonyParkSipImpl(this));
                }
            }
            if (enablePresence) {
                this.opSetPersPresence = new OperationSetPresenceSipImpl(this, enablePresence, forceP2P, pollingValue, subscriptionExpiration);
                this.addSupportedOperationSet(OperationSetPersistentPresence.class, this.opSetPersPresence);
                this.addSupportedOperationSet(OperationSetPresence.class, this.opSetPersPresence);
            }
            if (!(isMessagingDisabled = SipActivator.getConfigurationService().getBoolean(IS_MESSAGING_DISABLED, false))) {
                this.opSetBasicIM = new OperationSetBasicInstantMessagingSipImpl(this);
                this.addSupportedOperationSet(OperationSetBasicInstantMessaging.class, this.opSetBasicIM);
                this.opSetTypingNotif = new OperationSetTypingNotificationsSipImpl(this, this.opSetBasicIM);
                this.addSupportedOperationSet(OperationSetTypingNotifications.class, this.opSetTypingNotif);
                this.addSupportedOperationSet(OperationSetInstantMessageTransform.class, new OperationSetInstantMessageTransformImpl());
            }
            this.opSetSSAccountInfo = new OperationSetServerStoredAccountInfoSipImpl(this);
            this.opSetSSAccountInfo.setOurDisplayName(this.ourDisplayName);
            this.addSupportedOperationSet(OperationSetServerStoredAccountInfo.class, this.opSetSSAccountInfo);
            this.addSupportedOperationSet(OperationSetAvatar.class, new OperationSetAvatarSipImpl(this, (OperationSetServerStoredAccountInfo)this.opSetSSAccountInfo));
            if (accountID.getAccountPropertyBoolean("VOICEMAIL_ENABLED", true)) {
                this.opSetMWI = new OperationSetMessageWaitingSipImpl(this);
                this.addSupportedOperationSet(OperationSetMessageWaiting.class, this.opSetMWI);
            }
            if (this.getAccountID().getAccountPropertyString((Object)"cusax.XMPP_ACCOUNT_ID") != null) {
                this.addSupportedOperationSet(OperationSetCusaxUtils.class, new OperationSetCusaxUtilsSipImpl(this));
            }
            if (accountID.getAccountPropertyBoolean("BLF_ENABLED", false)) {
                this.addSupportedOperationSet(OperationSetTelephonyBLF.class, new OperationSetTelephonyBLFSipImpl(this));
            }
            this.capabilities = new ClientCapabilities(this);
            this.sipSecurityManager = new SipSecurityManager((AccountID)accountID, this);
            this.sipSecurityManager.setHeaderFactory(this.headerFactory);
            ProtocolProviderExtensions.registerCustomOperationSets(this);
            this.isInitialized = true;
        }
    }

    protected <T extends OperationSet> void addSupportedOperationSet(Class<T> opsetClass, T opset) {
        super.addSupportedOperationSet(opsetClass, opset);
    }

    protected <T extends OperationSet> void removeSupportedOperationSet(Class<T> opsetClass) {
        super.removeSupportedOperationSet(opsetClass);
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processResponse(ResponseEvent responseEvent) {
        block4: {
            ClientTransaction clientTransaction = responseEvent.getClientTransaction();
            if (clientTransaction == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"ignoring a transactionless response");
                }
                return;
            }
            Response response = responseEvent.getResponse();
            this.earlyProcessMessage((EventObject)responseEvent);
            String method = ((CSeqHeader)response.getHeader("CSeq")).getMethod();
            List<MethodProcessor> processors = this.methodProcessors.get(method);
            if (processors == null) break block4;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + processors.size() + " processor(s) for method " + method));
            }
            for (MethodProcessor processor : processors) {
                if (processor.processResponse(responseEvent)) break;
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        block5: {
            String method;
            List<MethodProcessor> processors;
            Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
            if (transaction == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"ignoring a transactionless timeout event");
                }
                return;
            }
            this.earlyProcessMessage((EventObject)timeoutEvent);
            Request request = transaction.getRequest();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("received timeout for req=" + request));
            }
            if ((processors = this.methodProcessors.get(method = request.getMethod())) == null) break block5;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + processors.size() + " processor(s) for method " + method));
            }
            for (MethodProcessor processor : processors) {
                if (processor.processTimeout(timeoutEvent)) break;
            }
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        block4: {
            Object transaction = transactionTerminatedEvent.isServerTransaction() ? transactionTerminatedEvent.getServerTransaction() : transactionTerminatedEvent.getClientTransaction();
            if (transaction == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"ignoring a transactionless transaction terminated event");
                }
                return;
            }
            Request request = transaction.getRequest();
            String method = request.getMethod();
            List<MethodProcessor> processors = this.methodProcessors.get(method);
            if (processors == null) break block4;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + processors.size() + " processor(s) for method " + method));
            }
            for (MethodProcessor processor : processors) {
                if (processor.processTransactionTerminated(transactionTerminatedEvent)) break;
            }
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dialog terminated for req=" + dialogTerminatedEvent.getDialog()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        if (!(this.sipRegistrarConnection == null || this.sipRegistrarConnection.isRegistrarless() || this.sipRegistrarConnection.isRequestFromSameConnection(request) || this.forceLooseRouting)) {
            logger.warn((Object)("Received request not from our proxy, ignoring it! Request:" + request));
            if (requestEvent.getServerTransaction() != null) {
                try {
                    requestEvent.getServerTransaction().terminate();
                }
                catch (Throwable e) {
                    logger.warn((Object)("Failed to properly terminate transaction for a rogue request. Well ... so be it Request:" + request));
                }
            }
            return;
        }
        this.earlyProcessMessage((EventObject)requestEvent);
        EventHeader eventHeader = (EventHeader)request.getHeader("Event");
        if (eventHeader != null) {
            boolean eventKnown;
            List<String> list = this.registeredEvents;
            synchronized (list) {
                eventKnown = this.registeredEvents.contains(eventHeader.getEventType());
            }
            if (!eventKnown) {
                ServerTransaction serverTransaction = requestEvent.getServerTransaction();
                if (serverTransaction == null) {
                    try {
                        serverTransaction = SipStackSharing.getOrCreateServerTransaction(requestEvent);
                    }
                    catch (TransactionAlreadyExistsException ex) {
                        logger.error((Object)"Failed to create a new servertransaction for an incoming request\n(Next message contains the request)", (Throwable)ex);
                        return;
                    }
                    catch (TransactionUnavailableException ex) {
                        logger.error((Object)"Failed to create a new servertransaction for an incoming request\n(Next message contains the request)", (Throwable)ex);
                        return;
                    }
                }
                Response response = null;
                try {
                    response = this.getMessageFactory().createResponse(489, request);
                }
                catch (ParseException e) {
                    logger.error((Object)"failed to create the 489 response", (Throwable)e);
                    return;
                }
                try {
                    serverTransaction.sendResponse(response);
                    return;
                }
                catch (SipException e) {
                    logger.error((Object)"failed to send the response", (Throwable)e);
                }
                catch (InvalidArgumentException e) {
                    logger.error((Object)"invalid argument provided while trying to send the response", (Throwable)e);
                }
            }
        }
        String method = request.getMethod();
        List<MethodProcessor> processors = this.methodProcessors.get(method);
        boolean processedAtLeastOnce = false;
        if (processors != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + processors.size() + " processor(s) for method " + method));
            }
            for (MethodProcessor processor : processors) {
                if (!processor.processRequest(requestEvent)) continue;
                processedAtLeastOnce = true;
                break;
            }
        }
        if (!processedAtLeastOnce) {
            try {
                ServerTransaction serverTransaction = SipStackSharing.getOrCreateServerTransaction(requestEvent);
                if (serverTransaction == null) {
                    logger.warn((Object)("Could not create a transaction for a non-supported method " + request.getMethod()));
                    return;
                }
                TransactionState state = serverTransaction.getState();
                if (TransactionState.TRYING.equals((Object)state)) {
                    Response response = this.getMessageFactory().createResponse(501, request);
                    serverTransaction.sendResponse(response);
                }
            }
            catch (Throwable exc) {
                logger.warn((Object)("Could not respond to a non-supported method " + request.getMethod()), exc);
            }
        }
    }

    public void shutdown() {
        if (!this.isInitialized) {
            return;
        }
        new ShutdownThread().run();
    }

    public ArrayList<ViaHeader> getLocalViaHeaders(Address intendedDestination) throws OperationFailedException {
        return this.getLocalViaHeaders((SipURI)intendedDestination.getURI());
    }

    public ArrayList<ViaHeader> getLocalViaHeaders(SipURI intendedDestination) throws OperationFailedException {
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ListeningPoint srcListeningPoint = this.getListeningPoint(intendedDestination.getTransportParam());
        try {
            InetSocketAddress targetAddress = this.getIntendedDestination(intendedDestination);
            InetAddress localAddress = SipActivator.getNetworkAddressManagerService().getLocalHost(targetAddress.getAddress());
            int localPort = srcListeningPoint.getPort();
            String transport = srcListeningPoint.getTransport();
            if ("TCP".equalsIgnoreCase(transport) || "TLS".equalsIgnoreCase(transport)) {
                InetSocketAddress localSockAddr = sipStackSharing.getLocalAddressForDestination(targetAddress.getAddress(), targetAddress.getPort(), localAddress, transport);
                localPort = localSockAddr.getPort();
            }
            ViaHeader viaHeader = this.headerFactory.createViaHeader(localAddress.getHostAddress(), localPort, transport, null);
            viaHeaders.add(viaHeader);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("generated via headers:" + viaHeader));
            }
            return viaHeaders;
        }
        catch (ParseException ex) {
            logger.error((Object)"A ParseException occurred while creating Via Headers!", (Throwable)ex);
            throw new OperationFailedException("A ParseException occurred while creating Via Headers!", 4, (Throwable)ex);
        }
        catch (InvalidArgumentException ex) {
            logger.error((Object)("Unable to create a via header for port " + sipStackSharing.getLP("UDP").getPort()), (Throwable)ex);
            throw new OperationFailedException("Unable to create a via header for port " + sipStackSharing.getLP("UDP").getPort(), 4, (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Object)("Unable to create a via header for port " + sipStackSharing.getLP("UDP").getPort()), (Throwable)ex);
            throw new OperationFailedException("Unable to create a via header for port " + sipStackSharing.getLP("UDP").getPort(), 2, (Throwable)ex);
        }
    }

    public MaxForwardsHeader getMaxForwardsHeader() throws OperationFailedException {
        if (this.maxForwardsHeader == null) {
            try {
                this.maxForwardsHeader = this.headerFactory.createMaxForwardsHeader(70);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("generated max forwards: " + this.maxForwardsHeader.toString()));
                }
            }
            catch (InvalidArgumentException ex) {
                throw new OperationFailedException("A problem occurred while creating MaxForwardsHeader", 4, (Throwable)ex);
            }
        }
        return this.maxForwardsHeader;
    }

    public ContactHeader getContactHeader(Address intendedDestination) {
        return this.getContactHeader((SipURI)intendedDestination.getURI());
    }

    public ContactHeader getContactHeader(SipURI intendedDestination) {
        ContactHeader registrationContactHeader = null;
        ListeningPoint srcListeningPoint = this.getListeningPoint(intendedDestination);
        InetSocketAddress targetAddress = this.getIntendedDestination(intendedDestination);
        try {
            InetAddress localAddress = SipActivator.getNetworkAddressManagerService().getLocalHost(targetAddress.getAddress());
            SipURI contactURI = this.addressFactory.createSipURI(this.getAccountID().getUserID(), localAddress.getHostAddress());
            String transport = srcListeningPoint.getTransport();
            contactURI.setTransportParam(transport);
            int localPort = srcListeningPoint.getPort();
            if ("TCP".equalsIgnoreCase(transport) || "TLS".equalsIgnoreCase(transport)) {
                InetSocketAddress localSockAddr = sipStackSharing.getLocalAddressForDestination(targetAddress.getAddress(), targetAddress.getPort(), localAddress, transport);
                localPort = localSockAddr.getPort();
            }
            contactURI.setPort(localPort);
            String paramValue = this.getContactAddressCustomParamValue();
            if (paramValue != null) {
                contactURI.setParameter("registering_acc", paramValue);
            }
            Address contactAddress = this.addressFactory.createAddress((URI)contactURI);
            String ourDisplayName = this.getOurDisplayName();
            if (ourDisplayName != null) {
                contactAddress.setDisplayName(ourDisplayName);
            }
            registrationContactHeader = this.headerFactory.createContactHeader(contactAddress);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("generated contactHeader:" + registrationContactHeader));
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"A ParseException occurred while creating From Header!", (Throwable)ex);
            throw new IllegalArgumentException("A ParseException occurred while creating From Header!", ex);
        }
        catch (IOException ex) {
            logger.error((Object)"A ParseException occurred while creating From Header!", (Throwable)ex);
            throw new IllegalArgumentException("A ParseException occurred while creating From Header!", ex);
        }
        return registrationContactHeader;
    }

    public String getContactAddressCustomParamValue() {
        SipRegistrarConnection src = this.sipRegistrarConnection;
        if (src != null && !src.isRegistrarless()) {
            String hostValue = ((SipURI)src.getAddressOfRecord().getURI()).getHost().replace('.', '_');
            return hostValue;
        }
        return null;
    }

    public AddressFactoryEx getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public SipMessageFactory getMessageFactory() {
        if (this.messageFactory == null) {
            this.messageFactory = new SipMessageFactory(this, (MessageFactory)new MessageFactoryImpl());
        }
        return this.messageFactory;
    }

    public static Set<ProtocolProviderServiceSipImpl> getAllInstances() {
        try {
            HashSet<ProtocolProviderServiceSipImpl> instances = new HashSet<ProtocolProviderServiceSipImpl>();
            BundleContext context = SipActivator.getBundleContext();
            Collection references = context.getServiceReferences(ProtocolProviderService.class, null);
            for (ServiceReference ref : references) {
                ProtocolProviderService service = (ProtocolProviderService)context.getService(ref);
                if (!(service instanceof ProtocolProviderServiceSipImpl)) continue;
                instances.add((ProtocolProviderServiceSipImpl)service);
            }
            return instances;
        }
        catch (InvalidSyntaxException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Problem parcing an osgi expression", (Throwable)ex);
            }
            throw new RuntimeException("getServiceReferences() wasn't supposed to fail!");
        }
    }

    public ListeningPoint getListeningPoint(String transport) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Query for a " + transport + " listening point"));
        }
        if (this.connection.getAddress() != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Will use proxy address");
            }
            transport = this.connection.getTransport();
        }
        if (!ProtocolProviderServiceSipImpl.isValidTransport(transport)) {
            transport = this.getDefaultTransport();
        }
        ListeningPoint lp = null;
        if (transport.equalsIgnoreCase("UDP")) {
            lp = sipStackSharing.getLP("UDP");
        } else if (transport.equalsIgnoreCase("TCP")) {
            lp = sipStackSharing.getLP("TCP");
        } else if (transport.equalsIgnoreCase("TLS")) {
            lp = sipStackSharing.getLP("TLS");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Returning LP " + lp + " for transport [" + transport + "] and "));
        }
        return lp;
    }

    public ListeningPoint getListeningPoint(SipURI intendedDestination) {
        return this.getListeningPoint(intendedDestination.getTransportParam());
    }

    public SipProvider getJainSipProvider(String transport) {
        return sipStackSharing.getJainSipProvider(transport);
    }

    public SipSecurityManager getSipSecurityManager() {
        return this.sipSecurityManager;
    }

    private void initRegistrarConnection() throws IllegalArgumentException {
        String userID;
        int index;
        String registrarAddressStr = this.accountID.getAccountPropertyString((Object)"SERVER_ADDRESS");
        if (registrarAddressStr == null && (index = (userID = this.accountID.getAccountPropertyString((Object)"USER_ID")).indexOf(64)) > -1) {
            registrarAddressStr = userID.substring(index + 1);
        }
        if (registrarAddressStr == null || registrarAddressStr.trim().length() == 0) {
            this.initRegistrarlessConnection();
            return;
        }
        int registrarPort = 5060;
        if ((registrarPort = this.accountID.getAccountPropertyInt((Object)"SERVER_PORT", registrarPort)) > 65535) {
            throw new IllegalArgumentException(registrarPort + " is larger than " + 65535 + " and does not therefore represent a valid port number.");
        }
        this.sipRegistrarConnection = new SipRegistrarConnection(registrarAddressStr, registrarPort, this.getRegistrarTransport(), this);
    }

    private void initRegistrarlessConnection() throws IllegalArgumentException {
        String registrarTransport = this.getRegistrarTransport();
        this.sipRegistrarConnection = new SipRegistrarlessConnection(this, registrarTransport);
    }

    private String getRegistrarTransport() {
        String registrarTransport = this.accountID.getAccountPropertyString((Object)"SERVER_TRANSPORT");
        if (!StringUtils.isNullOrEmpty((String)registrarTransport)) {
            if (!(registrarTransport.equals("UDP") || registrarTransport.equals("TCP") || registrarTransport.equals("TLS"))) {
                throw new IllegalArgumentException(registrarTransport + " is not a valid transport protocol. SERVER_TRANSPORT must be left blank or set to TCP, UDP or TLS.");
            }
        } else {
            registrarTransport = this.getDefaultTransport();
        }
        return registrarTransport;
    }

    public Address getOurSipAddress(Address intendedDestination) {
        return this.getOurSipAddress((SipURI)intendedDestination.getURI());
    }

    public Address getOurSipAddress(SipURI intendedDestination) {
        SipRegistrarConnection src = this.sipRegistrarConnection;
        if (src != null && !src.isRegistrarless()) {
            return src.getAddressOfRecord();
        }
        InetSocketAddress destinationAddr = this.getIntendedDestination(intendedDestination);
        InetAddress localHost = SipActivator.getNetworkAddressManagerService().getLocalHost(destinationAddr.getAddress());
        String userID = this.getAccountID().getUserID();
        try {
            SipURI ourSipURI = this.getAddressFactory().createSipURI(userID, localHost.getHostAddress());
            ListeningPoint lp = this.getListeningPoint(intendedDestination);
            ourSipURI.setTransportParam(lp.getTransport());
            ourSipURI.setPort(lp.getPort());
            Address ourSipAddress = this.getAddressFactory().createAddress(this.getOurDisplayName(), (URI)ourSipURI);
            ourSipAddress.setDisplayName(this.getOurDisplayName());
            return ourSipAddress;
        }
        catch (ParseException exc) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Failed to create our SIP AOR address", (Throwable)exc);
            }
            throw new IllegalArgumentException("Failed to create our SIP AOR address", exc);
        }
    }

    public ProxyConnection getConnection() {
        return this.connection;
    }

    public boolean isSignalingTransportSecure() {
        return "TLS".equalsIgnoreCase(this.connection.getTransport());
    }

    public TransportProtocol getTransportProtocol() {
        if (this.sipRegistrarConnection == null || this.sipRegistrarConnection instanceof SipRegistrarlessConnection) {
            return TransportProtocol.UNKNOWN;
        }
        return TransportProtocol.parse((String)this.sipRegistrarConnection.getTransport());
    }

    public void registerMethodProcessor(String method, MethodProcessor methodProcessor) {
        List<MethodProcessor> processors = this.methodProcessors.get(method);
        if (processors == null) {
            processors = new LinkedList<MethodProcessor>();
            this.methodProcessors.put(method, processors);
        } else {
            String eventPackage;
            Iterator<MethodProcessor> processorIter = processors.iterator();
            Class<?> methodProcessorClass = methodProcessor.getClass();
            String string = eventPackage = methodProcessor instanceof EventPackageSupport ? ((EventPackageSupport)methodProcessor).getEventPackage() : null;
            while (processorIter.hasNext()) {
                MethodProcessor processor = processorIter.next();
                if (!processor.getClass().equals(methodProcessorClass) || eventPackage != null && processor instanceof EventPackageSupport && !eventPackage.equals(((EventPackageSupport)processor).getEventPackage())) continue;
                processorIter.remove();
            }
        }
        processors.add(methodProcessor);
    }

    public void unregisterMethodProcessor(String method, MethodProcessor methodProcessor) {
        List<MethodProcessor> processors = this.methodProcessors.get(method);
        if (processors != null && processors.remove(methodProcessor) && processors.size() <= 0) {
            this.methodProcessors.remove(method);
        }
    }

    public String getDefaultTransport() {
        if (this.sipRegistrarConnection != null && !this.sipRegistrarConnection.isRegistrarless() && this.connection != null && this.connection.getAddress() != null && this.connection.getTransport() != null) {
            return this.connection.getTransport();
        }
        String userSpecifiedDefaultTransport = SipActivator.getConfigurationService().getString(DEFAULT_TRANSPORT);
        if (userSpecifiedDefaultTransport != null) {
            return userSpecifiedDefaultTransport;
        }
        String defTransportDefaultValue = SipActivator.getResources().getSettingsString(DEFAULT_TRANSPORT);
        if (!StringUtils.isNullOrEmpty((String)defTransportDefaultValue)) {
            return defTransportDefaultValue;
        }
        return "UDP";
    }

    public SipProvider getDefaultJainSipProvider() {
        return this.getJainSipProvider(this.getDefaultTransport());
    }

    public String getOurDisplayName() {
        return this.ourDisplayName;
    }

    boolean setOurDisplayName(String newDisplayName) {
        if (newDisplayName != null && !this.ourDisplayName.equals(newDisplayName)) {
            this.getAccountID().putAccountProperty("DISPLAY_NAME", newDisplayName);
            this.ourDisplayName = newDisplayName;
            OperationSetServerStoredAccountInfoSipImpl accountInfoOpSet = (OperationSetServerStoredAccountInfoSipImpl)this.getOperationSet(OperationSetServerStoredAccountInfo.class);
            if (accountInfoOpSet != null) {
                accountInfoOpSet.setOurDisplayName(newDisplayName);
            }
            return true;
        }
        return false;
    }

    public UserAgentHeader getSipCommUserAgentHeader() {
        if (this.userAgentHeader == null) {
            try {
                LinkedList<String> userAgentTokens = new LinkedList<String>();
                Version ver = SipActivator.getVersionService().getCurrentVersion();
                userAgentTokens.add(ver.getApplicationName());
                userAgentTokens.add(ver.toString());
                String osName = System.getProperty("os.name");
                userAgentTokens.add(osName);
                this.userAgentHeader = this.headerFactory.createUserAgentHeader(userAgentTokens);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return this.userAgentHeader;
    }

    public void sayErrorSilently(ServerTransaction serverTransaction, int errorCode) {
        block2: {
            try {
                this.sayError(serverTransaction, errorCode);
            }
            catch (OperationFailedException exc) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("Failed to send an error " + errorCode + " response"), (Throwable)exc);
            }
        }
    }

    public void sendAck(ClientTransaction clientTransaction) throws SipException, InvalidArgumentException {
        Request ack = this.messageFactory.createAck(clientTransaction);
        clientTransaction.getDialog().sendAck(ack);
    }

    public void sayError(ServerTransaction serverTransaction, int errorCode) throws OperationFailedException {
        this.sayError(serverTransaction, errorCode, null);
    }

    public void sayError(ServerTransaction serverTransaction, int errorCode, Header header) throws OperationFailedException {
        Request request = serverTransaction.getRequest();
        Response errorResponse = null;
        try {
            errorResponse = this.getMessageFactory().createResponse(errorCode, request);
            if (header != null) {
                errorResponse.setHeader(header);
            }
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to construct an OK response to an INVITE request", 4, ex, logger);
        }
        try {
            serverTransaction.sendResponse(errorResponse);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent response: " + errorResponse));
            }
        }
        catch (Exception ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to send an OK response to an INVITE request", 4, ex, logger);
        }
    }

    public void sendInDialogRequest(SipProvider sipProvider, Request request, Dialog dialog) throws OperationFailedException {
        ClientTransaction clientTransaction = null;
        try {
            clientTransaction = sipProvider.getNewClientTransaction(request);
        }
        catch (TransactionUnavailableException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create a client transaction for request:\n" + request, 4, ex, logger);
        }
        try {
            dialog.sendRequest(clientTransaction);
        }
        catch (SipException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to send request:\n" + request, 2, ex, logger);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sent request:\n" + request));
        }
    }

    public List<String> getSupportedMethods() {
        return new ArrayList<String>(this.methodProcessors.keySet());
    }

    public ProtocolIcon getProtocolIcon() {
        return this.protocolIcon;
    }

    SipStatusEnum getSipStatusEnum() {
        return this.sipStatusEnum;
    }

    public SipRegistrarConnection getRegistrarConnection() {
        return this.sipRegistrarConnection;
    }

    public Address parseAddressString(String uriStr) throws ParseException {
        SipRegistrarConnection src;
        if ((uriStr = uriStr.trim()).toLowerCase().startsWith("tel:")) {
            uriStr = uriStr.substring("tel:".length());
        } else if (uriStr.toLowerCase().startsWith("callto:")) {
            uriStr = uriStr.substring("callto:".length());
        } else if (uriStr.toLowerCase().startsWith("sips:")) {
            uriStr = uriStr.substring("sips:".length());
        }
        String user = uriStr;
        String remainder = "";
        int at = uriStr.indexOf(64);
        if (at > -1) {
            user = uriStr.substring(0, at);
            remainder = uriStr.substring(at);
        }
        String banned = "([^a-z0-9-_.!~*'()&=+$,;?/])+";
        user = user.replaceAll(banned, "") + remainder;
        if (at == -1 && (src = this.sipRegistrarConnection) != null && !src.isRegistrarless()) {
            uriStr = user + "@" + ((SipURI)src.getAddressOfRecord().getURI()).getHost();
        }
        if (!uriStr.toLowerCase().startsWith("sip:")) {
            uriStr = "sip:" + uriStr;
        }
        Address toAddress = this.getAddressFactory().createAddress(uriStr);
        return toAddress;
    }

    public InetSocketAddress getIntendedDestination(Address destination) throws IllegalArgumentException {
        return this.getIntendedDestination((SipURI)destination.getURI());
    }

    public InetSocketAddress getIntendedDestination(SipURI destination) throws IllegalArgumentException {
        InetSocketAddress destinationInetAddress = null;
        InetSocketAddress outboundProxy = this.connection.getAddress();
        if (outboundProxy != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Will use proxy address");
            }
            destinationInetAddress = outboundProxy;
        } else {
            int port;
            String transport = destination.getTransportParam();
            if (transport == null) {
                transport = this.getDefaultTransport();
            }
            if ((port = destination.getPort()) == -1) {
                port = 5060;
            }
            AutoProxyConnection tempConn = new AutoProxyConnection((SipAccountIDImpl)this.getAccountID(), destination.getHost(), port, transport);
            try {
                if (!tempConn.getNextAddress()) {
                    throw new IllegalArgumentException(destination.getHost() + " could not be resolved to an internet address.");
                }
                destinationInetAddress = tempConn.getAddress();
            }
            catch (DnssecException e) {
                logger.error((Object)"unable to obtain next hop address", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning address " + destinationInetAddress + " for destination " + destination.getHost()));
        }
        return destinationInetAddress;
    }

    public void registrationStateChanged(RegistrationStateChangeEvent event) {
        if (event.getNewState() == RegistrationState.UNREGISTERED || event.getNewState() == RegistrationState.CONNECTION_FAILED) {
            ProtocolProviderServiceSipImpl listener = (ProtocolProviderServiceSipImpl)event.getProvider();
            sipStackSharing.removeSipListener(listener);
            listener.removeRegistrationStateChangeListener(this);
        }
    }

    public static void throwOperationFailedException(String message, int errorCode, Throwable cause, Logger logger) throws OperationFailedException {
        logger.error((Object)message, cause);
        if (cause == null) {
            throw new OperationFailedException(message, errorCode);
        }
        throw new OperationFailedException(message, errorCode, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEarlyMessageProcessor(SipMessageProcessor processor) {
        List<SipMessageProcessor> list = this.earlyProcessors;
        synchronized (list) {
            if (!this.earlyProcessors.contains(processor)) {
                this.earlyProcessors.add(processor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEarlyMessageProcessor(SipMessageProcessor processor) {
        List<SipMessageProcessor> list = this.earlyProcessors;
        synchronized (list) {
            this.earlyProcessors.remove(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void earlyProcessMessage(EventObject message) {
        List<SipMessageProcessor> list = this.earlyProcessors;
        synchronized (list) {
            for (SipMessageProcessor listener : this.earlyProcessors) {
                try {
                    if (message instanceof RequestEvent) {
                        listener.processMessage((RequestEvent)message);
                        continue;
                    }
                    if (message instanceof ResponseEvent) {
                        listener.processResponse((ResponseEvent)message, null);
                        continue;
                    }
                    if (!(message instanceof TimeoutEvent)) continue;
                    listener.processTimeout((TimeoutEvent)message, null);
                }
                catch (Throwable t) {
                    logger.error((Object)"Error pre-processing message", t);
                }
            }
        }
    }

    boolean registerUsingNextAddress() {
        if (this.connection == null) {
            return false;
        }
        try {
            if (this.sipRegistrarConnection.isRegistrarless()) {
                this.sipRegistrarConnection.setTransport(this.getDefaultTransport());
                this.sipRegistrarConnection.register();
                return true;
            }
            if (this.connection.getNextAddress()) {
                this.sipRegistrarConnection.setTransport(this.connection.getTransport());
                this.sipRegistrarConnection.register();
                return true;
            }
        }
        catch (DnssecException e) {
            logger.error((Object)("DNSSEC failure while getting address for " + (Object)((Object)this)), (Throwable)e);
            this.fireRegistrationStateChanged(RegistrationState.REGISTERING, RegistrationState.UNREGISTERED, 0, "Invalid or inaccessible server address.");
            return true;
        }
        catch (Throwable e) {
            logger.error((Object)"Cannot send register!", e);
            this.sipRegistrarConnection.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "A timeout occurred while trying to connect to the server.");
        }
        this.connection.reset();
        return false;
    }

    protected void notifyConnectionFailed() {
        if (this.sipRegistrarConnection.isRegistrarless()) {
            return;
        }
        if (this.getRegistrationState().equals((Object)RegistrationState.REGISTERED) && this.sipRegistrarConnection != null) {
            this.sipRegistrarConnection.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "A timeout occurred while trying to connect to the server.");
        }
        if (this.registerUsingNextAddress()) {
            return;
        }
        if (!this.getRegistrationState().equals((Object)RegistrationState.UNREGISTERED)) {
            this.sipRegistrarConnection.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "A timeout occurred while trying to connect to the server.");
        }
    }

    public static boolean isValidTransport(String transport) {
        return "UDP".equalsIgnoreCase(transport) || "TLS".equalsIgnoreCase(transport) || "TCP".equalsIgnoreCase(transport);
    }

    private static class ShutdownUnregistrationBlockListener
    implements RegistrationStateChangeListener {
        public List<RegistrationState> collectedNewStates = new LinkedList<RegistrationState>();

        private ShutdownUnregistrationBlockListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received a RegistrationStateChangeEvent: " + evt));
            }
            this.collectedNewStates.add(evt.getNewState());
            if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"We're unregistered and will notify those who wait");
                }
                ShutdownUnregistrationBlockListener shutdownUnregistrationBlockListener = this;
                synchronized (shutdownUnregistrationBlockListener) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Waiting for a RegistrationStateChangeEvent.UNREGISTERED");
            }
            ShutdownUnregistrationBlockListener shutdownUnregistrationBlockListener = this;
            synchronized (shutdownUnregistrationBlockListener) {
                block12: {
                    if (this.collectedNewStates.contains(RegistrationState.UNREGISTERED)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Event already received. " + this.collectedNewStates));
                        }
                        return;
                    }
                    try {
                        this.wait(waitFor);
                        if (this.collectedNewStates.size() > 0) {
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)"Received a RegistrationStateChangeEvent.");
                            } else if (logger.isTraceEnabled()) {
                                logger.trace((Object)("No RegistrationStateChangeEvent received for " + waitFor + "ms."));
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug((Object)"Interrupted while waiting for a RegistrationStateChangeEvent", (Throwable)ex);
                    }
                }
            }
        }
    }

    protected class ShutdownThread
    implements Runnable {
        protected ShutdownThread() {
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Killing the SIP Protocol Provider.");
            }
            OperationSetBasicTelephonySipImpl telephony = (OperationSetBasicTelephonySipImpl)ProtocolProviderServiceSipImpl.this.getOperationSet(OperationSetBasicTelephony.class);
            telephony.shutdown();
            if (ProtocolProviderServiceSipImpl.this.isRegistered()) {
                try {
                    ShutdownUnregistrationBlockListener listener = new ShutdownUnregistrationBlockListener();
                    ProtocolProviderServiceSipImpl.this.addRegistrationStateChangeListener(listener);
                    ProtocolProviderServiceSipImpl.this.unregister();
                    listener.waitForEvent(3000L);
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)("Failed to properly unregister before shutting down. " + ProtocolProviderServiceSipImpl.this.getAccountID()), (Throwable)ex);
                }
            }
            if (ProtocolProviderServiceSipImpl.this.capabilities != null) {
                ProtocolProviderServiceSipImpl.this.capabilities.shutdown();
                ProtocolProviderServiceSipImpl.this.capabilities = null;
            }
            if (ProtocolProviderServiceSipImpl.this.opSetPersPresence != null) {
                ProtocolProviderServiceSipImpl.this.opSetPersPresence.shutdown();
                ProtocolProviderServiceSipImpl.this.opSetPersPresence = null;
            }
            if (ProtocolProviderServiceSipImpl.this.opSetBasicIM != null) {
                ProtocolProviderServiceSipImpl.this.opSetBasicIM.shutdown();
                ProtocolProviderServiceSipImpl.this.opSetBasicIM = null;
            }
            if (ProtocolProviderServiceSipImpl.this.opSetMWI != null) {
                ProtocolProviderServiceSipImpl.this.opSetMWI.shutdown();
                ProtocolProviderServiceSipImpl.this.opSetMWI = null;
            }
            if (ProtocolProviderServiceSipImpl.this.opSetSSAccountInfo != null) {
                ProtocolProviderServiceSipImpl.this.opSetSSAccountInfo.shutdown();
                ProtocolProviderServiceSipImpl.this.opSetSSAccountInfo = null;
            }
            if (ProtocolProviderServiceSipImpl.this.opSetTypingNotif != null) {
                ProtocolProviderServiceSipImpl.this.opSetTypingNotif.shutdown();
                ProtocolProviderServiceSipImpl.this.opSetTypingNotif = null;
            }
            ProtocolProviderServiceSipImpl.this.headerFactory = null;
            ProtocolProviderServiceSipImpl.this.messageFactory = null;
            ProtocolProviderServiceSipImpl.this.addressFactory = null;
            ProtocolProviderServiceSipImpl.this.sipSecurityManager = null;
            ProtocolProviderServiceSipImpl.this.connection = null;
            ProtocolProviderServiceSipImpl.this.methodProcessors.clear();
            ProtocolProviderServiceSipImpl.this.isInitialized = false;
        }
    }
}

