/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.configuration;

import java.util.Hashtable;
import java.util.Set;
import org.jitsi.impl.configuration.ConfigurationStore;

public abstract class HashtableConfigurationStore<T extends Hashtable>
implements ConfigurationStore {
    protected final T properties;

    protected HashtableConfigurationStore(T properties) {
        this.properties = properties;
    }

    @Override
    public Object getProperty(String name) {
        Object value = ((Hashtable)this.properties).get(name);
        return value != null ? value : System.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPropertyNames() {
        T t = this.properties;
        synchronized (t) {
            Set propertyNames = ((Hashtable)this.properties).keySet();
            return propertyNames.toArray(new String[propertyNames.size()]);
        }
    }

    @Override
    public boolean isSystemProperty(String name) {
        return System.getProperty(name) != null;
    }

    @Override
    public void removeProperty(String name) {
        ((Hashtable)this.properties).remove(name);
    }

    @Override
    public void setNonSystemProperty(String name, Object value) {
        ((Hashtable)this.properties).put((String)name, (Object)value);
    }

    @Override
    public void setSystemProperty(String name) {
        this.removeProperty(name);
    }
}

