/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferStream;
import org.jitsi.impl.neomedia.conference.InDataSourceDesc;
import org.jitsi.impl.neomedia.conference.InSampleDesc;
import org.jitsi.impl.neomedia.conference.InStreamDesc;
import org.jitsi.impl.neomedia.conference.ShortArrayCache;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.impl.neomedia.protocol.CachingPushBufferStream;
import org.jitsi.impl.neomedia.protocol.StreamSubstituteBufferTransferHandler;
import org.jitsi.util.ArrayIOUtils;
import org.jitsi.util.Logger;

class AudioMixerPushBufferStream
extends ControlsAdapter
implements PushBufferStream {
    private static final Logger logger = Logger.getLogger(AudioMixerPushBufferStream.class);
    private final AudioMixer audioMixer;
    private InStreamDesc[] inStreams;
    private final Object inStreamsSyncRoot = new Object();
    private final ShortArrayCache shortArrayCache = new ShortArrayCache();
    private AudioFormat lastReadInFormat;
    private final AudioFormat outFormat;
    private final List<AudioMixingPushBufferStream> outStreams = new ArrayList<AudioMixingPushBufferStream>();
    private long outStreamsGeneration;
    private final BufferTransferHandler transferHandler = new BufferTransferHandler(){
        private final Buffer buffer = new Buffer();

        public void transferData(PushBufferStream stream) {
            this.buffer.setDiscard(false);
            this.buffer.setFlags(0);
            this.buffer.setLength(0);
            this.buffer.setOffset(0);
            AudioMixerPushBufferStream.this.transferData(this.buffer);
        }
    };
    private AudioMixingPushBufferStream[] unmodifiableOutStreams;

    public AudioMixerPushBufferStream(AudioMixer audioMixer, AudioFormat outFormat) {
        this.audioMixer = audioMixer;
        this.outFormat = outFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOutStream(AudioMixingPushBufferStream outStream) throws IOException {
        if (outStream == null) {
            throw new IllegalArgumentException("outStream");
        }
        boolean start = false;
        long generation = 0L;
        List<AudioMixingPushBufferStream> list = this.outStreams;
        synchronized (list) {
            if (!this.outStreams.contains(outStream) && this.outStreams.add(outStream)) {
                this.unmodifiableOutStreams = null;
                if (this.outStreams.size() == 1) {
                    start = true;
                    generation = ++this.outStreamsGeneration;
                }
            }
        }
        if (start) {
            this.audioMixer.start(this, generation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endOfStream() {
        Object object = this.inStreamsSyncRoot;
        synchronized (object) {
            if (this.inStreams != null) {
                for (InStreamDesc inStreamDesc : this.inStreams) {
                    if (inStreamDesc.getInStream().endOfStream()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void equalizeInStreamBufferLength() {
        Object object = this.inStreamsSyncRoot;
        synchronized (object) {
            if (this.inStreams == null || this.inStreams.length < 1) {
                return;
            }
            BufferControl bufferControl = this.getBufferControl(this.inStreams[0]);
            long bufferLength = bufferControl == null ? 20L : bufferControl.getBufferLength();
            for (int i = 1; i < this.inStreams.length; ++i) {
                BufferControl inStreamBufferControl = this.getBufferControl(this.inStreams[i]);
                if (inStreamBufferControl == null) continue;
                inStreamBufferControl.setBufferLength(bufferLength);
            }
        }
    }

    private BufferControl getBufferControl(InStreamDesc inStreamDesc) {
        BufferControl bufferControl;
        BufferControl bufferControl2;
        InDataSourceDesc inDataSourceDesc = inStreamDesc.inDataSourceDesc;
        DataSource effectiveInDataSource = inDataSourceDesc.getEffectiveInDataSource();
        String bufferControlType = BufferControl.class.getName();
        if (effectiveInDataSource != null && (bufferControl2 = (BufferControl)effectiveInDataSource.getControl(bufferControlType)) != null) {
            return bufferControl2;
        }
        DataSource inDataSource = inDataSourceDesc.inDataSource;
        if (inDataSource != null && inDataSource != effectiveInDataSource && (bufferControl = (BufferControl)inDataSource.getControl(bufferControlType)) != null) {
            return bufferControl;
        }
        return (BufferControl)inStreamDesc.getInStream().getControl(bufferControlType);
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor(this.audioMixer.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength() {
        long contentLength = 0L;
        Object object = this.inStreamsSyncRoot;
        synchronized (object) {
            if (this.inStreams != null) {
                for (InStreamDesc inStreamDesc : this.inStreams) {
                    long inContentLength = inStreamDesc.getInStream().getContentLength();
                    if (-1L == inContentLength) {
                        return -1L;
                    }
                    if (contentLength >= inContentLength) continue;
                    contentLength = inContentLength;
                }
            }
        }
        return contentLength;
    }

    public AudioFormat getFormat() {
        return this.outFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InStreamDesc[] getInStreams() {
        Object object = this.inStreamsSyncRoot;
        synchronized (object) {
            return this.inStreams == null ? null : (InStreamDesc[])this.inStreams.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        int maxInSampleCount;
        InSampleDesc inSampleDesc;
        AudioFormat format = this.getFormat();
        Object object = this.inStreamsSyncRoot;
        synchronized (object) {
            InStreamDesc[] inStreams = this.inStreams;
            if (inStreams == null || inStreams.length == 0) {
                return;
            }
            inSampleDesc = (InSampleDesc)buffer.getData();
            if (inSampleDesc != null && inSampleDesc.format != format) {
                inSampleDesc = null;
            }
            int inStreamCount = inStreams.length;
            if (inSampleDesc != null) {
                InStreamDesc[] inSampleDescInStreams = inSampleDesc.inStreams;
                if (inSampleDescInStreams.length == inStreamCount) {
                    for (int i = 0; i < inStreamCount; ++i) {
                        if (inSampleDescInStreams[i] == inStreams[i]) continue;
                        inSampleDesc = null;
                        break;
                    }
                } else {
                    inSampleDesc = null;
                }
            }
            if (inSampleDesc == null) {
                inSampleDesc = new InSampleDesc(new short[inStreamCount][], (InStreamDesc[])inStreams.clone(), format);
            }
        }
        try {
            maxInSampleCount = this.readInPushBufferStreams(format, inSampleDesc);
        }
        catch (UnsupportedFormatException ufex) {
            IOException ioex = new IOException();
            ioex.initCause(ufex);
            throw ioex;
        }
        maxInSampleCount = Math.max(maxInSampleCount, this.readInPullBufferStreams(format, maxInSampleCount, inSampleDesc));
        buffer.setData((Object)inSampleDesc);
        buffer.setLength(maxInSampleCount);
        long timeStamp = inSampleDesc.getTimeStamp();
        if (timeStamp != -1L) {
            buffer.setTimeStamp(timeStamp);
        }
    }

    private int readInPullBufferStreams(AudioFormat outFormat, int outSampleCount, InSampleDesc inSampleDesc) throws IOException {
        InStreamDesc[] inStreams = inSampleDesc.inStreams;
        int maxInSampleCount = 0;
        for (InStreamDesc inStream : inStreams) {
            if (!(inStream.getInStream() instanceof PullBufferStream)) continue;
            throw new UnsupportedOperationException(AudioMixerPushBufferStream.class.getSimpleName() + ".readInPullBufferStreams(AudioFormat,int,InSampleDesc)");
        }
        return maxInSampleCount;
    }

    private void readInPushBufferStream(InStreamDesc inStreamDesc, AudioFormat outFormat, int sampleCount, Buffer outBuffer) throws IOException, UnsupportedFormatException {
        Object inData;
        double outSampleRate;
        int outChannels;
        int inFormatSigned;
        PushBufferStream inStream = (PushBufferStream)inStreamDesc.getInStream();
        AudioFormat inStreamFormat = (AudioFormat)inStream.getFormat();
        Buffer inBuffer = inStreamDesc.getBuffer(true);
        if (sampleCount != 0) {
            if (Format.byteArray.equals(inStreamFormat.getDataType())) {
                Object data = inBuffer.getData();
                int length = sampleCount * (inStreamFormat.getSampleSizeInBits() / 8);
                if (!(data instanceof byte[]) || ((byte[])data).length != length) {
                    inBuffer.setData((Object)new byte[length]);
                }
            } else {
                throw new UnsupportedFormatException("!Format.getDataType().equals(byte[].class)", (Format)inStreamFormat);
            }
        }
        inBuffer.setDiscard(false);
        inBuffer.setFlags(0);
        inBuffer.setLength(0);
        inBuffer.setOffset(0);
        this.audioMixer.read(inStream, inBuffer, inStreamDesc.inDataSourceDesc.inDataSource);
        if (inBuffer.isDiscard()) {
            outBuffer.setDiscard(true);
            return;
        }
        int inLength = inBuffer.getLength();
        if (inLength <= 0) {
            outBuffer.setDiscard(true);
            return;
        }
        AudioFormat inFormat = (AudioFormat)inBuffer.getFormat();
        if (inFormat == null) {
            inFormat = inStreamFormat;
        }
        if (logger.isTraceEnabled()) {
            if (this.lastReadInFormat == null) {
                this.lastReadInFormat = inFormat;
            } else if (!this.lastReadInFormat.matches((Format)inFormat)) {
                this.lastReadInFormat = inFormat;
                logger.trace("Read inSamples in different format " + this.lastReadInFormat);
            }
        }
        if ((inFormatSigned = inFormat.getSigned()) != 1 && inFormatSigned != -1) {
            throw new UnsupportedFormatException("AudioFormat.getSigned()", (Format)inFormat);
        }
        int inChannels = inFormat.getChannels();
        if (inChannels != (outChannels = outFormat.getChannels()) && inChannels != -1 && outChannels != -1) {
            logger.error("Read inFormat with channels " + inChannels + " while expected outFormat channels is " + outChannels);
            throw new UnsupportedFormatException("AudioFormat.getChannels()", (Format)inFormat);
        }
        double inSampleRate = inFormat.getSampleRate();
        if (inSampleRate != (outSampleRate = outFormat.getSampleRate())) {
            logger.warn("Read inFormat with sampleRate " + inSampleRate + " while expected outFormat sampleRate is " + outSampleRate);
        }
        if ((inData = inBuffer.getData()) == null) {
            outBuffer.setDiscard(true);
        } else if (inData instanceof byte[]) {
            int outLength;
            int inSampleSizeInBits = inFormat.getSampleSizeInBits();
            int outSampleSizeInBits = outFormat.getSampleSizeInBits();
            if (logger.isTraceEnabled() && inSampleSizeInBits != outSampleSizeInBits) {
                logger.trace("Read inFormat with sampleSizeInBits " + inSampleSizeInBits + ". Will convert to sampleSizeInBits " + outSampleSizeInBits);
            }
            byte[] inSamples = (byte[])inData;
            block0 : switch (inSampleSizeInBits) {
                case 16: {
                    outLength = inLength / 2;
                    short[] outSamples = this.shortArrayCache.validateShortArraySize(outBuffer, outLength);
                    switch (outSampleSizeInBits) {
                        case 16: {
                            for (int i = 0; i < outLength; ++i) {
                                outSamples[i] = ArrayIOUtils.readShort(inSamples, i * 2);
                            }
                            break block0;
                        }
                        default: {
                            throw new UnsupportedFormatException("AudioFormat.getSampleSizeInBits()", (Format)outFormat);
                        }
                    }
                }
                default: {
                    throw new UnsupportedFormatException("AudioFormat.getSampleSizeInBits()", (Format)inFormat);
                }
            }
            outBuffer.setFlags(inBuffer.getFlags());
            outBuffer.setFormat((Format)outFormat);
            outBuffer.setLength(outLength);
            outBuffer.setOffset(0);
            outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        } else {
            throw new UnsupportedFormatException("Format.getDataType().equals(" + inData.getClass() + ")", (Format)inFormat);
        }
    }

    private int readInPushBufferStreams(AudioFormat outFormat, InSampleDesc inSampleDesc) throws IOException, UnsupportedFormatException {
        InStreamDesc[] inStreams = inSampleDesc.inStreams;
        Buffer buffer = inSampleDesc.getBuffer();
        int maxInSampleCount = 0;
        short[][] inSamples = inSampleDesc.inSamples;
        for (int i = 0; i < inStreams.length; ++i) {
            InStreamDesc inStreamDesc = inStreams[i];
            SourceStream inStream = inStreamDesc.getInStream();
            if (inStream instanceof PushBufferStream) {
                short[] samples;
                int sampleCount;
                buffer.setDiscard(false);
                buffer.setFlags(0);
                buffer.setLength(0);
                buffer.setOffset(0);
                this.readInPushBufferStream(inStreamDesc, outFormat, maxInSampleCount, buffer);
                if (buffer.isDiscard()) {
                    sampleCount = 0;
                    samples = null;
                } else {
                    sampleCount = buffer.getLength();
                    if (sampleCount <= 0) {
                        sampleCount = 0;
                        samples = null;
                    } else {
                        samples = (short[])buffer.getData();
                    }
                }
                if (sampleCount != 0) {
                    buffer.setData(null);
                    if (samples.length > sampleCount) {
                        Arrays.fill(samples, sampleCount, samples.length, (short)0);
                    }
                    Object object = inSamples[i] = (Object)((buffer.getFlags() & 4) == 0 ? samples : null);
                    if (maxInSampleCount < samples.length) {
                        maxInSampleCount = samples.length;
                    }
                    if (inSampleDesc.getTimeStamp() != -1L) continue;
                    inSampleDesc.setTimeStamp(buffer.getTimeStamp());
                    continue;
                }
            }
            inSamples[i] = null;
        }
        return maxInSampleCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOutStream(AudioMixingPushBufferStream outStream) throws IOException {
        boolean stop = false;
        long generation = 0L;
        List<AudioMixingPushBufferStream> list = this.outStreams;
        synchronized (list) {
            if (outStream != null && this.outStreams.remove(outStream)) {
                this.unmodifiableOutStreams = null;
                if (this.outStreams.isEmpty()) {
                    stop = true;
                    generation = ++this.outStreamsGeneration;
                }
            }
        }
        if (stop) {
            this.audioMixer.stop(this, generation);
        }
    }

    private void setInSamples(AudioMixingPushBufferStream outStream, InSampleDesc inSampleDesc, int maxInSampleCount) {
        short[][] inSamples = inSampleDesc.inSamples;
        InStreamDesc[] inStreams = inSampleDesc.inStreams;
        inSamples = (short[][])inSamples.clone();
        CaptureDevice captureDevice = this.audioMixer.captureDevice;
        AudioMixingPushBufferDataSource outDataSource = outStream.getDataSource();
        boolean outDataSourceIsSendingDTMF = captureDevice instanceof AudioMixingPushBufferDataSource ? outDataSource.isSendingDTMF() : false;
        boolean outDataSourceIsMute = outDataSource.isMute();
        int o = 0;
        for (int i = 0; i < inSamples.length; ++i) {
            InStreamDesc inStreamDesc = inStreams[i];
            DataSource inDataSource = inStreamDesc.inDataSourceDesc.inDataSource;
            if (outDataSourceIsSendingDTMF && inDataSource == captureDevice) {
                PushBufferStream inStream = (PushBufferStream)inStreamDesc.getInStream();
                AudioFormat inStreamFormat = (AudioFormat)inStream.getFormat();
                short[] nextToneSignal = outDataSource.getNextToneSignal(inStreamFormat.getSampleRate(), inStreamFormat.getSampleSizeInBits());
                inSamples[i] = nextToneSignal;
                if (maxInSampleCount < nextToneSignal.length) {
                    maxInSampleCount = nextToneSignal.length;
                }
            } else if (outDataSource.equals(inStreamDesc.getOutDataSource()) || outDataSourceIsMute && inDataSource == captureDevice) {
                inSamples[i] = null;
            }
            short[] inStreamSamples = inSamples[i];
            if (inStreamSamples == null) continue;
            if (i != o) {
                inSamples[o] = inStreamSamples;
                inSamples[i] = null;
            }
            ++o;
        }
        outStream.setInSamples(inSamples, maxInSampleCount, inSampleDesc.getTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInStreams(Collection<InStreamDesc> inStreams) {
        boolean valueIsChanged;
        Object[] oldValue;
        Object[] newValue = null == inStreams ? null : inStreams.toArray(new InStreamDesc[inStreams.size()]);
        Object object = this.inStreamsSyncRoot;
        synchronized (object) {
            oldValue = this.inStreams;
            this.inStreams = newValue;
        }
        boolean bl = valueIsChanged = !Arrays.equals(oldValue, newValue);
        if (valueIsChanged) {
            if (oldValue != null) {
                this.setTransferHandler((InStreamDesc[])oldValue, null);
            }
            if (newValue == null) {
                return;
            }
            boolean skippedForTransferHandler = false;
            for (Object inStreamDesc : newValue) {
                SourceStream inStream = ((InStreamDesc)inStreamDesc).getInStream();
                if (!(inStream instanceof PushBufferStream)) continue;
                if (!skippedForTransferHandler) {
                    skippedForTransferHandler = true;
                    continue;
                }
                if (inStream instanceof CachingPushBufferStream) continue;
                CachingPushBufferStream cachingInStream = new CachingPushBufferStream((PushBufferStream)inStream);
                ((InStreamDesc)inStreamDesc).setInStream((SourceStream)cachingInStream);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Created CachingPushBufferStream with hashCode " + cachingInStream.hashCode() + " for inStream with hashCode " + inStream.hashCode());
            }
            this.setTransferHandler((InStreamDesc[])newValue, this.transferHandler);
            this.equalizeInStreamBufferLength();
            if (logger.isTraceEnabled()) {
                int oldValueLength;
                int newValueLength = newValue == null ? 0 : newValue.length;
                int difference = newValueLength - (oldValueLength = oldValue == null ? 0 : oldValue.length);
                if (difference > 0) {
                    logger.trace("Added " + difference + " inStream(s) and the total is " + newValueLength);
                } else if (difference < 0) {
                    logger.trace("Removed " + difference + " inStream(s) and the total is " + newValueLength);
                }
            }
        }
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        throw new UnsupportedOperationException(AudioMixerPushBufferStream.class.getSimpleName() + ".setTransferHandler(BufferTransferHandler)");
    }

    private void setTransferHandler(InStreamDesc[] inStreams, BufferTransferHandler transferHandler) {
        if (inStreams == null || inStreams.length <= 0) {
            return;
        }
        boolean transferHandlerIsSet = false;
        for (InStreamDesc inStreamDesc : inStreams) {
            SourceStream inStream = inStreamDesc.getInStream();
            if (!(inStream instanceof PushBufferStream)) continue;
            PushBufferStream inPushBufferStream = (PushBufferStream)inStream;
            Object inStreamTransferHandler = transferHandler == null ? null : (transferHandlerIsSet ? new BufferTransferHandler(){

                public void transferData(PushBufferStream stream) {
                }
            } : new StreamSubstituteBufferTransferHandler(transferHandler, inPushBufferStream, this));
            inPushBufferStream.setTransferHandler(inStreamTransferHandler);
            transferHandlerIsSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferData(Buffer buffer) {
        try {
            this.read(buffer);
        }
        catch (IOException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        InSampleDesc inSampleDesc = (InSampleDesc)buffer.getData();
        short[][] inSamples = inSampleDesc.inSamples;
        int maxInSampleCount = buffer.getLength();
        if (inSamples == null || inSamples.length == 0 || maxInSampleCount <= 0) {
            return;
        }
        AudioMixingPushBufferStream[] audioMixingPushBufferStreamArray = this.outStreams;
        synchronized (this.outStreams) {
            AudioMixingPushBufferStream[] outStreams = this.unmodifiableOutStreams;
            if (outStreams == null) {
                this.unmodifiableOutStreams = outStreams = this.outStreams.toArray(new AudioMixingPushBufferStream[this.outStreams.size()]);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            for (AudioMixingPushBufferStream outStream : outStreams) {
                this.setInSamples(outStream, inSampleDesc, maxInSampleCount);
            }
            for (int i = 0; i < inSamples.length; ++i) {
                this.shortArrayCache.deallocateShortArray(inSamples[i]);
                inSamples[i] = null;
            }
            return;
        }
    }
}

