/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import org.jitsi.impl.neomedia.protocol.BufferStreamAdapter;

public class PushBufferStreamAdapter
extends BufferStreamAdapter<PushSourceStream>
implements PushBufferStream {
    public PushBufferStreamAdapter(PushSourceStream stream, Format format) {
        super(stream, format);
    }

    public void read(Buffer buffer) throws IOException {
        byte[] data = (byte[])buffer.getData();
        int minimumTransferSize = ((PushSourceStream)this.stream).getMinimumTransferSize();
        if (data == null || data.length < minimumTransferSize) {
            data = new byte[minimumTransferSize];
            buffer.setData((Object)data);
        }
        buffer.setOffset(0);
        this.read(buffer, data, 0, minimumTransferSize);
    }

    @Override
    protected int doRead(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        return ((PushSourceStream)this.stream).read(data, offset, length);
    }

    public void setTransferHandler(final BufferTransferHandler transferHandler) {
        ((PushSourceStream)this.stream).setTransferHandler(new SourceTransferHandler(){

            public void transferData(PushSourceStream stream) {
                transferHandler.transferData((PushBufferStream)PushBufferStreamAdapter.this);
            }
        });
    }
}

