/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPIterator;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.transform.CachingTransformer;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RetransmissionRequester;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.Logger;

public class RtxTransformer
implements TransformEngine {
    public static final String DISABLE_NACK_TERMINATION_PNAME = "org.jitsi.impl.neomedia.rtcp.DISABLE_NACK_TERMINATION";
    private MediaStreamImpl mediaStream;
    private final Map<Long, Integer> rtxSequenceNumbers = new HashMap<Long, Integer>();
    private final Logger logger = Logger.getLogger(RtxTransformer.class);
    private byte rtxPayloadType = (byte)-1;
    private byte rtxAssociatedPayloadType = (byte)-1;
    private final RTPTransformer rtpTransformer = new RTPTransformer();
    private final RTCPTransformer rtcpTransformer = new RTCPTransformer();
    private final Statistics statistics = new Statistics();

    public RtxTransformer(MediaStreamImpl mediaStream) {
        boolean enableNackTermination;
        this.mediaStream = mediaStream;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg == null) {
            this.logger.warn("NOT initializing RTCP n' NACK termination because the configuration service was not found.");
            return;
        }
        boolean bl = enableNackTermination = !cfg.getBoolean(DISABLE_NACK_TERMINATION_PNAME, false);
        if (enableNackTermination) {
            CachingTransformer cache = mediaStream.getCachingTransformer();
            if (cache != null) {
                cache.setEnabled(true);
            } else {
                this.logger.warn("NACK termination is enabled, but we don't have a packet cache.");
            }
        }
    }

    private boolean isRtx(RawPacket pkt) {
        byte rtxPt = this.rtxPayloadType;
        return rtxPt != -1 && rtxPt == pkt.getPayloadType();
    }

    private RawPacket deRtx(RawPacket pkt) {
        boolean success = false;
        if (pkt.getPayloadLength() - pkt.getPaddingSize() < 2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping an incoming RTX packet with padding only: " + pkt);
            }
            return null;
        }
        long mediaSsrc = this.getPrimarySsrc(pkt);
        if (mediaSsrc != -1L) {
            if (this.rtxAssociatedPayloadType != -1) {
                int osn = pkt.getOriginalSequenceNumber();
                byte[] buf = pkt.getBuffer();
                int off = pkt.getOffset();
                System.arraycopy(buf, off, buf, off + 2, pkt.getHeaderLength());
                pkt.setOffset(off + 2);
                pkt.setLength(pkt.getLength() - 2);
                pkt.setSSRC((int)mediaSsrc);
                pkt.setSequenceNumber(osn);
                pkt.setPayloadType(this.rtxAssociatedPayloadType);
                success = true;
            } else {
                this.logger.warn("RTX packet received, but no APT is defined. Packet SSRC " + pkt.getSSRCAsLong() + ", associated media SSRC " + mediaSsrc);
            }
        }
        return success ? pkt : null;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextRtxSequenceNumber(long ssrc) {
        Integer seq;
        Map<Long, Integer> map = this.rtxSequenceNumbers;
        synchronized (map) {
            seq = this.rtxSequenceNumbers.get(ssrc);
            if (seq == null) {
                seq = new Random().nextInt(65535);
            } else {
                Integer n = seq;
                Integer n2 = seq = Integer.valueOf(seq + 1);
            }
            this.rtxSequenceNumbers.put(ssrc, seq);
        }
        return seq;
    }

    private long getRtxSsrc(RawPacket pkt) {
        MediaStream receiveStream;
        StreamRTPManager receiveRTPManager = this.mediaStream.getRTPTranslator().findStreamRTPManagerByReceiveSSRC(pkt.getSSRC());
        MediaStreamTrackReceiver receiver = null;
        if (receiveRTPManager != null && (receiveStream = receiveRTPManager.getMediaStream()) != null) {
            receiver = receiveStream.getMediaStreamTrackReceiver();
        }
        if (receiver == null) {
            return -1L;
        }
        RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(pkt);
        if (encoding == null) {
            this.logger.warn("encoding_not_found,stream_hash=" + this.mediaStream.hashCode() + " ssrc=" + pkt.getSSRCAsLong());
            return -1L;
        }
        return encoding.getRTXSSRC();
    }

    private boolean retransmit(RawPacket pkt, TransformEngine after) {
        boolean retransmitPlain;
        boolean destinationSupportsRtx;
        boolean bl = destinationSupportsRtx = this.rtxPayloadType != -1;
        if (destinationSupportsRtx) {
            long rtxSsrc = this.getRtxSsrc(pkt);
            if (rtxSsrc == -1L) {
                this.logger.warn("Cannot find SSRC for RTX, retransmitting plain. SSRC=" + pkt.getSSRCAsLong());
                retransmitPlain = true;
            } else {
                retransmitPlain = !this.encapsulateInRtxAndTransmit(pkt, rtxSsrc, after);
            }
        } else {
            retransmitPlain = true;
        }
        if (retransmitPlain && this.mediaStream != null) {
            try {
                this.mediaStream.injectPacket(pkt, true, after);
            }
            catch (TransmissionFailedException tfe) {
                this.logger.warn("Failed to retransmit a packet.");
                return false;
            }
        }
        return true;
    }

    public void onDynamicPayloadTypesChanged() {
        this.rtxPayloadType = (byte)-1;
        this.rtxAssociatedPayloadType = (byte)-1;
        Map<Byte, MediaFormat> mediaFormatMap = this.mediaStream.getDynamicRTPPayloadTypes();
        Iterator<Map.Entry<Byte, MediaFormat>> it = mediaFormatMap.entrySet().iterator();
        while (it.hasNext() && this.rtxPayloadType == -1) {
            Map.Entry<Byte, MediaFormat> entry = it.next();
            MediaFormat format = entry.getValue();
            if (!"rtx".equalsIgnoreCase(format.getEncoding())) continue;
            this.rtxPayloadType = entry.getKey();
            this.rtxAssociatedPayloadType = Byte.parseByte(format.getFormatParameters().get("apt"));
        }
    }

    private boolean encapsulateInRtxAndTransmit(RawPacket pkt, long rtxSsrc, TransformEngine after) {
        byte[] buf = pkt.getBuffer();
        int len = pkt.getLength();
        int off = pkt.getOffset();
        byte[] newBuf = new byte[len + 2];
        RawPacket rtxPkt = new RawPacket(newBuf, 0, len + 2);
        int osn = pkt.getSequenceNumber();
        int headerLength = pkt.getHeaderLength();
        int payloadLength = pkt.getPayloadLength();
        System.arraycopy(buf, off, newBuf, 0, headerLength);
        newBuf[headerLength] = (byte)(osn >> 8 & 0xFF);
        newBuf[headerLength + 1] = (byte)(osn & 0xFF);
        System.arraycopy(buf, off + headerLength, newBuf, headerLength + 2, payloadLength);
        if (this.mediaStream != null) {
            rtxPkt.setSSRC((int)rtxSsrc);
            rtxPkt.setPayloadType(this.rtxPayloadType);
            rtxPkt.setSequenceNumber(this.getNextRtxSequenceNumber(rtxSsrc));
            try {
                this.mediaStream.injectPacket(rtxPkt, true, after);
            }
            catch (TransmissionFailedException tfe) {
                this.logger.warn("Failed to transmit an RTX packet.");
                return false;
            }
        }
        return true;
    }

    private long getPrimarySsrc(RawPacket pkt) {
        MediaStreamTrackReceiver receiver = this.mediaStream.getMediaStreamTrackReceiver();
        if (receiver == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping an incoming RTX packet from an unknown source.");
            }
            return -1L;
        }
        RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(pkt);
        if (encoding == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping an incoming RTX packet from an unknown source.");
            }
            return -1L;
        }
        return encoding.getPrimarySSRC();
    }

    private void nackReceived(long mediaSSRC, Collection<Integer> lostPackets) {
        RawPacketCache cache;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Logger.Category.STATISTICS, "nack_received,stream=" + this.mediaStream.hashCode() + " ssrc=" + mediaSSRC + ",lost_packets=" + lostPackets);
        }
        if (this.mediaStream != null && (cache = this.mediaStream.getCachingTransformer().getOutgoingRawPacketCache()) != null) {
            RetransmissionRequester rr = this.mediaStream.getRetransmissionRequester();
            TransformEngine after = rr instanceof TransformEngine ? (TransformEngine)((Object)rr) : null;
            long rtt = this.mediaStream.getMediaStreamStats().getSendStats().getRtt();
            long now = System.currentTimeMillis();
            Iterator<Integer> i = lostPackets.iterator();
            while (i.hasNext()) {
                int seq = i.next();
                RawPacketCache.Container container = cache.getContainer(mediaSSRC, seq);
                if (container != null) {
                    boolean send;
                    long delay = now - container.timeAdded;
                    boolean bl = send = rtt == -1L || (double)delay >= Math.min((double)rtt * 0.9, (double)(rtt - 5L));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(Logger.Category.STATISTICS, "retransmitting,stream=" + this.mediaStream.hashCode() + " ssrc=" + mediaSSRC + ",seq=" + seq + ",send=" + send);
                    }
                    if (send && this.retransmit(container.pkt, after)) {
                        this.statistics.packetsRetransmitted.incrementAndGet();
                        this.statistics.bytesRetransmitted.addAndGet(container.pkt.getLength());
                        i.remove();
                    }
                    if (send) continue;
                    this.statistics.packetsNotRetransmitted.incrementAndGet();
                    this.statistics.bytesNotRetransmitted.addAndGet(container.pkt.getLength());
                    i.remove();
                    continue;
                }
                this.statistics.packetsMissingFromCache.incrementAndGet();
            }
        }
        if (!lostPackets.isEmpty()) {
            this.logger.debug("Packets missing from the cache.");
        }
    }

    public class Statistics {
        private final AtomicLong bytesRetransmitted = new AtomicLong();
        private final AtomicLong bytesNotRetransmitted = new AtomicLong();
        private final AtomicLong packetsRetransmitted = new AtomicLong();
        private AtomicLong packetsNotRetransmitted = new AtomicLong();
        private AtomicLong packetsMissingFromCache = new AtomicLong();

        public long getBytesRetransmitted() {
            return this.bytesRetransmitted.get();
        }

        public long getBytesNotRetransmitted() {
            return this.bytesNotRetransmitted.get();
        }

        public long getPacketsRetransmitted() {
            return this.packetsRetransmitted.get();
        }

        public long getPacketsNotRetransmitted() {
            return this.packetsNotRetransmitted.get();
        }

        public long getPacketsMissingFromCache() {
            return this.packetsMissingFromCache.get();
        }
    }

    private class RTCPTransformer
    extends SinglePacketTransformerAdapter {
        RTCPTransformer() {
            super(RTCPPacketPredicate.INSTANCE);
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            RTCPIterator it = new RTCPIterator(pkt);
            while (it.hasNext()) {
                ByteArrayBuffer next = it.next();
                if (!NACKPacket.isNACKPacket(next)) continue;
                Collection<Integer> lostPackets = NACKPacket.getLostPackets(next);
                long mediaSSRC = NACKPacket.getSourceSSRC(next);
                RtxTransformer.this.nackReceived(mediaSSRC, lostPackets);
            }
            return pkt;
        }
    }

    private class RTPTransformer
    extends SinglePacketTransformerAdapter {
        RTPTransformer() {
            super(RTPPacketPredicate.INSTANCE);
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            if (RtxTransformer.this.isRtx(pkt)) {
                pkt = RtxTransformer.this.deRtx(pkt);
            }
            return pkt;
        }
    }
}

