/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.contactlist;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import net.java.sip.communicator.impl.contactlist.MetaContactImpl;
import net.java.sip.communicator.impl.contactlist.MetaContactListServiceImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class MetaContactGroupImpl
implements MetaContactGroup {
    private static final Logger logger = Logger.getLogger(MetaContactGroupImpl.class);
    private Set<MetaContactGroupImpl> subgroups = new TreeSet<MetaContactGroupImpl>();
    private final Set<MetaContactImpl> childContacts = new TreeSet<MetaContactImpl>();
    private Vector<ContactGroup> protoGroups = new Vector();
    private String groupUID = null;
    private String groupName = null;
    private List<MetaContact> childContactsOrderedCopy = new LinkedList<MetaContact>();
    private List<MetaContactGroup> subgroupsOrderedCopy = new LinkedList<MetaContactGroup>();
    private MetaContactGroupImpl parentMetaContactGroup = null;
    private final MetaContactListServiceImpl mclServiceImpl;
    private Object[] data;

    MetaContactGroupImpl(MetaContactListServiceImpl mclServiceImpl, String groupName) {
        this(mclServiceImpl, groupName, null);
    }

    MetaContactGroupImpl(MetaContactListServiceImpl mclServiceImpl, String groupName, String metaUID) {
        this.mclServiceImpl = mclServiceImpl;
        this.groupName = groupName;
        this.groupUID = metaUID == null ? String.valueOf(System.currentTimeMillis()) + String.valueOf(this.hashCode()) : metaUID;
    }

    public String getMetaUID() {
        return this.groupUID;
    }

    public MetaContactGroup getParentMetaContactGroup() {
        return this.parentMetaContactGroup;
    }

    public boolean canContainSubgroups() {
        return false;
    }

    public int countChildContacts() {
        return this.childContacts.size();
    }

    public int countOnlineChildContacts() {
        int onlineContactsNumber;
        block3: {
            onlineContactsNumber = 0;
            try {
                Iterator<MetaContact> itr = this.getChildContacts();
                while (itr.hasNext()) {
                    Contact contact = itr.next().getDefaultContact();
                    if (contact == null || !contact.getPresenceStatus().isOnline()) continue;
                    ++onlineContactsNumber;
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)"Failed to count online contacts.", (Throwable)e);
            }
        }
        return onlineContactsNumber;
    }

    public int countContactGroups() {
        return this.protoGroups.size();
    }

    public int countSubgroups() {
        return this.subgroups.size();
    }

    public Iterator<MetaContact> getChildContacts() {
        return this.childContactsOrderedCopy.iterator();
    }

    public MetaContact getMetaContact(String metaContactID) {
        Iterator<MetaContact> contactsIter = this.getChildContacts();
        while (contactsIter.hasNext()) {
            MetaContact contact = contactsIter.next();
            if (!contact.getMetaUID().equals(metaContactID)) continue;
            return contact;
        }
        return null;
    }

    public int indexOf(MetaContact metaContact) {
        int i = 0;
        Iterator<MetaContact> childrenIter = this.getChildContacts();
        while (childrenIter.hasNext()) {
            MetaContact current = childrenIter.next();
            if (current == metaContact) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(MetaContactGroup metaContactGroup) {
        int i = 0;
        Iterator<MetaContactGroup> childrenIter = this.getSubgroups();
        while (childrenIter.hasNext()) {
            MetaContactGroup current = childrenIter.next();
            if (current == metaContactGroup) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public MetaContact getMetaContact(ProtocolProviderService provider, String contactID) {
        Iterator<MetaContact> contactsIter = this.getChildContacts();
        while (contactsIter.hasNext()) {
            MetaContact contact = contactsIter.next();
            if (contact.getContact(contactID, provider) == null) continue;
            return contact;
        }
        return null;
    }

    public MetaContact findMetaContactByMetaUID(String metaUID) {
        Iterator<MetaContact> contactsIter = this.getChildContacts();
        while (contactsIter.hasNext()) {
            MetaContact mContact = contactsIter.next();
            if (!mContact.getMetaUID().equals(metaUID)) continue;
            return mContact;
        }
        Iterator<MetaContactGroup> groupsIter = this.getSubgroups();
        while (groupsIter.hasNext()) {
            MetaContactGroupImpl mGroup = (MetaContactGroupImpl)groupsIter.next();
            MetaContact mContact = mGroup.findMetaContactByMetaUID(metaUID);
            if (mContact == null) continue;
            return mContact;
        }
        return null;
    }

    public MetaContactGroup findMetaContactGroupByMetaUID(String metaUID) {
        if (metaUID.equals(this.groupUID)) {
            return this;
        }
        Iterator<MetaContactGroup> groupsIter = this.getSubgroups();
        while (groupsIter.hasNext()) {
            MetaContactGroupImpl mGroup = (MetaContactGroupImpl)groupsIter.next();
            if (metaUID.equals(mGroup.getMetaUID())) {
                return mGroup;
            }
            mGroup.findMetaContactByMetaUID(metaUID);
        }
        return null;
    }

    public Iterator<ContactGroup> getContactGroups() {
        return new LinkedList<ContactGroup>(this.protoGroups).iterator();
    }

    public ContactGroup getContactGroup(String grpName, ProtocolProviderService ownerProvider) {
        Iterator<ContactGroup> encapsulatedGroups = this.getContactGroups();
        while (encapsulatedGroups.hasNext()) {
            ContactGroup group = encapsulatedGroups.next();
            if (!group.getGroupName().equals(grpName) || group.getProtocolProvider() != ownerProvider) continue;
            return group;
        }
        return null;
    }

    public Iterator<ContactGroup> getContactGroupsForProvider(ProtocolProviderService provider) {
        Iterator<ContactGroup> encapsulatedGroups = this.getContactGroups();
        LinkedList<ContactGroup> protGroups = new LinkedList<ContactGroup>();
        while (encapsulatedGroups.hasNext()) {
            ContactGroup group = encapsulatedGroups.next();
            if (group.getProtocolProvider() != provider) continue;
            protGroups.add(group);
        }
        return protGroups.iterator();
    }

    public Iterator<ContactGroup> getContactGroupsForAccountID(String accountID) {
        Iterator<ContactGroup> encapsulatedGroups = this.getContactGroups();
        LinkedList<ContactGroup> protGroups = new LinkedList<ContactGroup>();
        while (encapsulatedGroups.hasNext()) {
            ContactGroup group = encapsulatedGroups.next();
            if (!group.getProtocolProvider().getAccountID().getAccountUniqueID().equals(accountID)) continue;
            protGroups.add(group);
        }
        return protGroups.iterator();
    }

    public MetaContact findMetaContactByContact(Contact protoContact) {
        Iterator<MetaContact> contactsIter = this.getChildContacts();
        while (contactsIter.hasNext()) {
            MetaContact mContact = contactsIter.next();
            Contact storedProtoContact = mContact.getContact(protoContact.getAddress(), protoContact.getProtocolProvider());
            if (storedProtoContact == null) continue;
            return mContact;
        }
        Iterator<MetaContactGroup> groupsIter = this.getSubgroups();
        while (groupsIter.hasNext()) {
            MetaContactGroupImpl mGroup = (MetaContactGroupImpl)groupsIter.next();
            MetaContact mContact = mGroup.findMetaContactByContact(protoContact);
            if (mContact == null) continue;
            return mContact;
        }
        return null;
    }

    public MetaContact findMetaContactByContact(String contactAddress, String accountID) {
        Iterator<MetaContact> contactsIter = this.getChildContacts();
        while (contactsIter.hasNext()) {
            MetaContactImpl mContact = (MetaContactImpl)contactsIter.next();
            Contact storedProtoContact = mContact.getContact(contactAddress, accountID);
            if (storedProtoContact == null) continue;
            return mContact;
        }
        Iterator<MetaContactGroup> groupsIter = this.getSubgroups();
        while (groupsIter.hasNext()) {
            MetaContactGroupImpl mGroup = (MetaContactGroupImpl)groupsIter.next();
            MetaContact mContact = mGroup.findMetaContactByContact(contactAddress, accountID);
            if (mContact == null) continue;
            return mContact;
        }
        return null;
    }

    public MetaContactGroupImpl findMetaContactGroupByContactGroup(ContactGroup protoContactGroup) {
        if (this.protoGroups.contains(protoContactGroup)) {
            return this;
        }
        Iterator<MetaContactGroup> groupsIter = this.getSubgroups();
        while (groupsIter.hasNext()) {
            MetaContactGroupImpl mGroup = (MetaContactGroupImpl)groupsIter.next();
            MetaContactGroupImpl foundMetaContactGroup = mGroup.findMetaContactGroupByContactGroup(protoContactGroup);
            if (foundMetaContactGroup == null) continue;
            return foundMetaContactGroup;
        }
        return null;
    }

    public MetaContact getMetaContact(int index) throws IndexOutOfBoundsException {
        return this.childContactsOrderedCopy.get(index);
    }

    void addMetaContact(MetaContactImpl metaContact) {
        metaContact.setParentGroup(this);
        this.lightAddMetaContact(metaContact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int lightAddMetaContact(MetaContactImpl metaContact) {
        Set<MetaContactImpl> set = this.childContacts;
        synchronized (set) {
            this.childContacts.add(metaContact);
            this.childContactsOrderedCopy = new LinkedList<MetaContactImpl>(this.childContacts);
            return this.childContactsOrderedCopy.indexOf((Object)metaContact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lightRemoveMetaContact(MetaContactImpl metaContact) {
        Set<MetaContactImpl> set = this.childContacts;
        synchronized (set) {
            this.childContacts.remove((Object)metaContact);
            this.childContactsOrderedCopy = new LinkedList<MetaContactImpl>(this.childContacts);
        }
    }

    void removeMetaContact(MetaContactImpl metaContact) {
        metaContact.unsetParentGroup(this);
        this.lightRemoveMetaContact(metaContact);
    }

    public MetaContactGroup getMetaContactSubgroup(int index) throws IndexOutOfBoundsException {
        return this.subgroupsOrderedCopy.get(index);
    }

    public MetaContactGroup getMetaContactSubgroup(String grpName) {
        Iterator<MetaContactGroup> groupsIter = this.getSubgroups();
        while (groupsIter.hasNext()) {
            MetaContactGroup mcGroup = groupsIter.next();
            if (!mcGroup.getGroupName().equals(grpName)) continue;
            return mcGroup;
        }
        return null;
    }

    public MetaContactGroup getMetaContactSubgroupByUID(String grpUID) {
        Iterator<MetaContactGroup> groupsIter = this.getSubgroups();
        while (groupsIter.hasNext()) {
            MetaContactGroup mcGroup = groupsIter.next();
            if (!mcGroup.getMetaUID().equals(grpUID)) continue;
            return mcGroup;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(MetaContact contact) {
        Set<MetaContactImpl> set = this.childContacts;
        synchronized (set) {
            return this.childContacts.contains(contact);
        }
    }

    public boolean contains(MetaContactGroup group) {
        return this.subgroups.contains(group);
    }

    public Iterator<MetaContactGroup> getSubgroups() {
        return this.subgroupsOrderedCopy.iterator();
    }

    public String getGroupName() {
        return this.groupName;
    }

    void setGroupName(String newGroupName) {
        this.groupName = newGroupName;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.getGroupName());
        buff.append(".subGroups=" + this.countSubgroups() + ":\n");
        Iterator<MetaContactGroup> subGroups = this.getSubgroups();
        while (subGroups.hasNext()) {
            MetaContactGroup group = subGroups.next();
            buff.append(group.getGroupName());
            if (!subGroups.hasNext()) continue;
            buff.append("\n");
        }
        buff.append("\nProtoGroups=" + this.countContactGroups() + ":[");
        Iterator<ContactGroup> contactGroups = this.getContactGroups();
        while (contactGroups.hasNext()) {
            ContactGroup contactGroup = contactGroups.next();
            buff.append(contactGroup.getProtocolProvider());
            buff.append(".");
            buff.append(contactGroup.getGroupName());
            if (!contactGroups.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("]");
        buff.append("\nRootChildContacts=" + this.countChildContacts() + ":[");
        Iterator<MetaContact> contacts = this.getChildContacts();
        while (contacts.hasNext()) {
            MetaContact contact = contacts.next();
            buff.append(contact.toString());
            if (!contacts.hasNext()) continue;
            buff.append(", ");
        }
        return buff.append("]").toString();
    }

    void addProtoGroup(ContactGroup protoGroup) {
        this.protoGroups.add(protoGroup);
    }

    void removeProtoGroup(ContactGroup protoGroup) {
        this.protoGroups.remove(protoGroup);
    }

    void addSubgroup(MetaContactGroup subgroup) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding subgroup " + subgroup.getGroupName() + " to" + this.getGroupName()));
        }
        this.subgroups.add((MetaContactGroupImpl)subgroup);
        ((MetaContactGroupImpl)subgroup).parentMetaContactGroup = this;
        this.subgroupsOrderedCopy = new LinkedList<MetaContactGroupImpl>(this.subgroups);
    }

    MetaContactGroupImpl removeSubgroup(int index) {
        MetaContactGroupImpl subgroup = (MetaContactGroupImpl)this.subgroupsOrderedCopy.get(index);
        if (this.subgroups.remove(subgroup)) {
            subgroup.parentMetaContactGroup = null;
        }
        this.subgroupsOrderedCopy = new LinkedList<MetaContactGroupImpl>(this.subgroups);
        return subgroup;
    }

    boolean removeSubgroup(MetaContactGroup group) {
        if (this.subgroups.contains(group)) {
            this.removeSubgroup(this.subgroupsOrderedCopy.indexOf(group));
            return true;
        }
        return false;
    }

    final MetaContactListServiceImpl getMclServiceImpl() {
        return this.mclServiceImpl;
    }

    public Object getData(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        int index = this.dataIndexOf(key);
        return index == -1 ? null : this.data[index + 1];
    }

    public void setData(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        int index = this.dataIndexOf(key);
        if (index == -1) {
            if (this.data == null) {
                if (value != null) {
                    this.data = new Object[]{key, value};
                }
            } else if (value == null) {
                int length = this.data.length - 2;
                if (length > 0) {
                    Object[] newData = new Object[length];
                    System.arraycopy(this.data, 0, newData, 0, index);
                    System.arraycopy(this.data, index + 2, newData, index, length - index);
                    this.data = newData;
                } else {
                    this.data = null;
                }
            } else {
                int length = this.data.length;
                Object[] newData = new Object[length + 2];
                System.arraycopy(this.data, 0, newData, 0, length);
                this.data = newData;
                this.data[length++] = key;
                this.data[length++] = value;
            }
        } else {
            this.data[index + 1] = value;
        }
    }

    public boolean isPersistent() {
        Iterator<ContactGroup> contactGroupsIter = this.getContactGroups();
        while (contactGroupsIter.hasNext()) {
            ContactGroup contactGroup = contactGroupsIter.next();
            if (!contactGroup.isPersistent()) continue;
            return true;
        }
        return this.countContactGroups() == 0;
    }

    private int dataIndexOf(Object key) {
        if (this.data != null) {
            for (int index = 0; index < this.data.length; index += 2) {
                if (!key.equals(this.data[index])) continue;
                return index;
            }
        }
        return -1;
    }

    public int compareTo(MetaContactGroup target) {
        return this.getGroupName().compareToIgnoreCase(target.getGroupName()) * 10000 + this.getMetaUID().compareTo(target.getMetaUID());
    }
}

