/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.impl.gui.main.account.AccountList;
import net.java.sip.communicator.impl.gui.main.account.AccountRegWizardContainerImpl;
import net.java.sip.communicator.impl.gui.main.account.NewAccountDialog;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.account.AccountUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class AccountsConfigurationPanel
extends TransparentPanel
implements ActionListener,
ListSelectionListener,
PropertyChangeListener {
    private final AccountList accountList;
    private final JButton newButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.ADD"));
    private final JButton editButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.EDIT"));
    private final JButton removeButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.DELETE"));

    public AccountsConfigurationPanel() {
        super((LayoutManager)new BorderLayout());
        this.accountList = new AccountList(this);
        this.accountList.setSelectionMode(0);
        this.setPreferredSize(new Dimension(500, 400));
        JScrollPane accountListPane = new JScrollPane();
        accountListPane.getViewport().add(this.accountList);
        accountListPane.getVerticalScrollBar().setUnitIncrement(30);
        this.add(accountListPane, "Center");
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        this.newButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.newButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.ADD"));
        this.editButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.EDIT"));
        this.removeButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.DELETE"));
        buttonsPanel.add(this.newButton);
        buttonsPanel.add(this.editButton);
        buttonsPanel.add(this.removeButton);
        this.add((Component)buttonsPanel, "South");
        this.accountList.addListSelectionListener(this);
        this.accountList.addPropertyChangeListener("ACCOUNT_STATE_CHANGED", this);
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object sourceButton = evt.getSource();
        if (sourceButton.equals(this.newButton)) {
            NewAccountDialog.showNewAccountDialog();
        } else if (sourceButton.equals(this.removeButton)) {
            int result;
            Account account = this.accountList.getSelectedAccount();
            if (account == null) {
                return;
            }
            AccountID accountID = account.getAccountID();
            ProtocolProviderFactory providerFactory = AccountUtils.getProtocolProviderFactory((String)accountID.getProtocolName());
            if (providerFactory != null && (result = JOptionPane.showConfirmDialog((Component)((Object)this), GuiActivator.getResources().getI18NString("service.gui.REMOVE_ACCOUNT_MESSAGE"), GuiActivator.getResources().getI18NString("service.gui.REMOVE_ACCOUNT"), 0)) == 0) {
                boolean isUninstalled;
                ConfigurationService configService = GuiActivator.getConfigurationService();
                String prefix = "net.java.sip.communicator.impl.gui.accounts";
                List accounts = configService.getPropertyNamesByPrefix(prefix, true);
                for (String accountRootPropName : accounts) {
                    String accountUID = configService.getString(accountRootPropName);
                    if (!accountUID.equals(accountID.getAccountUniqueID())) continue;
                    configService.setProperty(accountRootPropName, null);
                    break;
                }
                if (isUninstalled = providerFactory.uninstallAccount(accountID)) {
                    this.accountList.ensureAccountRemoved(accountID);
                    AccountRegWizardContainerImpl wizardContainer = (AccountRegWizardContainerImpl)GuiActivator.getUIService().getAccountRegWizardContainer();
                    ProtocolProviderService protocolProvider = account.getProtocolProvider();
                    AccountRegistrationWizard wizard = wizardContainer.getProtocolWizard(protocolProvider);
                    if (wizard != null) {
                        wizard.accountRemoved(protocolProvider);
                    }
                }
            }
        } else if (sourceButton.equals(this.editButton)) {
            Account account = this.accountList.getSelectedAccount();
            if (account == null) {
                return;
            }
            AccountRegWizardContainerImpl wizard = (AccountRegWizardContainerImpl)GuiActivator.getUIService().getAccountRegWizardContainer();
            AccountRegistrationWizard protocolWizard = wizard.getProtocolWizard(account.getProtocolProvider());
            ResourceManagementService resources = GuiActivator.getResources();
            if (protocolWizard != null) {
                wizard.setTitle(resources.getI18NString("service.gui.ACCOUNT_REGISTRATION_WIZARD"));
                wizard.modifyAccount(account.getProtocolProvider());
                wizard.showDialog(false);
            } else {
                String title = resources.getI18NString("service.gui.ERROR");
                String message = resources.getI18NString("service.gui.EDIT_NOT_SUPPORTED");
                ErrorDialog dialog = new ErrorDialog(null, title, message);
                dialog.setVisible(true);
            }
        }
    }

    public JButton getEditButton() {
        return this.editButton;
    }

    private void updateButtons() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountsConfigurationPanel.this.updateButtons();
                }
            });
            return;
        }
        Account account = this.accountList.getSelectedAccount();
        boolean enabled = account != null;
        this.editButton.setEnabled(enabled && account.isEnabled());
        this.removeButton.setEnabled(enabled);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.updateButtons();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateButtons();
    }
}

