/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.impl.gui.utils.SoundProperties;
import net.java.sip.communicator.service.gui.call.CallPeerRenderer;
import net.java.sip.communicator.service.notification.NotificationAction;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.notification.SoundNotificationAction;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetDTMF;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.DTMFTone;

public class DTMFHandler
implements KeyEventDispatcher {
    public static final DTMFToneInfo[] AVAILABLE_TONES = new DTMFToneInfo[]{new DTMFToneInfo(DTMFTone.DTMF_1, 49, '1', ImageLoader.ONE_DIAL_BUTTON, ImageLoader.ONE_DIAL_BUTTON_PRESSED, ImageLoader.ONE_DIAL_BUTTON_ROLLOVER, ImageLoader.ONE_DIAL_BUTTON_MAC, ImageLoader.ONE_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_ONE), new DTMFToneInfo(DTMFTone.DTMF_2, 50, '2', ImageLoader.TWO_DIAL_BUTTON, ImageLoader.TWO_DIAL_BUTTON_PRESSED, ImageLoader.TWO_DIAL_BUTTON_ROLLOVER, ImageLoader.TWO_DIAL_BUTTON_MAC, ImageLoader.TWO_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_TWO), new DTMFToneInfo(DTMFTone.DTMF_3, 51, '3', ImageLoader.THREE_DIAL_BUTTON, ImageLoader.THREE_DIAL_BUTTON_PRESSED, ImageLoader.THREE_DIAL_BUTTON_ROLLOVER, ImageLoader.THREE_DIAL_BUTTON_MAC, ImageLoader.THREE_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_THREE), new DTMFToneInfo(DTMFTone.DTMF_4, 52, '4', ImageLoader.FOUR_DIAL_BUTTON, ImageLoader.FOUR_DIAL_BUTTON_PRESSED, ImageLoader.FOUR_DIAL_BUTTON_ROLLOVER, ImageLoader.FOUR_DIAL_BUTTON_MAC, ImageLoader.FOUR_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_FOUR), new DTMFToneInfo(DTMFTone.DTMF_5, 53, '5', ImageLoader.FIVE_DIAL_BUTTON, ImageLoader.FIVE_DIAL_BUTTON_PRESSED, ImageLoader.FIVE_DIAL_BUTTON_ROLLOVER, ImageLoader.FIVE_DIAL_BUTTON_MAC, ImageLoader.FIVE_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_FIVE), new DTMFToneInfo(DTMFTone.DTMF_6, 54, '6', ImageLoader.SIX_DIAL_BUTTON, ImageLoader.SIX_DIAL_BUTTON_PRESSED, ImageLoader.SIX_DIAL_BUTTON_ROLLOVER, ImageLoader.SIX_DIAL_BUTTON_MAC, ImageLoader.SIX_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_SIX), new DTMFToneInfo(DTMFTone.DTMF_7, 55, '7', ImageLoader.SEVEN_DIAL_BUTTON, ImageLoader.SEVEN_DIAL_BUTTON_PRESSED, ImageLoader.SEVEN_DIAL_BUTTON_ROLLOVER, ImageLoader.SEVEN_DIAL_BUTTON_MAC, ImageLoader.SEVEN_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_SEVEN), new DTMFToneInfo(DTMFTone.DTMF_8, 56, '8', ImageLoader.EIGHT_DIAL_BUTTON, ImageLoader.EIGHT_DIAL_BUTTON_PRESSED, ImageLoader.EIGHT_DIAL_BUTTON_ROLLOVER, ImageLoader.EIGHT_DIAL_BUTTON_MAC, ImageLoader.EIGHT_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_EIGHT), new DTMFToneInfo(DTMFTone.DTMF_9, 57, '9', ImageLoader.NINE_DIAL_BUTTON, ImageLoader.NINE_DIAL_BUTTON_PRESSED, ImageLoader.NINE_DIAL_BUTTON_ROLLOVER, ImageLoader.NINE_DIAL_BUTTON_MAC, ImageLoader.NINE_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_NINE), new DTMFToneInfo(DTMFTone.DTMF_A, 65, 'a', null, null, null, null, null, null), new DTMFToneInfo(DTMFTone.DTMF_B, 66, 'b', null, null, null, null, null, null), new DTMFToneInfo(DTMFTone.DTMF_C, 67, 'c', null, null, null, null, null, null), new DTMFToneInfo(DTMFTone.DTMF_D, 68, 'd', null, null, null, null, null, null), new DTMFToneInfo(DTMFTone.DTMF_STAR, 151, '*', ImageLoader.STAR_DIAL_BUTTON, ImageLoader.STAR_DIAL_BUTTON_PRESSED, ImageLoader.STAR_DIAL_BUTTON_ROLLOVER, ImageLoader.STAR_DIAL_BUTTON_MAC, ImageLoader.STAR_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_STAR), new DTMFToneInfo(DTMFTone.DTMF_0, 48, '0', ImageLoader.ZERO_DIAL_BUTTON, ImageLoader.ZERO_DIAL_BUTTON_PRESSED, ImageLoader.ZERO_DIAL_BUTTON_ROLLOVER, ImageLoader.ZERO_DIAL_BUTTON_MAC, ImageLoader.ZERO_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_ZERO), new DTMFToneInfo(DTMFTone.DTMF_SHARP, 520, '#', ImageLoader.DIEZ_DIAL_BUTTON, ImageLoader.DIEZ_DIAL_BUTTON_PRESSED, ImageLoader.DIEZ_DIAL_BUTTON_ROLLOVER, ImageLoader.DIEZ_DIAL_BUTTON_MAC, ImageLoader.DIEZ_DIAL_BUTTON_MAC_ROLLOVER, SoundProperties.DIAL_DIEZ)};
    private static boolean defaultsLoaded = false;
    private static final long DTMF_TONE_NOTIFICATION_THREAD_IDLE_TIMEOUT = 15000L;
    public static final String DTMF_TONE_PREFIX = "DTMFTone.";
    private static final Logger logger = Logger.getLogger(DTMFHandler.class);
    private final CallPanel callContainer;
    private final List<DTMFToneInfo> dtmfToneNotifications = new LinkedList<DTMFToneInfo>();
    private Thread dtmfToneNotificationThread;
    private KeyboardFocusManager keyboardFocusManager;
    private final List<Window> parents = new ArrayList<Window>();

    public static synchronized void loadDefaults() {
        if (defaultsLoaded) {
            return;
        }
        NotificationService notificationService = GuiActivator.getNotificationService();
        for (DTMFToneInfo info : AVAILABLE_TONES) {
            notificationService.registerDefaultNotificationForEvent(DTMF_TONE_PREFIX + info.tone.getValue(), (NotificationAction)new SoundNotificationAction(info.sound, 0, false, true, false));
        }
        defaultsLoaded = true;
    }

    public DTMFHandler() {
        this(null);
    }

    public DTMFHandler(CallPanel callContainer) {
        JFrame parent;
        this.callContainer = callContainer;
        if (this.callContainer != null && (parent = callContainer.getCallWindow().getFrame()) != null) {
            parent.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    DTMFHandler.this.removeParent(parent);
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    DTMFHandler.this.addParent(parent);
                }
            });
            if (parent.isVisible()) {
                this.addParent(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(Window parent) {
        List<Window> list = this.parents;
        synchronized (list) {
            if (!this.parents.contains(parent) && this.parents.add(parent) && this.keyboardFocusManager == null) {
                this.keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                this.keyboardFocusManager.addKeyEventDispatcher(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() == 400) {
            return false;
        }
        if (!(GuiActivator.getUIService().getSingleWindowContainer() == null || this.callContainer != null && this.callContainer.isFocusOwner())) {
            return false;
        }
        boolean dispatch = false;
        List<Window> list = this.parents;
        synchronized (list) {
            int count = this.parents.size();
            for (int i = 0; i < count; ++i) {
                if (!this.parents.get(i).isFocused()) continue;
                dispatch = true;
                break;
            }
        }
        if (dispatch) {
            for (int i = 0; i < AVAILABLE_TONES.length; ++i) {
                DTMFToneInfo info = AVAILABLE_TONES[i];
                if (info.keyChar != e.getKeyChar()) continue;
                switch (e.getID()) {
                    case 401: {
                        this.startSendingDtmfTone(info);
                        break;
                    }
                    case 402: {
                        this.stopSendingDtmfTone();
                    }
                }
                break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(Window parent) {
        List<Window> list = this.parents;
        synchronized (list) {
            if (this.parents.remove(parent) && this.parents.isEmpty() && this.keyboardFocusManager != null) {
                this.keyboardFocusManager.removeKeyEventDispatcher(this);
                this.keyboardFocusManager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInDTMFToneNotificationThread() {
        long idleStartTime = -1L;
        while (true) {
            DTMFToneInfo toneToPlay;
            List<DTMFToneInfo> list = this.dtmfToneNotifications;
            synchronized (list) {
                if (this.dtmfToneNotificationThread != Thread.currentThread()) {
                    break;
                }
                if (this.dtmfToneNotifications.isEmpty()) {
                    long timeout;
                    toneToPlay = null;
                    long now = System.currentTimeMillis();
                    if (idleStartTime == -1L) {
                        idleStartTime = now;
                    }
                    if ((timeout = 15000L - (now - idleStartTime)) <= 0L) {
                        break;
                    }
                    try {
                        this.dtmfToneNotifications.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                toneToPlay = this.dtmfToneNotifications.remove(0);
                idleStartTime = -1L;
            }
            if (toneToPlay == null || toneToPlay.sound == null) continue;
            GuiActivator.getNotificationService().fireNotification(DTMF_TONE_PREFIX + toneToPlay.tone.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDTMFToneNotificationThreadIfNecessary() {
        List<DTMFToneInfo> list = this.dtmfToneNotifications;
        synchronized (list) {
            if (this.dtmfToneNotificationThread == null && !this.dtmfToneNotifications.isEmpty()) {
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            DTMFHandler.this.runInDTMFToneNotificationThread();
                        }
                        finally {
                            List list = DTMFHandler.this.dtmfToneNotifications;
                            synchronized (list) {
                                if (DTMFHandler.this.dtmfToneNotificationThread == Thread.currentThread()) {
                                    DTMFHandler.this.dtmfToneNotificationThread = null;
                                    DTMFHandler.this.startDTMFToneNotificationThreadIfNecessary();
                                }
                            }
                        }
                    }
                };
                t.setDaemon(true);
                t.setName("DTMFHandler: DTMF tone notification player");
                boolean started = false;
                this.dtmfToneNotificationThread = t;
                try {
                    t.start();
                    started = true;
                }
                finally {
                    if (!started && this.dtmfToneNotificationThread == t) {
                        this.dtmfToneNotificationThread = null;
                    }
                }
            } else {
                this.dtmfToneNotifications.notify();
            }
        }
    }

    private void startSendingDtmfTone(Call call, DTMFToneInfo info) {
        Iterator callPeers = call.getCallPeers();
        try {
            while (callPeers.hasNext()) {
                CallPeer peer = (CallPeer)callPeers.next();
                OperationSetDTMF dtmfOpSet = (OperationSetDTMF)peer.getProtocolProvider().getOperationSet(OperationSetDTMF.class);
                if (dtmfOpSet == null) continue;
                dtmfOpSet.startSendingDTMF(peer, info.tone);
                CallPeerRenderer peerRenderer = this.callContainer.getCurrentCallRenderer().getCallPeerRenderer(peer);
                if (peerRenderer == null) continue;
                peerRenderer.printDTMFTone(info.keyChar);
            }
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to send a DTMF tone.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startSendingDtmfTone(DTMFToneInfo info) {
        List calls;
        if (info.sound != null) {
            List<DTMFToneInfo> list = this.dtmfToneNotifications;
            synchronized (list) {
                this.dtmfToneNotifications.add(info);
                this.startDTMFToneNotificationThreadIfNecessary();
            }
        }
        List list = calls = this.callContainer == null ? CallManager.getInProgressCalls() : this.callContainer.getCallConference().getCalls();
        if (calls != null && !calls.isEmpty()) {
            for (Call call : calls) {
                this.startSendingDtmfTone(call, info);
            }
        }
    }

    public void startSendingDtmfTone(String toneValue) {
        for (int i = 0; i < AVAILABLE_TONES.length; ++i) {
            DTMFToneInfo info = AVAILABLE_TONES[i];
            if (!info.tone.getValue().equals(toneValue)) continue;
            this.startSendingDtmfTone(info);
            return;
        }
    }

    public synchronized void stopSendingDtmfTone() {
        List calls;
        List list = calls = this.callContainer == null ? CallManager.getInProgressCalls() : this.callContainer.getCallConference().getCalls();
        if (calls != null && !calls.isEmpty()) {
            for (Call call : calls) {
                this.stopSendingDtmfTone(call);
            }
        }
    }

    private void stopSendingDtmfTone(Call call) {
        Iterator callPeers = call.getCallPeers();
        try {
            while (callPeers.hasNext()) {
                CallPeer peer = (CallPeer)callPeers.next();
                OperationSetDTMF dtmfOpSet = (OperationSetDTMF)peer.getProtocolProvider().getOperationSet(OperationSetDTMF.class);
                if (dtmfOpSet == null) continue;
                dtmfOpSet.stopSendingDTMF(peer);
            }
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to send a DTMF tone.", t);
        }
    }

    public static class DTMFToneInfo {
        public final ImageID imageID;
        public final ImageID imageIDPressed;
        public final ImageID imageIDRollover;
        public final char keyChar;
        public final int keyCode;
        public final ImageID macImageID;
        public final ImageID macImageRolloverID;
        public final String sound;
        public final DTMFTone tone;

        public DTMFToneInfo(DTMFTone tone, int keyCode, char keyChar, ImageID imageID, ImageID imageIDPressed, ImageID imageIDRollover, ImageID macImageID, ImageID macImageRolloverID, String sound) {
            this.tone = tone;
            this.keyCode = keyCode;
            this.keyChar = keyChar;
            this.imageID = imageID;
            this.imageIDPressed = imageIDPressed;
            this.imageIDRollover = imageIDRollover;
            this.macImageID = macImageID;
            this.macImageRolloverID = macImageRolloverID;
            this.sound = sound;
        }
    }
}

