/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionRenderer;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.service.filehistory.FileHistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.protocol.OperationSet;

public abstract class ChatSession {
    protected final String[] chatHistoryFilter = new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName()};
    protected final List<ChatContact<?>> chatParticipants = new ArrayList();
    protected final List<ChatTransport> chatTransports = new LinkedList<ChatTransport>();
    private final List<ChatSessionChangeListener> chatTransportChangeListeners = new ArrayList<ChatSessionChangeListener>();
    protected String persistableAddress = null;

    public abstract Object getDescriptor();

    public String getPersistableAddress() {
        return this.persistableAddress;
    }

    public abstract boolean isDescriptorPersistent();

    public Iterator<ChatContact<?>> getParticipants() {
        return this.chatParticipants.iterator();
    }

    public Iterator<ChatTransport> getChatTransports() {
        return this.chatTransports.iterator();
    }

    public abstract ChatTransport getCurrentChatTransport();

    public List<ChatTransport> getTransportsForOperationSet(Class<? extends OperationSet> opSetClass) {
        LinkedList<ChatTransport> opSetTransports = new LinkedList<ChatTransport>();
        for (ChatTransport transport : this.chatTransports) {
            if (transport.getProtocolProvider().getOperationSet(opSetClass) == null) continue;
            opSetTransports.add(transport);
        }
        return opSetTransports;
    }

    public abstract ChatSessionRenderer getChatSessionRenderer();

    public abstract void setCurrentChatTransport(ChatTransport var1);

    public abstract String getChatName();

    public abstract Collection<Object> getHistory(int var1);

    public abstract Collection<Object> getHistoryBeforeDate(Date var1, int var2);

    public abstract Collection<Object> getHistoryAfterDate(Date var1, int var2);

    public abstract Date getHistoryStartDate();

    public abstract Date getHistoryEndDate();

    public abstract String getDefaultSmsNumber();

    public abstract void setDefaultSmsNumber(String var1);

    public abstract void dispose();

    public ChatTransport findChatTransportForDescriptor(Object descriptor, String resourceName) {
        for (ChatTransport chatTransport : this.chatTransports) {
            String transportResName = chatTransport.getResourceName();
            if (!chatTransport.getDescriptor().equals(descriptor) || resourceName != null && (transportResName == null || !transportResName.equals(resourceName))) continue;
            return chatTransport;
        }
        return null;
    }

    public abstract ImageIcon getChatStatusIcon();

    public abstract byte[] getChatAvatar();

    public abstract boolean isContactListSupported();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatTransportChangeListener(ChatSessionChangeListener l) {
        List<ChatSessionChangeListener> list = this.chatTransportChangeListeners;
        synchronized (list) {
            if (!this.chatTransportChangeListeners.contains(l)) {
                this.chatTransportChangeListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatTransportChangeListener(ChatSessionChangeListener l) {
        List<ChatSessionChangeListener> list = this.chatTransportChangeListeners;
        synchronized (list) {
            this.chatTransportChangeListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCurrentChatTransportChange() {
        ArrayList<ChatSessionChangeListener> listeners = null;
        List<ChatSessionChangeListener> list = this.chatTransportChangeListeners;
        synchronized (list) {
            listeners = new ArrayList<ChatSessionChangeListener>(this.chatTransportChangeListeners);
        }
        for (ChatSessionChangeListener l : listeners) {
            l.currentChatTransportChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCurrentChatTransportUpdated(int eventID) {
        ArrayList<ChatSessionChangeListener> listeners = null;
        List<ChatSessionChangeListener> list = this.chatTransportChangeListeners;
        synchronized (list) {
            listeners = new ArrayList<ChatSessionChangeListener>(this.chatTransportChangeListeners);
        }
        for (ChatSessionChangeListener l : listeners) {
            l.currentChatTransportUpdated(eventID);
        }
    }
}

