/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.configforms;

import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.UnifiedToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.configforms.ConfigFormDescriptor;
import net.java.sip.communicator.impl.gui.main.configforms.ConfigFormList;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ConfigurationContainer;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ConfigurationFrame
extends SIPCommDialog
implements ConfigurationContainer,
ServiceListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(ConfigurationFrame.class);
    private static final int BORDER_SIZE = 20;
    private final ConfigFormList configList;
    private final JPanel centerPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
    public static final String SHOW_ACCOUNT_CONFIG_PROPERTY = "net.java.sip.communicator.impl.gui.main.configforms.SHOW_ACCOUNT_CONFIG";
    public static final String SHOW_OPTIONS_WINDOW_PROPERTY = "net.java.sip.communicator.impl.gui.main.configforms.SHOW_OPTIONS_WINDOW";

    public ConfigurationFrame(MainFrame mainFrame) {
        super((Frame)((Object)mainFrame), false);
        Collection cfgFormRefs;
        this.configList = new ConfigFormList(this);
        JScrollPane configScrollList = new JScrollPane();
        configScrollList.setHorizontalScrollBarPolicy(31);
        configScrollList.setBorder(null);
        configScrollList.setOpaque(false);
        configScrollList.getViewport().setOpaque(false);
        configScrollList.getViewport().add(this.configList);
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.SETTINGS"));
        this.getContentPane().setLayout(new BorderLayout());
        this.addDefaultForms();
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        this.centerPanel.setMinimumSize(new Dimension(600, 100));
        this.centerPanel.setMaximumSize(new Dimension(600, Integer.MAX_VALUE));
        mainPanel.add((Component)this.centerPanel, (Object)"Center");
        JComponent topComponent = this.createTopComponent();
        topComponent.add(configScrollList);
        mainPanel.add((Component)topComponent, (Object)"North");
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.getContentPane().add((Component)mainPanel);
        GuiActivator.bundleContext.addServiceListener((ServiceListener)this);
        String osgiFilter = "(FORM_TYPE=GENERAL_TYPE)";
        try {
            cfgFormRefs = GuiActivator.bundleContext.getServiceReferences(ConfigurationForm.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            cfgFormRefs = null;
        }
        if (cfgFormRefs != null && !cfgFormRefs.isEmpty()) {
            for (ServiceReference cfgFormRef : cfgFormRefs) {
                ConfigurationForm form = (ConfigurationForm)GuiActivator.bundleContext.getService(cfgFormRef);
                this.addConfigurationForm(form);
            }
        }
    }

    private JComponent createTopComponent() {
        Object topComponent = null;
        if (OSUtils.IS_MAC) {
            UnifiedToolBar macToolbarPanel = new UnifiedToolBar();
            MacUtils.makeWindowLeopardStyle(this.getRootPane());
            macToolbarPanel.getComponent().setLayout(new BorderLayout());
            macToolbarPanel.disableBackgroundPainter();
            macToolbarPanel.installWindowDraggerOnWindow((Window)((Object)this));
            this.centerPanel.setOpaque(true);
            this.centerPanel.setBackground(new Color(GuiActivator.getResources().getColor("service.gui.MAC_PANEL_BACKGROUND")));
            topComponent = macToolbarPanel.getComponent();
        } else {
            topComponent = new TransparentPanel((LayoutManager)new BorderLayout());
            topComponent.setBorder(new EmptyBorder(10, 20, 0, 0));
        }
        return topComponent;
    }

    public void addDefaultForms() {
        if (ConfigurationUtils.isShowAccountConfig()) {
            this.addConfigurationForm((ConfigurationForm)new LazyConfigurationForm("net.java.sip.communicator.impl.gui.main.account.AccountsConfigurationPanel", ((Object)((Object)this)).getClass().getClassLoader(), "service.gui.icons.ACCOUNT_ICON", "service.gui.ACCOUNTS", 0));
        }
    }

    public void showFormContent(ConfigFormDescriptor configFormDescriptor) {
        this.centerPanel.removeAll();
        JComponent configFormPanel = (JComponent)configFormDescriptor.getConfigFormPanel();
        configFormPanel.setOpaque(false);
        this.centerPanel.add((Component)configFormPanel, "Center");
        this.centerPanel.revalidate();
        this.centerPanel.setPreferredSize(new Dimension(550, configFormPanel.getPreferredSize().height + 40));
        this.pack();
    }

    public void setVisible(final boolean isVisible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationFrame.this.setVisible(isVisible);
                }
            });
            return;
        }
        if (isVisible && this.configList.getSelectedIndex() < 0) {
            this.configList.setSelectedIndex(0);
        }
        super.setVisible(isVisible);
        super.toFront();
    }

    protected void close(boolean isEscaped) {
        this.setVisible(false);
    }

    public void serviceChanged(ServiceEvent event) {
        if (!GuiActivator.isStarted) {
            return;
        }
        ServiceReference serRef = event.getServiceReference();
        Object property = serRef.getProperty("FORM_TYPE");
        if (property != "GENERAL_TYPE") {
            return;
        }
        Object service = GuiActivator.bundleContext.getService(serRef);
        if (!(service instanceof ConfigurationForm)) {
            return;
        }
        ConfigurationForm cfgForm = (ConfigurationForm)service;
        if (cfgForm.isAdvanced()) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Handling registration of a new Configuration Form.");
                }
                this.addConfigurationForm(cfgForm);
                break;
            }
            case 4: {
                this.removeConfigurationForm(cfgForm);
            }
        }
    }

    private void addConfigurationForm(final ConfigurationForm configForm) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationFrame.this.addConfigurationForm(configForm);
                }
            });
            return;
        }
        this.configList.addConfigForm(configForm);
    }

    private void removeConfigurationForm(final ConfigurationForm configForm) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationFrame.this.removeConfigurationForm(configForm);
                }
            });
            return;
        }
        this.configList.removeConfigForm(configForm);
    }

    public void setSelected(final ConfigurationForm configForm) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationFrame.this.setSelected(configForm);
                }
            });
            return;
        }
        this.configList.setSelected(configForm);
    }

    public void validateCurrentForm() {
        this.centerPanel.revalidate();
        this.centerPanel.setPreferredSize(null);
        this.validate();
        this.centerPanel.setPreferredSize(new Dimension(550, this.centerPanel.getHeight()));
        this.pack();
    }
}

