/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.addgroup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.addgroup.CreateGroupPanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListException;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.util.Logger;

public class CreateGroupDialog
extends SIPCommDialog
implements ActionListener,
WindowFocusListener {
    private final Logger logger = Logger.getLogger((String)CreateGroupDialog.class.getName());
    private CreateGroupPanel groupPanel = new CreateGroupPanel();
    private JButton addButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CREATE"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2, 5, 0));
    private TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private MetaContactListService clist = GuiActivator.getContactListService();
    private MetaContactGroup newMetaGroup;

    public CreateGroupDialog(Dialog parentWindow) {
        this(parentWindow, true);
    }

    public CreateGroupDialog(Frame parentWindow) {
        this(parentWindow, true);
    }

    public CreateGroupDialog(Dialog parentWindow, boolean isSaveSizeAndLocation) {
        super(parentWindow, isSaveSizeAndLocation);
        this.init();
    }

    public CreateGroupDialog(Frame parentWindow, boolean isSaveSizeAndLocation) {
        super(parentWindow, isSaveSizeAndLocation);
        this.init();
    }

    private void init() {
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.CREATE_GROUP"));
        this.getRootPane().setDefaultButton(this.addButton);
        this.addButton.setName("create");
        this.cancelButton.setName("cancel");
        this.addButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CREATE"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.buttonsPanel.add((Component)this.addButton);
        this.buttonsPanel.add((Component)this.cancelButton);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.mainPanel.add((Component)((Object)this.groupPanel), (Object)"Center");
        this.mainPanel.add((Component)this.buttonsPanel, (Object)"South");
        this.getContentPane().add((Component)this.mainPanel);
        this.addWindowFocusListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        if (name.equals("create")) {
            String groupName = this.groupPanel.getGroupName().trim();
            if (groupName.length() == 0) {
                this.groupPanel.showErrorMessage(GuiActivator.getResources().getI18NString("service.gui.ADD_GROUP_EMPTY_NAME", new String[]{groupName}));
            } else {
                new CreateGroup(this.clist, groupName).start();
            }
        } else if (name.equals("cancel")) {
            this.dispose();
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.groupPanel.requestFocusInField();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    public MetaContactGroup getNewMetaGroup() {
        return this.newMetaGroup;
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    private class CreateGroup
    extends Thread {
        MetaContactListService mcl;
        String groupName;

        CreateGroup(MetaContactListService mcl, String groupName) {
            this.mcl = mcl;
            this.groupName = groupName;
        }

        @Override
        public void run() {
            try {
                CreateGroupDialog.this.newMetaGroup = this.mcl.createMetaContactGroup(this.mcl.getRoot(), this.groupName);
                CreateGroupDialog.this.dispose();
            }
            catch (MetaContactListException ex) {
                CreateGroupDialog.this.logger.error((Object)ex);
                int errorCode = ex.getErrorCode();
                if (errorCode == 4) {
                    CreateGroupDialog.this.groupPanel.showErrorMessage(GuiActivator.getResources().getI18NString("service.gui.ADD_GROUP_EXIST_ERROR", new String[]{this.groupName}));
                }
                if (errorCode == 1) {
                    CreateGroupDialog.this.groupPanel.showErrorMessage(GuiActivator.getResources().getI18NString("service.gui.ADD_GROUP_LOCAL_ERROR", new String[]{this.groupName}));
                }
                if (errorCode == 2) {
                    CreateGroupDialog.this.groupPanel.showErrorMessage(GuiActivator.getResources().getI18NString("service.gui.ADD_GROUP_NET_ERROR", new String[]{this.groupName}));
                }
                CreateGroupDialog.this.groupPanel.showErrorMessage(GuiActivator.getResources().getI18NString("service.gui.ADD_GROUP_ERROR", new String[]{this.groupName}));
            }
        }
    }
}

