/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.notifsource;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationContactSource;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationGroup;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.UIContactDetailImpl;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.NotificationMessage;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetMessageWaiting;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import org.jitsi.service.resources.ResourceManagementService;

public class NotificationContact
extends UIContactImpl
implements RegistrationStateChangeListener,
ProviderPresenceStatusListener {
    private static final String VOICEMAIL_TIP = GuiActivator.getResources().getI18NString("service.gui.VOICEMAIL_TIP");
    private static final String VOICEMAIL_TIP_NO_ACCOUNT = GuiActivator.getResources().getI18NString("service.gui.VOICEMAIL_TIP_NO_ACCOUNT");
    private NotificationGroup parentGroup;
    private final ProtocolProviderService protocolProvider;
    private final NotificationMessage notificationMessage;
    private ContactNode contactNode;
    private UIContactDetail notificationDetail;
    private int unreadUrgentMessageCount = 0;
    private int unreadMessageCount = 0;
    private int readMessageCount = 0;
    private OperationSetMessageWaiting.MessageType messageType;

    public NotificationContact(NotificationGroup group, ProtocolProviderService protocolProvider, OperationSetMessageWaiting.MessageType messageType, NotificationMessage notificationMessage) {
        this.parentGroup = group;
        this.protocolProvider = protocolProvider;
        this.messageType = messageType;
        this.notificationMessage = notificationMessage;
        protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        OperationSetPresence presenceOpSet = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presenceOpSet != null) {
            presenceOpSet.addProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
        }
    }

    public Object getDescriptor() {
        return this.protocolProvider;
    }

    @Override
    public String getDisplayName() {
        if (this.notificationMessage != null) {
            return this.notificationMessage.getFromContact();
        }
        return GuiActivator.getUIService().getMainFrame().getAccountDisplayName(this.protocolProvider);
    }

    public String getDisplayDetails() {
        if (this.notificationMessage != null) {
            return this.notificationMessage.getMessageDetails();
        }
        ResourceManagementService resources = GuiActivator.getResources();
        String displayDetails = this.unreadUrgentMessageCount > 0 && this.unreadMessageCount > 0 && this.readMessageCount > 0 ? resources.getI18NString("service.gui.VOICEMAIL_NEW_URGENT_OLD_RECEIVED", new String[]{Integer.toString(this.unreadMessageCount), Integer.toString(this.unreadUrgentMessageCount), Integer.toString(this.readMessageCount)}) : (this.unreadMessageCount > 0 && this.readMessageCount > 0 ? resources.getI18NString("service.gui.VOICEMAIL_NEW_OLD_RECEIVED", new String[]{Integer.toString(this.unreadMessageCount), Integer.toString(this.readMessageCount)}) : (this.unreadUrgentMessageCount > 0 && this.unreadMessageCount > 0 ? resources.getI18NString("service.gui.VOICEMAIL_NEW_URGENT_RECEIVED", new String[]{Integer.toString(this.unreadMessageCount), Integer.toString(this.unreadUrgentMessageCount)}) : (this.unreadMessageCount > 0 ? resources.getI18NString("service.gui.VOICEMAIL_NEW_RECEIVED", new String[]{Integer.toString(this.unreadMessageCount)}) : (this.readMessageCount > 0 ? resources.getI18NString("service.gui.VOICEMAIL_OLD_RECEIVED", new String[]{Integer.toString(this.readMessageCount)}) : resources.getI18NString("service.gui.VOICEMAIL_NO_MESSAGES")))));
        return displayDetails;
    }

    public int getSourceIndex() {
        return -1;
    }

    @Override
    public ImageIcon getScaledAvatar(boolean isSelected, int width, int height) {
        ImageIcon avatarIcon = null;
        if (this.messageType.equals((Object)OperationSetMessageWaiting.MessageType.VOICE)) {
            avatarIcon = GuiActivator.getResources().getImage("service.gui.icons.VOICEMAIL");
        }
        return avatarIcon;
    }

    @Override
    public ImageIcon getStatusIcon() {
        OperationSetPresence presence = (OperationSetPresence)this.protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presence != null) {
            return new ImageIcon(Constants.getStatusIcon(presence.getPresenceStatus()));
        }
        if (this.protocolProvider.isRegistered()) {
            return new ImageIcon(GlobalStatusEnum.ONLINE.getStatusIcon());
        }
        return new ImageIcon(GlobalStatusEnum.OFFLINE.getStatusIcon());
    }

    public ExtendedTooltip getToolTip() {
        ExtendedTooltip tip = new ExtendedTooltip(true);
        ImageIcon avatarImage = this.getScaledAvatar(true, 64, 64);
        if (avatarImage != null) {
            tip.setImage(avatarImage);
        }
        tip.setTitle(this.protocolProvider.getAccountID().getDisplayName());
        tip.addLine(new JLabel[]{new JLabel(this.getDisplayDetails())});
        tip.addLine(null, " ");
        if (this.notificationDetail != null && this.notificationDetail.getAddress() != null) {
            tip.setBottomText(VOICEMAIL_TIP);
        } else {
            tip.setBottomText(VOICEMAIL_TIP_NO_ACCOUNT);
        }
        return tip;
    }

    public JPopupMenu getRightButtonMenu() {
        return null;
    }

    public UIGroup getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(UIGroup parentGroup) {
        if (!(parentGroup instanceof NotificationGroup)) {
            return;
        }
        this.parentGroup = (NotificationGroup)parentGroup;
    }

    public Iterator<String> getSearchStrings() {
        return null;
    }

    @Override
    public ContactNode getContactNode() {
        return this.contactNode;
    }

    @Override
    public void setContactNode(ContactNode contactNode) {
        this.contactNode = contactNode;
    }

    public UIContactDetail getDefaultContactDetail(Class<? extends OperationSet> opSetClass) {
        if (opSetClass.equals(OperationSetBasicTelephony.class)) {
            return this.notificationDetail;
        }
        return null;
    }

    public List<UIContactDetail> getContactDetails() {
        LinkedList<UIContactDetail> resultList = new LinkedList<UIContactDetail>();
        resultList.add(this.notificationDetail);
        return resultList;
    }

    public List<UIContactDetail> getContactDetailsForOperationSet(Class<? extends OperationSet> opSetClass) {
        LinkedList<UIContactDetail> resultList = new LinkedList<UIContactDetail>();
        if (opSetClass.equals(OperationSetBasicTelephony.class)) {
            resultList.add(this.notificationDetail);
        }
        return resultList;
    }

    public void setMessageAccount(String messageAccount) {
        this.notificationDetail = new MessageWaitingDetail(this.protocolProvider, messageAccount);
    }

    public void setUnreadUrgentMessageCount(int count) {
        this.unreadUrgentMessageCount = count;
    }

    public int getUrgentUnreadMessageCount() {
        return this.unreadUrgentMessageCount;
    }

    public void setUnreadMessageCount(int count) {
        this.unreadMessageCount = count;
    }

    public int getUnreadMessageCount() {
        return this.unreadMessageCount;
    }

    public void setReadMessageCount(int count) {
        this.readMessageCount = count;
    }

    public NotificationMessage getNotificationMessage() {
        return this.notificationMessage;
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        RegistrationState newState = evt.getNewState();
        if (newState.equals((Object)RegistrationState.UNREGISTERED) || newState.equals((Object)RegistrationState.REGISTERED)) {
            TreeContactList contactList = GuiActivator.getContactList();
            contactList.refreshContact(this);
        }
    }

    public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
        TreeContactList contactList = GuiActivator.getContactList();
        contactList.refreshContact(this);
    }

    public Collection<SIPCommButton> getContactCustomActionButtons() {
        if (this.notificationMessage != null) {
            return NotificationContactSource.getContactCustomActionButtons(this);
        }
        return null;
    }

    public void providerStatusMessageChanged(PropertyChangeEvent evt) {
    }

    private class MessageWaitingDetail
    extends UIContactDetailImpl {
        public MessageWaitingDetail(ProtocolProviderService protocolProvider, String messageAccount) {
            super(messageAccount, messageAccount, ImageLoader.getAccountStatusImage(protocolProvider), (Object)NotificationContact.this.notificationMessage);
            for (Class opSetClass : protocolProvider.getSupportedOperationSetClasses()) {
                this.addPreferredProtocolProvider(opSetClass, protocolProvider);
                this.addPreferredProtocol(opSetClass, protocolProvider.getProtocolName());
            }
        }

        public PresenceStatus getPresenceStatus() {
            return null;
        }
    }
}

