/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import org.jetbrains.annotations.Nullable;

public class InterestInfo
implements LiveWritable {
    public static final int TYPE_PARENT = 1;
    public static final int TYPE_CHILD = 2;
    private final int type;
    private final int parent;
    private final String name;
    private final int totalSize;

    @Nullable
    protected static InterestInfo readInterestInfo(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() < 4) {
            return null;
        }
        short type = BinaryTools.getUByte(block, 0);
        short parent = BinaryTools.getUByte(block, 1);
        int namelen = BinaryTools.getUShort(block, 2);
        if (block.getLength() < namelen + 4) {
            return null;
        }
        ByteBlock nameBlock = block.subBlock(4, namelen);
        String name = BinaryTools.getAsciiString(nameBlock);
        int size = 4 + namelen;
        return new InterestInfo(type, parent, name, size);
    }

    protected InterestInfo(int type, int parent, String name, int totalSize) {
        DefensiveTools.checkRange(type, "type", 0);
        DefensiveTools.checkRange(parent, "parent", 0);
        DefensiveTools.checkNull(name, "name");
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        this.type = type;
        this.parent = parent;
        this.name = name;
        this.totalSize = totalSize;
    }

    public InterestInfo(int type, int parent, String name) {
        this(type, parent, name, -1);
    }

    public final int getType() {
        return this.type;
    }

    public final int getParentId() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUByte(out, this.type);
        BinaryTools.writeUByte(out, this.parent);
        byte[] namebytes = BinaryTools.getAsciiBytes(this.name);
        BinaryTools.writeUShort(out, namebytes.length);
        out.write(namebytes);
    }

    public String toString() {
        return "InterestInfo: type=" + this.type + ", parent=" + this.parent + ": " + this.name;
    }
}

