/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.systemtray.awt;

import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.java.sip.communicator.impl.osdependent.systemtray.TrayIcon;
import net.java.sip.communicator.impl.osdependent.systemtray.awt.AWTMouseAdapter;

public class AWTTrayIcon
implements TrayIcon {
    private final java.awt.TrayIcon impl;

    public AWTTrayIcon(Image image, String tooltip, Object popup) {
        if (popup instanceof JPopupMenu) {
            this.impl = new java.awt.TrayIcon(image, tooltip);
            this.impl.addMouseListener(new AWTMouseAdapter((JPopupMenu)popup));
        } else if (popup instanceof PopupMenu) {
            this.impl = new java.awt.TrayIcon(image, tooltip, (PopupMenu)popup);
        } else if (popup == null) {
            this.impl = new java.awt.TrayIcon(image, tooltip);
        } else {
            throw new IllegalArgumentException("Invalid popup menu type");
        }
    }

    @Override
    public void setDefaultAction(final Object menuItem) {
        ActionListener[] listeners;
        ActionListener[] previous;
        for (ActionListener l : previous = this.impl.getActionListeners()) {
            this.impl.removeActionListener(l);
        }
        if (menuItem instanceof JMenuItem) {
            listeners = ((JMenuItem)menuItem).getActionListeners();
        } else if (menuItem instanceof MenuItem) {
            listeners = ((MenuItem)menuItem).getActionListeners();
        } else {
            return;
        }
        this.impl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionListener l : listeners) {
                    l.actionPerformed(new ActionEvent(menuItem, e.getID(), e.getActionCommand()));
                }
            }
        });
    }

    @Override
    public void addBalloonActionListener(ActionListener listener) {
    }

    @Override
    public void displayMessage(String caption, String text, TrayIcon.MessageType messageType) throws NullPointerException {
        this.impl.displayMessage(caption, text, messageType);
    }

    @Override
    public void setIcon(ImageIcon icon) throws NullPointerException {
        this.impl.setImage(icon.getImage());
    }

    @Override
    public void setIconAutoSize(boolean autoSize) {
        this.impl.setImageAutoSize(autoSize);
    }

    java.awt.TrayIcon getImpl() {
        return this.impl;
    }
}

