/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.provdisc.dhcp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import net.java.sip.communicator.impl.provdisc.dhcp.DHCPTransaction;
import net.java.sip.communicator.impl.provdisc.dhcp.ProvisioningDiscoveryDHCPActivator;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.provdisc.event.DiscoveryEvent;
import net.java.sip.communicator.service.provdisc.event.DiscoveryListener;
import net.java.sip.communicator.util.Logger;
import org.dhcp4java.DHCPOption;
import org.dhcp4java.DHCPPacket;

public class DHCPProvisioningDiscover
implements Runnable {
    private final Logger logger = Logger.getLogger(DHCPProvisioningDiscover.class);
    private static final int DHCP_TIMEOUT = 10000;
    private DatagramSocket socket = null;
    private int xid = 0;
    private int port = 6768;
    private byte option = (byte)-32;
    private List<DiscoveryListener> listeners = new ArrayList<DiscoveryListener>();

    public DHCPProvisioningDiscover(int port, byte option) throws Exception {
        this.port = port;
        this.option = option;
        this.socket = new DatagramSocket(port);
        this.xid = new Random().nextInt();
        this.socket.setSoTimeout(10000);
    }

    public String discoverProvisioningURL() {
        DHCPPacket inform = new DHCPPacket();
        byte[] macAddress = null;
        byte[] zeroIPAddress = new byte[]{0, 0, 0, 0};
        byte[] broadcastIPAddr = new byte[]{-1, -1, -1, -1};
        DHCPOption[] dhcpOpts = new DHCPOption[1];
        ArrayList<DHCPTransaction> transactions = new ArrayList<DHCPTransaction>();
        try {
            inform.setOp((byte)1);
            inform.setHtype((byte)1);
            inform.setHlen((byte)6);
            inform.setHops((byte)0);
            inform.setXid(this.xid);
            inform.setSecs((short)0);
            inform.setFlags((short)0);
            inform.setYiaddr(InetAddress.getByAddress(zeroIPAddress));
            inform.setSiaddr(InetAddress.getByAddress(zeroIPAddress));
            inform.setGiaddr(InetAddress.getByAddress(zeroIPAddress));
            inform.setDhcp(true);
            inform.setDHCPMessageType((byte)8);
            dhcpOpts[0] = new DHCPOption(55, new byte[]{this.option});
            inform.setOptions(dhcpOpts);
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                Enumeration<InetAddress> enAddr = iface.getInetAddresses();
                while (enAddr.hasMoreElements()) {
                    InetAddress addr = enAddr.nextElement();
                    if (!(addr instanceof Inet4Address)) continue;
                    NetworkAddressManagerService netaddr = ProvisioningDiscoveryDHCPActivator.getNetworkAddressManagerService();
                    if (addr.isLoopbackAddress()) continue;
                    macAddress = netaddr.getHardwareAddress(iface);
                    DHCPPacket p = inform.clone();
                    p.setCiaddr(addr);
                    p.setChaddr(macAddress);
                    byte[] msg = p.serialize();
                    DatagramPacket pkt = new DatagramPacket(msg, msg.length, InetAddress.getByAddress(broadcastIPAddr), this.port - 1);
                    DHCPTransaction transaction = new DHCPTransaction(this.socket, pkt);
                    transaction.schedule();
                    transactions.add(transaction);
                    msg = null;
                    pkt = null;
                    p = null;
                }
            }
            boolean found = false;
            try {
                DatagramPacket pkt2 = new DatagramPacket(new byte[1500], 1500);
                while (!found) {
                    DHCPOption optProvisioning;
                    this.socket.receive(pkt2);
                    DHCPPacket dhcp = DHCPPacket.getPacket(pkt2);
                    if (dhcp.getXid() != this.xid || (optProvisioning = dhcp.getOption(this.option)) == null) continue;
                    found = true;
                    for (DHCPTransaction t : transactions) {
                        t.cancel();
                    }
                    return new String(optProvisioning.getValue());
                }
            }
            catch (SocketTimeoutException est) {
                this.logger.warn((Object)"Timeout, no DHCP answer received", (Throwable)est);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception occurred during DHCP discover", (Throwable)e);
        }
        for (DHCPTransaction t : transactions) {
            t.cancel();
        }
        return null;
    }

    @Override
    public void run() {
        String url = this.discoverProvisioningURL();
        if (url != null) {
            DiscoveryEvent evt = new DiscoveryEvent((Object)this, url);
            for (DiscoveryListener listener : this.listeners) {
                listener.notifyProvisioningURL(evt);
            }
        }
    }

    public void addDiscoveryListener(DiscoveryListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDiscoveryListener(DiscoveryListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

