/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.Control;
import javax.media.Controller;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class Utility {
    public static MediaLocator appArgToMediaLocator(String arg) {
        Object url = null;
        try {
            return new MediaLocator(new URL(arg));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new MediaLocator(Utility.fileToURL(arg));
            }
            catch (MalformedURLException malformedURLException2) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new MediaLocator(arg);
        }
    }

    public static MediaLocator appletArgToMediaLocator(Applet applet, String arg) {
        Object url = null;
        try {
            return new MediaLocator(new URL(arg));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new MediaLocator(new URL(applet.getDocumentBase(), arg));
            }
            catch (MalformedURLException malformedURLException2) {
                return new MediaLocator(arg);
            }
        }
    }

    public static Icon createDisabledIcon(ImageIcon imageIcon) {
        Image i = GrayFilter.createDisabledImage(imageIcon.getImage());
        return new ImageIcon(i);
    }

    public static URL fileToURL(String fileName) throws IOException, MalformedURLException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IOException("File " + fileName + " does not exist.");
        }
        return new URL("file:///" + file.getCanonicalPath());
    }

    public static String getExtension(File f) {
        return Utility.getExtension(f.getName());
    }

    public static String getExtension(String filename) {
        String ext = null;
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            ext = filename.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static Time getMaximumLatency(Controller[] controllers) {
        Time maxLatency = new Time(0.0);
        double maxSeconds = 0.0;
        for (int i = 0; i < controllers.length; ++i) {
            double thisSeconds;
            Time thisTime;
            if (controllers[i].getState() < 300 || (thisTime = controllers[i].getStartLatency()) == Controller.LATENCY_UNKNOWN || !((thisSeconds = thisTime.getSeconds()) > maxSeconds)) continue;
            maxLatency = thisTime;
        }
        return maxLatency;
    }

    public static int pickAMaster(Player[] players) {
        for (int i = 0; i < players.length; ++i) {
            GainControl gain = players[i].getGainControl();
            if (gain == null || gain.getControlComponent() == null) continue;
            return i;
        }
        return 0;
    }

    public static void showControls(Controller controller) {
        Control[] controls = controller.getControls();
        for (int i = 0; i < controls.length; ++i) {
            Component c = controls[i].getControlComponent();
            if (c == null || c.isShowing()) continue;
            JFrame frame = new JFrame(controls[i].getClass().getName());
            frame.getContentPane().add(c);
            frame.pack();
            frame.setVisible(true);
        }
    }

    public static String stateToString(int state) {
        switch (state) {
            case 100: {
                return "Unrealized";
            }
            case 200: {
                return "Realizing";
            }
            case 300: {
                return "Realized";
            }
            case 400: {
                return "Prefetching";
            }
            case 500: {
                return "Prefetched";
            }
            case 600: {
                return "Started";
            }
        }
        return null;
    }
}

