/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Buffer;
import net.sf.fmj.media.BasicConnector;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.OutputConnector;

public class BasicInputConnector
extends BasicConnector
implements InputConnector {
    protected OutputConnector outputConnector = null;
    private boolean reset = false;

    @Override
    public OutputConnector getOutputConnector() {
        return this.outputConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getValidBuffer() {
        switch (this.protocol) {
            case 0: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (!this.isValidBufferAvailable() && this.reset) {
                        return null;
                    }
                    this.reset = false;
                    return this.circularBuffer.read();
                }
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    this.reset = false;
                    while (!this.reset && !this.isValidBufferAvailable()) {
                        try {
                            this.circularBuffer.wait();
                        }
                        catch (Exception exception) {}
                    }
                    if (this.reset) {
                        return null;
                    }
                    Buffer buffer = this.circularBuffer.read();
                    this.circularBuffer.notifyAll();
                    return buffer;
                }
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isValidBufferAvailable() {
        return this.circularBuffer.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readReport() {
        switch (this.protocol) {
            case 0: 
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        return;
                    }
                    this.circularBuffer.readReport();
                    this.circularBuffer.notifyAll();
                    return;
                }
            }
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        CircularBuffer circularBuffer = this.circularBuffer;
        synchronized (circularBuffer) {
            this.reset = true;
            super.reset();
            this.circularBuffer.notifyAll();
        }
    }

    @Override
    public void setOutputConnector(OutputConnector outputConnector) {
        this.outputConnector = outputConnector;
    }
}

