/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;

public class GsmParser
extends AbstractDemultiplexer {
    private static double GSM_FRAME_RATE = 50.0;
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("audio.x_gsm")};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;

    private static final double secondsToNanos(double secs) {
        return secs * 1.0E9;
    }

    @Override
    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    @Override
    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    @Override
    public boolean isPositionable() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    @Override
    public Time setPosition(Time where, int rounding) {
        return null;
    }

    @Override
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    @Override
    public void start() throws IOException {
        this.source.start();
        PullSourceStream[] streamsForFormat = this.source.getStreams();
        this.tracks = new PullSourceStreamTrack[streamsForFormat.length];
        for (int i = 0; i < streamsForFormat.length; ++i) {
            this.tracks[i] = new PullSourceStreamTrack(streamsForFormat[i]);
        }
    }

    @Override
    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    private class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStream stream;
        private long frameLength;
        private static final int GSM_FRAME_SIZE = 33;

        public PullSourceStreamTrack(PullSourceStream stream) {
            this.stream = stream;
            this.frameLength = stream.getContentLength() / 33L;
        }

        @Override
        public Time getDuration() {
            long lengthInFrames = this.frameLength;
            if (lengthInFrames < 0L) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (1)");
                return Duration.DURATION_UNKNOWN;
            }
            double lengthInSeconds = (double)lengthInFrames / GSM_FRAME_RATE;
            if (lengthInSeconds < 0.0) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (2)");
                return Duration.DURATION_UNKNOWN;
            }
            double lengthInNanos = GsmParser.secondsToNanos(lengthInSeconds);
            logger.fine("PullSourceStreamTrack: returning " + (long)lengthInNanos);
            return new Time((long)lengthInNanos);
        }

        @Override
        public Format getFormat() {
            return new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray);
        }

        @Override
        public void readFrame(Buffer buffer) {
            int BUFFER_SIZE = 16500;
            if (buffer.getData() == null) {
                buffer.setData(new byte[16500]);
            }
            byte[] bytes = (byte[])buffer.getData();
            try {
                int result = this.stream.read(bytes, 0, bytes.length);
                if (result < 0) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                buffer.setLength(result);
                buffer.setOffset(0);
            }
            catch (IOException e) {
                buffer.setEOM(true);
                buffer.setDiscard(true);
                buffer.setLength(0);
                logger.log(Level.WARNING, "" + e, e);
            }
        }
    }
}

