/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.msoutlook;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactDetail;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookAddrBookContactQuery;
import net.java.sip.communicator.plugin.addrbook.msoutlook.MsOutlookMAPIHResultException;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.EditableSourceContact;
import net.java.sip.communicator.service.contactsource.GenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.util.Logger;

public class MsOutlookAddrBookSourceContact
extends GenericSourceContact
implements EditableSourceContact {
    private static final Logger logger = Logger.getLogger(MsOutlookAddrBookSourceContact.class);
    private Boolean locked = Boolean.FALSE;
    private Vector<String> ids = new Vector(1, 1);

    public MsOutlookAddrBookSourceContact(ContactSourceService contactSource, String id, String displayName, String organization, List<ContactDetail> contactDetails) {
        super(contactSource, displayName, contactDetails);
        this.setData(SourceContact.DATA_ID, id);
        this.setDisplayDetails(organization);
        this.ids.add(id);
    }

    public String getId() {
        return (String)this.getData(SourceContact.DATA_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(List<ContactDetail> details) {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            this.contactDetails.clear();
            this.contactDetails.addAll(details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            this.setDisplayPostalAddress();
            for (ContactDetail contactDetail : this.contactDetails) {
                if (!(contactDetail instanceof MsOutlookAddrBookContactDetail)) continue;
                MsOutlookAddrBookContactDetail outlookContactDetail = (MsOutlookAddrBookContactDetail)contactDetail;
                for (Long propId : outlookContactDetail.getOutlookPropId()) {
                    MsOutlookAddrBookContactQuery.IMAPIProp_SetPropString(propId, contactDetail.getDetail(), this.getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactDetail(ContactDetail detail) {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            int i = 0;
            while (i < this.contactDetails.size()) {
                MsOutlookAddrBookContactDetail contactDetail = (MsOutlookAddrBookContactDetail)((Object)this.contactDetails.get(i));
                if (contactDetail.match(detail)) {
                    this.removeProperty(contactDetail);
                    this.contactDetails.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public void removeProperty(MsOutlookAddrBookContactDetail contactDetail) {
        for (Long propId : contactDetail.getOutlookPropId()) {
            MsOutlookAddrBookContactQuery.IMAPIProp_DeleteProp(propId, this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContactDetail(ContactDetail detail) {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            MsOutlookAddrBookContactDetail addDetail;
            if (!(detail instanceof MsOutlookAddrBookContactDetail)) {
                long property = MsOutlookAddrBookContactQuery.getProperty(detail.getCategory(), detail.getSubCategories());
                Collection subCategories = detail.getSubCategories();
                addDetail = new MsOutlookAddrBookContactDetail(detail.getDetail(), detail.getCategory(), subCategories.toArray(new ContactDetail.SubCategory[subCategories.size()]), property);
            } else {
                addDetail = (MsOutlookAddrBookContactDetail)detail;
            }
            for (int i = 0; i < this.contactDetails.size(); ++i) {
                MsOutlookAddrBookContactDetail contactDetail = (MsOutlookAddrBookContactDetail)((Object)this.contactDetails.get(i));
                if (!contactDetail.match((ContactDetail)addDetail)) continue;
                return;
            }
            this.contactDetails.add(addDetail);
        }
    }

    public void setDisplayName(String displayName) {
        if (displayName != null && !displayName.equals(this.getDisplayName())) {
            long[] displayNamePropIdList = new long[]{12289L, 55L, 32831L, 3613L};
            for (int i = 0; i < displayNamePropIdList.length; ++i) {
                MsOutlookAddrBookContactQuery.IMAPIProp_SetPropString(displayNamePropIdList[i], displayName, this.getId());
            }
        }
        super.setDisplayName(displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated() {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            Object[] props;
            block5: {
                this.waitUnlock();
                props = null;
                try {
                    props = MsOutlookAddrBookContactQuery.IMAPIProp_GetProps(this.getId(), MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS, Integer.MIN_VALUE);
                }
                catch (MsOutlookMAPIHResultException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)(MsOutlookAddrBookContactQuery.class.getSimpleName() + "#IMAPIProp_GetProps(long, long[], long)"), (Throwable)e);
                }
            }
            List<ContactDetail> contactDetails = MsOutlookAddrBookContactQuery.getContactDetails(props);
            this.setDetails(contactDetails);
            String displayName = MsOutlookAddrBookContactQuery.getDisplayName(props);
            this.setDisplayName(displayName);
            String organization = MsOutlookAddrBookContactQuery.getOrganization(props);
            this.setDisplayDetails(organization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            this.locked = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            this.save();
            this.locked = Boolean.FALSE;
            ((Object)((Object)this)).notify();
        }
    }

    private void waitUnlock() {
        boolean continueToWait = this.locked;
        while (continueToWait) {
            try {
                ((Object)((Object)this)).wait();
                continueToWait = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getIndex() {
        return -1;
    }

    public boolean match(String id, int level) {
        boolean res = false;
        switch (level) {
            case 0: {
                res = this.ids.contains(id);
                break;
            }
            case 1: {
                String localId = this.getId();
                res = MsOutlookAddrBookContactQuery.compareEntryIds(id, localId);
                if (!res || this.ids.contains(id)) break;
                this.ids.add(id);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayPostalAddress() {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            boolean firstLineCR = false;
            boolean secondLineCR = false;
            String workAddress = "";
            MsOutlookAddrBookContactDetail detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[30]);
            if (detail != null) {
                workAddress = workAddress + detail.getDetail();
                firstLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[26])) != null) {
                if (firstLineCR) {
                    workAddress = workAddress + "\r";
                    firstLineCR = false;
                }
                workAddress = workAddress + detail.getDetail();
                workAddress = workAddress + " ";
                secondLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[29])) != null) {
                if (firstLineCR) {
                    workAddress = workAddress + "\r";
                    firstLineCR = false;
                }
                workAddress = workAddress + detail.getDetail();
                secondLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[28])) != null) {
                if (firstLineCR) {
                    workAddress = workAddress + "\r";
                    firstLineCR = false;
                }
                workAddress = workAddress + detail.getDetail();
                workAddress = workAddress + " ";
                secondLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[27])) != null) {
                if (secondLineCR) {
                    workAddress = workAddress + "\r";
                    secondLineCR = false;
                }
                workAddress = workAddress + detail.getDetail();
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[37])) != null) {
                detail.setDetail(workAddress);
            } else if (workAddress.length() > 0) {
                detail = new MsOutlookAddrBookContactDetail(workAddress, MsOutlookAddrBookContactQuery.getCategory(37), MsOutlookAddrBookContactQuery.getSubCategories(37), MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[37]);
                this.contactDetails.add(detail);
            }
            firstLineCR = false;
            secondLineCR = false;
            String homeAddress = "";
            detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[35]);
            if (detail != null) {
                homeAddress = homeAddress + detail.getDetail();
                firstLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[31])) != null) {
                if (firstLineCR) {
                    homeAddress = homeAddress + "\r";
                    firstLineCR = false;
                }
                homeAddress = homeAddress + detail.getDetail();
                homeAddress = homeAddress + " ";
                secondLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[34])) != null) {
                if (firstLineCR) {
                    homeAddress = homeAddress + "\r";
                    firstLineCR = false;
                }
                homeAddress = homeAddress + detail.getDetail();
                secondLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[33])) != null) {
                if (firstLineCR) {
                    homeAddress = homeAddress + "\r";
                    firstLineCR = false;
                }
                homeAddress = homeAddress + detail.getDetail();
                homeAddress = homeAddress + " ";
                secondLineCR = true;
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[32])) != null) {
                if (secondLineCR) {
                    homeAddress = homeAddress + "\r";
                    secondLineCR = false;
                }
                homeAddress = homeAddress + detail.getDetail();
            }
            if ((detail = this.findDetail(MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[36])) != null) {
                detail.setDetail(homeAddress);
            } else if (homeAddress.length() > 0) {
                detail = new MsOutlookAddrBookContactDetail(homeAddress, MsOutlookAddrBookContactQuery.getCategory(36), MsOutlookAddrBookContactQuery.getSubCategories(36), MsOutlookAddrBookContactQuery.MAPI_MAILUSER_PROP_IDS[36]);
                this.contactDetails.add(detail);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MsOutlookAddrBookContactDetail findDetail(long detailPropId) {
        MsOutlookAddrBookSourceContact msOutlookAddrBookSourceContact = this;
        synchronized (msOutlookAddrBookSourceContact) {
            for (ContactDetail contactDetail : this.contactDetails) {
                if (!(contactDetail instanceof MsOutlookAddrBookContactDetail)) continue;
                MsOutlookAddrBookContactDetail outlookContactDetail = (MsOutlookAddrBookContactDetail)contactDetail;
                for (Long propId : outlookContactDetail.getOutlookPropId()) {
                    if (propId != detailPropId) continue;
                    return outlookContactDetail;
                }
            }
        }
        return null;
    }
}

