/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FamilyVersionsCmd
extends ConnCommand {
    private final List<SnacFamilyInfo> families;

    protected FamilyVersionsCmd(int command, SnacPacket packet) {
        super(command);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        int num = snacData.getLength() / 4;
        ArrayList<SnacFamilyInfo> families = new ArrayList<SnacFamilyInfo>(num);
        for (int i = 0; i < num; ++i) {
            int family = BinaryTools.getUShort(snacData, i * 4);
            int version = BinaryTools.getUShort(snacData, i * 4 + 2);
            families.add(new SnacFamilyInfo(family, version));
        }
        this.families = DefensiveTools.getUnmodifiable(families);
    }

    protected FamilyVersionsCmd(int command, Collection<SnacFamilyInfo> families) {
        super(command);
        this.families = DefensiveTools.getSafeListCopy(families, "families");
    }

    public final List<SnacFamilyInfo> getSnacFamilyInfos() {
        return this.families;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        if (this.families != null) {
            for (SnacFamilyInfo family1 : this.families) {
                BinaryTools.writeUShort(out, family1.getFamily());
                BinaryTools.writeUShort(out, family1.getVersion());
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MiscTools.getClassName(this) + ": family versions: ");
        if (this.families != null) {
            for (SnacFamilyInfo family1 : this.families) {
                buffer.append(Integer.toHexString(family1.getFamily()));
                buffer.append(" (v=");
                buffer.append(Integer.toHexString(family1.getVersion()));
                buffer.append("), ");
            }
        }
        return buffer.toString();
    }
}

