/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.SingleBuddyRequest;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class GetInfoCmd
extends LocCommand
implements SingleBuddyRequest {
    public static final long FLAG_INFO = 1L;
    public static final long FLAG_AWAYMSG = 2L;
    public static final long FLAG_CERT = 8L;
    private final long flags;
    private final String sn;

    protected GetInfoCmd(SnacPacket packet) {
        super(21);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock data = packet.getData();
        this.flags = BinaryTools.getUInt(data, 0);
        ByteBlock snData = data.subBlock(4);
        StringBlock snBlock = OscarTools.readScreenname(snData);
        this.sn = snBlock == null ? null : snBlock.getString();
    }

    public GetInfoCmd(long flags, String sn) {
        super(21);
        DefensiveTools.checkRange(flags, "flags", -1L);
        DefensiveTools.checkNull(sn, "sn");
        this.flags = flags;
        this.sn = sn;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.flags != -1L) {
            BinaryTools.writeUInt(out, this.flags);
            if (this.sn != null) {
                OscarTools.writeScreenname(out, this.sn);
            }
        }
    }

    public String toString() {
        return "GetInfoCmd: flags=" + this.flags + " (" + MiscTools.getFlagFieldsString(GetInfoCmd.class, this.flags, "FLAG_.*") + ")" + ", sn=" + this.sn;
    }
}

