/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.bos;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.snaccmd.conn.ExtraInfoAck;
import net.kano.joscar.snaccmd.conn.MyInfoRequest;
import net.kano.joscar.snaccmd.conn.ServiceRedirect;
import net.kano.joscar.snaccmd.conn.ServiceRequest;
import net.kano.joscar.snaccmd.conn.SetEncryptionInfoCmd;
import net.kano.joscar.snaccmd.conn.SetExtraInfoCmd;
import net.kano.joscar.snaccmd.conn.SetIdleCmd;
import net.kano.joscar.snaccmd.conn.YourInfoCmd;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.bos.AbstractBosService;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosServiceListener;
import net.kano.joustsim.oscar.oscar.service.bos.OpenedChatRoomServiceListener;
import net.kano.joustsim.oscar.oscar.service.bos.OpenedExternalServiceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainBosServiceImpl
extends AbstractBosService
implements MainBosService {
    private static final Logger LOGGER = Logger.getLogger(MainBosServiceImpl.class.getName());
    private CopyOnWriteArrayList<MainBosServiceListener> listeners = new CopyOnWriteArrayList();
    private Date idleSince = null;
    private boolean visibleStatus = true;

    public MainBosServiceImpl(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection);
    }

    protected void serverReady() {
        List<ExtraInfoBlock> blocks = Arrays.asList(new ExtraInfoBlock(1026, new ExtraInfoData(1, CertificateInfo.HASHA_DEFAULT)), new ExtraInfoBlock(1027, new ExtraInfoData(1, CertificateInfo.HASHB_DEFAULT)));
        this.sendSnac(new SetEncryptionInfoCmd(blocks));
        this.sendSnac(new MyInfoRequest());
    }

    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        SnacCommand snac = snacPacketEvent.getSnacCommand();
        if (snac instanceof YourInfoCmd) {
            YourInfoCmd yic = (YourInfoCmd)snac;
            for (MainBosServiceListener listener : this.listeners) {
                listener.handleYourInfo(this, yic.getUserInfo());
            }
        } else if (snac instanceof ExtraInfoAck) {
            ExtraInfoAck ack = (ExtraInfoAck)snac;
            for (MainBosServiceListener listener : this.listeners) {
                listener.handleYourExtraInfo(ack.getExtraInfos());
            }
        }
        super.handleSnacPacket(snacPacketEvent);
    }

    public void setIdleSince(@NotNull Date at) throws IllegalArgumentException {
        DefensiveTools.checkNull(at, "at");
        long idlems = System.currentTimeMillis() - at.getTime();
        if (idlems < 0L) {
            throw new IllegalArgumentException("attempted to set idle time to " + at + ", which was " + idlems + "ms ago");
        }
        long idleSecs = idlems / 1000L;
        this.setIdleSinceDate(at);
        this.sendSnac(new SetIdleCmd(idleSecs));
    }

    public void setUnidle() {
        this.setIdleSinceDate(null);
        this.sendSnac(new SetIdleCmd(0L));
    }

    private synchronized void setIdleSinceDate(Date since) {
        this.idleSince = since;
    }

    public synchronized Date getIdleSince() {
        return this.idleSince;
    }

    public synchronized void setVisibleStatus(boolean visible) {
        if (this.visibleStatus == visible) {
            return;
        }
        this.visibleStatus = visible;
        long flag = this.visibleStatus ? 0L : 256L;
        this.sendSnac(new SetExtraInfoCmd(flag));
    }

    public synchronized void setStatusMessage(@Nullable String msg) {
        this.setStatusMessageSong(msg, null);
    }

    public synchronized void setIcqStatus(long icqStatus) {
        this.sendSnac(new SetExtraInfoCmd(icqStatus));
    }

    private ExtraInfoBlock buildStatusMsgBlock(int type, @Nullable String msg) {
        String useMsg = msg == null ? "" : msg;
        return new ExtraInfoBlock(type, ExtraInfoData.getAvailableMessageBlock(useMsg));
    }

    public synchronized void setStatusMessageSong(@Nullable String msg, @Nullable String band, @Nullable String album, @Nullable String song) {
        this.setStatusMessageSong(msg, ExtraInfoData.buildItunesUrl(band, album, song));
    }

    public synchronized void setStatusMessageSong(@Nullable String msg, @Nullable String url) {
        this.sendSnac(new SetExtraInfoCmd(this.buildStatusMsgBlock(2, msg), this.buildStatusMsgBlock(9, url)));
    }

    public void addMainBosServiceListener(MainBosServiceListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeMainBosServiceListener(MainBosServiceListener listener) {
        this.listeners.remove(listener);
    }

    public void requestService(int service, OpenedExternalServiceListener listener) {
        this.sendSnacRequest(new ServiceRequest(service), new ServiceRequestResponseListener(listener));
    }

    public void requestChatService(final FullRoomInfo info, final OpenedChatRoomServiceListener listener) {
        OpenedExternalServiceListener internalListener = new OpenedExternalServiceListener(){

            public void handleServiceRedirect(MainBosService service, int serviceFamily, String host, int port, ByteBlock flapCookie) {
                if (serviceFamily != 14) {
                    LOGGER.warning("server returned service " + serviceFamily + " when we requested " + service);
                }
                listener.handleChatRoomRedirect(service, info, host, port, flapCookie);
            }
        };
        this.sendSnacRequest(new ServiceRequest(new MiniRoomInfo(info)), new ServiceRequestResponseListener(internalListener));
    }

    private class ServiceRequestResponseListener
    extends SnacRequestAdapter {
        private final OpenedExternalServiceListener listener;

        public ServiceRequestResponseListener(OpenedExternalServiceListener listener) {
            this.listener = listener;
        }

        public void handleResponse(SnacResponseEvent e) {
            SnacCommand cmd = e.getSnacCommand();
            if (cmd instanceof ServiceRedirect) {
                ServiceRedirect redirect = (ServiceRedirect)cmd;
                int returnedFamily = redirect.getSnacFamily();
                this.listener.handleServiceRedirect(MainBosServiceImpl.this, returnedFamily, redirect.getRedirectHost(), redirect.getRedirectPort(), redirect.getCookie());
            } else {
                LOGGER.warning("unexpected response to service request: " + cmd);
            }
        }
    }
}

