/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.sipaccregwizz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.sipaccregwizz.Resources;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountRegistrationForm;
import net.java.sip.communicator.service.protocol.sip.SipAccountID;

public class PresencePanel
extends TransparentPanel
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private JPanel presenceOpPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel buttonsPresOpPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private JPanel labelsPresOpPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private JPanel valuesPresOpPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private final JCheckBox enablePresOpButton;
    private final JCheckBox forceP2PPresOpButton;
    private JLabel pollPeriodLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.OFFLINE_CONTACT_POLLING_PERIOD"));
    private JLabel subscribeExpiresLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.SUBSCRIPTION_EXPIRATION"));
    private JTextField pollPeriodField = new JTextField(SipAccountID.getDefaultStr((String)"POLLING_PERIOD"));
    private JTextField subscribeExpiresField = new JTextField(SipAccountID.getDefaultStr((String)"SUBSCRIPTION_EXPIRATION"));
    private JTextField clistOptionServerUriValue = new JTextField();
    private JTextField clistOptionUserValue = new JTextField();
    private JPasswordField clistOptionPasswordValue = new JPasswordField();
    private final JCheckBox clistOptionUseSipCredentialsBox;
    private String[] contactlistOptions = new String[]{"Local", "XCAP", "XiVO"};
    private JComboBox contactlistOptionsCombo = new JComboBox<String>(this.contactlistOptions);

    public PresencePanel(SIPAccountRegistrationForm regform) {
        super((LayoutManager)new BorderLayout(10, 10));
        TransparentPanel mainPanel = new TransparentPanel();
        mainPanel.setLayout(new BoxLayout((Container)mainPanel, 1));
        this.enablePresOpButton = new SIPCommCheckBox(Resources.getString("plugin.sipaccregwizz.ENABLE_PRESENCE"), regform.getRegistration().isEnablePresence());
        this.forceP2PPresOpButton = new SIPCommCheckBox(Resources.getString("plugin.sipaccregwizz.FORCE_P2P_PRESENCE"), regform.getRegistration().isForceP2PMode());
        this.clistOptionUseSipCredentialsBox = new SIPCommCheckBox(Resources.getString("plugin.sipaccregwizz.XCAP_USE_SIP_CREDENTIALS"), regform.getRegistration().isClistOptionUseSipCredentials());
        if (regform.getRegistration().isXCapEnable()) {
            this.clistOptionServerUriValue.setText(regform.getRegistration().getClistOptionServerUri());
        }
        this.enablePresOpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCheckBox cb = (JCheckBox)evt.getSource();
                PresencePanel.this.setPresenceOptionsEnabled(cb.isSelected());
            }
        });
        this.labelsPresOpPanel.add(this.pollPeriodLabel);
        this.labelsPresOpPanel.add(this.subscribeExpiresLabel);
        this.valuesPresOpPanel.add(this.pollPeriodField);
        this.valuesPresOpPanel.add(this.subscribeExpiresField);
        this.buttonsPresOpPanel.add(this.enablePresOpButton);
        this.buttonsPresOpPanel.add(this.forceP2PPresOpButton);
        this.presenceOpPanel.add((Component)this.buttonsPresOpPanel, "North");
        this.presenceOpPanel.add((Component)this.labelsPresOpPanel, "West");
        this.presenceOpPanel.add((Component)this.valuesPresOpPanel, "Center");
        this.presenceOpPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.PRESENCE_OPTIONS")));
        this.clistOptionUseSipCredentialsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCheckBox checkBox = (JCheckBox)evt.getSource();
                PresencePanel.this.setClistOptionUseSipCredentialsEnabled(checkBox.isSelected());
            }
        });
        TransparentPanel xCapServerUriPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        xCapServerUriPanel.add((Component)new JLabel(Resources.getString("plugin.sipaccregwizz.XCAP_SERVER_URI")), "West");
        xCapServerUriPanel.add((Component)this.clistOptionServerUriValue, "Center");
        String xcapUri = regform.getRegistration().getClistOptionServerUri();
        if (xcapUri != null) {
            this.clistOptionServerUriValue.setText(xcapUri);
        }
        TransparentPanel xCapPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        TransparentPanel xCapButtonsPanel = new TransparentPanel();
        xCapButtonsPanel.setLayout(new BoxLayout((Container)xCapButtonsPanel, 1));
        TransparentPanel xCapCredentialsLabelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 0, 0));
        TransparentPanel xCapCredentialsValuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 0, 0));
        TransparentPanel contactlistTypePanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
        contactlistTypePanel.add(new JLabel(Resources.getString("plugin.sipaccregwizz.CLIST_TYPE")));
        contactlistTypePanel.add(this.contactlistOptionsCombo);
        this.contactlistOptionsCombo.addActionListener(this);
        if (regform.getRegistration().isXCapEnable()) {
            this.setXCapEnable(true);
        } else if (regform.getRegistration().isXiVOEnable()) {
            this.setXiVOEnable(true);
        }
        this.updateContactListPanel();
        xCapServerUriPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        xCapButtonsPanel.add((Component)contactlistTypePanel);
        xCapButtonsPanel.add((Component)xCapServerUriPanel);
        TransparentPanel credPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        credPanel.add((Component)this.clistOptionUseSipCredentialsBox, "West");
        credPanel.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        xCapButtonsPanel.add((Component)credPanel);
        xCapCredentialsLabelsPanel.add(new JLabel(Resources.getString("plugin.sipaccregwizz.XCAP_USER")));
        xCapCredentialsLabelsPanel.add(new JLabel(Resources.getString("plugin.sipaccregwizz.XCAP_PASSWORD")));
        xCapCredentialsValuesPanel.add(this.clistOptionUserValue);
        xCapCredentialsValuesPanel.add(this.clistOptionPasswordValue);
        xCapCredentialsLabelsPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        xCapPanel.add((Component)xCapButtonsPanel, "North");
        xCapPanel.add((Component)xCapCredentialsLabelsPanel, "West");
        xCapPanel.add((Component)xCapCredentialsValuesPanel, "Center");
        xCapPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.XCAP_OPTIONS")));
        mainPanel.add(this.presenceOpPanel);
        mainPanel.add((Component)xCapPanel);
        this.add((Component)mainPanel, "North");
    }

    void setPresenceOptionsEnabled(boolean isEnabled) {
        this.forceP2PPresOpButton.setEnabled(isEnabled);
        this.pollPeriodField.setEnabled(isEnabled);
        this.subscribeExpiresField.setEnabled(isEnabled);
    }

    void setClistOptionUseSipCredentialsEnabled(boolean isEnabled) {
        this.clistOptionUserValue.setEnabled(!isEnabled);
        this.clistOptionPasswordValue.setEnabled(!isEnabled);
    }

    void setClistOptionEnableEnabled(boolean isEnabled) {
        this.clistOptionUseSipCredentialsBox.setEnabled(isEnabled);
        this.clistOptionServerUriValue.setEnabled(isEnabled);
        if (isEnabled) {
            this.setClistOptionUseSipCredentialsEnabled(this.clistOptionUseSipCredentialsBox.isSelected());
        } else {
            this.setClistOptionUseSipCredentialsEnabled(true);
        }
    }

    boolean isPresenceEnabled() {
        return this.enablePresOpButton.isSelected();
    }

    void setPresenceEnabled(boolean isPresenceEnabled) {
        this.enablePresOpButton.setSelected(isPresenceEnabled);
    }

    boolean isForcePeerToPeerMode() {
        return this.forceP2PPresOpButton.isSelected();
    }

    void setForcePeerToPeerMode(boolean forceP2P) {
        this.forceP2PPresOpButton.setSelected(forceP2P);
    }

    String getPollPeriod() {
        return this.pollPeriodField.getText();
    }

    void setPollPeriod(String pollPeriod) {
        this.pollPeriodField.setText(pollPeriod);
    }

    String getSubscriptionExpiration() {
        return this.subscribeExpiresField.getText();
    }

    void setSubscriptionExpiration(String subscExp) {
        this.subscribeExpiresField.setText(subscExp);
    }

    boolean isXCapEnable() {
        Object o = this.contactlistOptionsCombo.getSelectedItem();
        return o != null && o.equals(this.contactlistOptions[1]);
    }

    void setXCapEnable(boolean xCapEnable) {
        if (xCapEnable) {
            this.contactlistOptionsCombo.setSelectedItem(this.contactlistOptions[1]);
            this.updateContactListPanel();
        }
    }

    boolean isXiVOEnable() {
        Object o = this.contactlistOptionsCombo.getSelectedItem();
        return o != null && o.equals(this.contactlistOptions[2]);
    }

    void setXiVOEnable(boolean xivoEnable) {
        if (xivoEnable) {
            this.contactlistOptionsCombo.setSelectedItem(this.contactlistOptions[2]);
            this.updateContactListPanel();
        }
    }

    boolean isClistOptionUseSipCredentials() {
        return this.clistOptionUseSipCredentialsBox.isSelected();
    }

    void setClistOptionUseSipCredentials(boolean clistOptionUseSipCredentials) {
        this.clistOptionUseSipCredentialsBox.setSelected(clistOptionUseSipCredentials);
    }

    String getClistOptionServerUri() {
        return this.clistOptionServerUriValue.getText();
    }

    void setClistOptionServerUri(String xCapServerUri) {
        this.clistOptionServerUriValue.setText(xCapServerUri);
    }

    String getClistOptionUser() {
        return this.clistOptionUserValue.getText();
    }

    void setClistOptionUser(String clistOptionUser) {
        this.clistOptionUserValue.setText(clistOptionUser);
    }

    char[] getClistOptionPassword() {
        return this.clistOptionPasswordValue.getPassword();
    }

    void setClistOptionPassword(String xCapPassword) {
        this.clistOptionPasswordValue.setText(xCapPassword);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateContactListPanel();
    }

    private void updateContactListPanel() {
        Object obj = this.contactlistOptionsCombo.getSelectedItem();
        if (obj == null || obj.equals(this.contactlistOptions[0])) {
            this.clistOptionUseSipCredentialsBox.setEnabled(false);
            this.clistOptionServerUriValue.setEnabled(false);
            this.clistOptionUserValue.setEnabled(false);
            this.clistOptionPasswordValue.setEnabled(false);
        } else {
            this.clistOptionUseSipCredentialsBox.setEnabled(true);
            this.clistOptionServerUriValue.setEnabled(true);
            this.setClistOptionUseSipCredentialsEnabled(this.clistOptionUseSipCredentialsBox.isSelected());
        }
    }

    public void reinit() {
        this.setClistOptionEnableEnabled(false);
        this.setClistOptionUseSipCredentials(false);
        this.setClistOptionUseSipCredentialsEnabled(false);
        this.setClistOptionServerUri(null);
        this.setClistOptionUser(null);
        this.setClistOptionPassword(null);
        this.contactlistOptionsCombo.setSelectedItem(this.contactlistOptions[0]);
    }
}

