/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.pluginmanager;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.pluginmanager.NewBundleDialog;
import net.java.sip.communicator.plugin.pluginmanager.PluginManagerActivator;
import net.java.sip.communicator.plugin.pluginmanager.Resources;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ManageButtonsPanel
extends TransparentPanel
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private Logger logger = Logger.getLogger(ManageButtonsPanel.class);
    private JButton deactivateButton = new JButton(Resources.getString("service.gui.DEACTIVATE"));
    private JButton activateButton = new JButton(Resources.getString("service.gui.ACTIVATE"));
    private JButton uninstallButton = new JButton(Resources.getString("plugin.pluginmanager.UNINSTALL"));
    private JButton updateButton = new JButton(Resources.getString("plugin.pluginmanager.UPDATE"));
    private JButton newButton = new JButton(Resources.getString("plugin.pluginmanager.NEW"));
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 8, 8));
    private JTable pluginTable;

    public ManageButtonsPanel(JTable pluginTable) {
        this.pluginTable = pluginTable;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.newButton.setOpaque(false);
        this.activateButton.setOpaque(false);
        this.deactivateButton.setOpaque(false);
        this.uninstallButton.setOpaque(false);
        this.updateButton.setOpaque(false);
        this.buttonsPanel.add(this.newButton);
        this.buttonsPanel.add(this.activateButton);
        this.buttonsPanel.add(this.deactivateButton);
        this.buttonsPanel.add(this.uninstallButton);
        this.buttonsPanel.add(this.updateButton);
        this.add(this.buttonsPanel, "North");
        this.newButton.addActionListener(this);
        this.activateButton.addActionListener(this);
        this.deactivateButton.addActionListener(this);
        this.uninstallButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.defaultButtonState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton sourceButton = (JButton)e.getSource();
        if (sourceButton.equals(this.newButton)) {
            NewBundleDialog dialog = new NewBundleDialog();
            dialog.pack();
            dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
            dialog.setVisible(true);
        } else if (sourceButton.equals(this.activateButton)) {
            int[] selectedRows = this.pluginTable.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                try {
                    ((Bundle)this.pluginTable.getModel().getValueAt(selectedRows[i], 0)).start();
                    continue;
                }
                catch (BundleException ex) {
                    this.logger.error((Object)"Failed to activate bundle.", (Throwable)ex);
                    PluginManagerActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)ex.getMessage(), "Error", 0);
                }
            }
            this.defaultButtonState();
        } else if (sourceButton.equals(this.deactivateButton)) {
            int[] selectedRows = this.pluginTable.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                try {
                    ((Bundle)this.pluginTable.getModel().getValueAt(selectedRows[i], 0)).stop();
                    continue;
                }
                catch (BundleException ex) {
                    this.logger.error((Object)"Failed to desactivate bundle.", (Throwable)ex);
                    PluginManagerActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)ex.getMessage(), "Error", 0);
                }
            }
            this.defaultButtonState();
        } else if (sourceButton.equals(this.uninstallButton)) {
            int[] selectedRows = this.pluginTable.getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                try {
                    ((Bundle)this.pluginTable.getModel().getValueAt(selectedRows[i], 0)).uninstall();
                    continue;
                }
                catch (BundleException ex) {
                    this.logger.error((Object)"Failed to uninstall bundle.", (Throwable)ex);
                    PluginManagerActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)ex.getMessage(), "Error", 0);
                }
            }
            this.defaultButtonState();
        } else if (sourceButton.equals(this.updateButton)) {
            int[] selectedRows = this.pluginTable.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                try {
                    ((Bundle)this.pluginTable.getModel().getValueAt(selectedRows[i], 0)).update();
                    continue;
                }
                catch (BundleException ex) {
                    this.logger.error((Object)"Failed to update bundle.", (Throwable)ex);
                    PluginManagerActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)ex.getMessage(), "Error", 0);
                }
            }
            this.defaultButtonState();
        }
    }

    public void defaultButtonState() {
        this.enableActivateButton(false);
        this.enableDeactivateButton(false);
        this.enableUninstallButton(false);
        this.enableUpdateButton(false);
    }

    public void enableActivateButton(boolean enable) {
        this.activateButton.setEnabled(enable);
    }

    public void enableDeactivateButton(boolean enable) {
        this.deactivateButton.setEnabled(enable);
    }

    public void enableUninstallButton(boolean enable) {
        this.uninstallButton.setEnabled(enable);
    }

    public void enableUpdateButton(boolean enable) {
        this.updateButton.setEnabled(enable);
    }
}

