/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import java.util.Iterator;
import java.util.Properties;
import org.jitsi.dnssec.R;
import org.jitsi.dnssec.SMessage;
import org.jitsi.dnssec.SRRset;
import org.jitsi.dnssec.SecurityStatus;
import org.jitsi.dnssec.validator.DnsSecVerifier;
import org.jitsi.dnssec.validator.JustifiedSecStatus;
import org.jitsi.dnssec.validator.KeyEntry;
import org.jitsi.dnssec.validator.ResponseClassification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;

public class ValUtils {
    private static final Logger logger = LoggerFactory.getLogger(ValUtils.class);
    private static final Name WILDCARD = Name.fromConstantString((String)"*");
    private static final String DIGEST_PREFERENCE = "org.jitsi.dnssec.digest_preference";
    private DnsSecVerifier verifier = new DnsSecVerifier();
    private int[] digestPreference = null;

    public void init(Properties config) {
        String dp = config.getProperty(DIGEST_PREFERENCE);
        if (dp != null) {
            String[] dpdata = dp.split(",");
            this.digestPreference = new int[dpdata.length];
            for (int i = 0; i < dpdata.length; ++i) {
                this.digestPreference[i] = Integer.parseInt(dpdata[i]);
                if (ValUtils.isDigestSupported(this.digestPreference[i])) continue;
                throw new IllegalArgumentException("Unsupported digest ID in digest preferences");
            }
        }
    }

    public static ResponseClassification classifyResponse(SMessage m) {
        if (m.getRcode() == 3 && m.getCount(1) == 0) {
            return ResponseClassification.NAMEERROR;
        }
        if (m.getCount(1) == 0) {
            return ResponseClassification.NODATA;
        }
        int qtype = m.getQuestion().getType();
        if (qtype == 255) {
            return ResponseClassification.ANY;
        }
        boolean hadCname = false;
        for (RRset rRset : m.getSectionRRsets(1)) {
            if (rRset.getType() == qtype) {
                return ResponseClassification.POSITIVE;
            }
            if (rRset.getType() != 5 && rRset.getType() != 39) continue;
            hadCname = true;
            if (qtype != 43) continue;
            return ResponseClassification.CNAME;
        }
        if (hadCname) {
            if (m.getRcode() == 3) {
                return ResponseClassification.CNAME_NAMEERROR;
            }
            return ResponseClassification.CNAME_NODATA;
        }
        logger.warn("Failed to classify response message:\n" + m);
        return ResponseClassification.UNKNOWN;
    }

    public KeyEntry verifyNewDNSKEYs(SRRset dnskeyRrset, SRRset dsRrset, long badKeyTTL) {
        if (!ValUtils.atLeastOneDigestSupported(dsRrset)) {
            KeyEntry ke = KeyEntry.newNullKeyEntry(dsRrset.getName(), dsRrset.getDClass(), dsRrset.getTTL());
            ke.setBadReason(R.get("failed.ds.nodigest", dsRrset.getName()));
            return ke;
        }
        if (!ValUtils.atLeastOneSupportedAlgorithm(dsRrset)) {
            KeyEntry ke = KeyEntry.newNullKeyEntry(dsRrset.getName(), dsRrset.getDClass(), dsRrset.getTTL());
            ke.setBadReason(R.get("failed.ds.noalg", dsRrset.getName()));
            return ke;
        }
        int favoriteDigestID = this.favoriteDSDigestID(dsRrset);
        Iterator i = dsRrset.rrs();
        while (i.hasNext()) {
            DSRecord ds = (DSRecord)i.next();
            if (ds.getDigestID() != favoriteDigestID) continue;
            Iterator j = dnskeyRrset.rrs();
            block1: while (j.hasNext()) {
                byte[] dsHash;
                DSRecord keyDigest;
                byte[] keyHash;
                DNSKEYRecord dnskey = (DNSKEYRecord)j.next();
                if (ds.getFootprint() != dnskey.getFootprint() || ds.getAlgorithm() != dnskey.getAlgorithm() || (keyHash = (keyDigest = new DSRecord(Name.root, ds.getDClass(), 0L, ds.getDigestID(), dnskey)).getDigest()).length != (dsHash = ds.getDigest()).length) continue;
                for (int k = 0; k < keyHash.length; ++k) {
                    if (keyHash[k] != dsHash[k]) continue block1;
                }
                SecurityStatus res = this.verifier.verify((RRset)dnskeyRrset, dnskey);
                if (res != SecurityStatus.SECURE) continue;
                logger.trace("DS matched DNSKEY.");
                dnskeyRrset.setSecurityStatus(SecurityStatus.SECURE);
                return KeyEntry.newKeyEntry(dnskeyRrset);
            }
        }
        KeyEntry badKey = KeyEntry.newBadKeyEntry(dsRrset.getName(), dsRrset.getDClass(), badKeyTTL);
        badKey.setBadReason(R.get("dnskey.no_ds_match", new Object[0]));
        return badKey;
    }

    int favoriteDSDigestID(SRRset dsset) {
        if (this.digestPreference == null) {
            int max = 0;
            Iterator rrs = dsset.rrs();
            while (rrs.hasNext()) {
                DSRecord r = (DSRecord)rrs.next();
                if (r.getDigestID() <= max || !ValUtils.isDigestSupported(r.getDigestID()) || !ValUtils.isAlgorithmSupported(r.getAlgorithm())) continue;
                max = r.getDigestID();
            }
            return max;
        }
        for (int i = 0; i < this.digestPreference.length; ++i) {
            Iterator rrs = dsset.rrs();
            while (rrs.hasNext()) {
                DSRecord r = (DSRecord)rrs.next();
                if (r.getDigestID() != this.digestPreference[i]) continue;
                return r.getDigestID();
            }
        }
        return 0;
    }

    public SecurityStatus verifySRRset(SRRset rrset, SRRset keyRrset) {
        String rrsetName = rrset.getName() + "/" + Type.string((int)rrset.getType()) + "/" + DClass.string((int)rrset.getDClass());
        if (rrset.getSecurityStatus() == SecurityStatus.SECURE) {
            logger.trace("verifySRRset: rrset <" + rrsetName + "> previously found to be SECURE");
            return SecurityStatus.SECURE;
        }
        SecurityStatus status = this.verifier.verify((RRset)rrset, keyRrset);
        if (status != SecurityStatus.SECURE) {
            logger.debug("verifySRRset: rrset <" + rrsetName + "> found to be BAD");
            status = SecurityStatus.BOGUS;
        } else {
            logger.trace("verifySRRset: rrset <" + rrsetName + "> found to be SECURE");
        }
        rrset.setSecurityStatus(status);
        return status;
    }

    public static Name rrsetWildcard(RRset rrset) {
        int labelDiff;
        Iterator it = rrset.sigs();
        RRSIGRecord rrsig = (RRSIGRecord)it.next();
        while (it.hasNext()) {
            if (((RRSIGRecord)it.next()).getLabels() == rrsig.getLabels()) continue;
            throw new RuntimeException("failed.wildcard.label_count_mismatch");
        }
        Name wn = rrset.getName();
        if (rrset.getName().isWild()) {
            wn = new Name(wn, 1);
        }
        if ((labelDiff = wn.labels() - 1 - rrsig.getLabels()) > 0) {
            return wn.wild(labelDiff);
        }
        return null;
    }

    public static Name longestCommonName(Name domain1, Name domain2) {
        int l = Math.min(domain1.labels(), domain2.labels());
        domain1 = new Name(domain1, domain1.labels() - l);
        domain2 = new Name(domain2, domain2.labels() - l);
        for (int i = 0; i < l - 1; ++i) {
            Name ns1 = new Name(domain1, i);
            if (!ns1.equals((Object)new Name(domain2, i))) continue;
            return ns1;
        }
        return Name.root;
    }

    public static boolean strictSubdomain(Name domain1, Name domain2) {
        if (domain1.labels() <= domain2.labels()) {
            return false;
        }
        return new Name(domain1, domain1.labels() - domain2.labels()).equals((Object)domain2);
    }

    public static Name closestEncloser(Name domain, NSECRecord nsec) {
        Name n1 = ValUtils.longestCommonName(domain, nsec.getName());
        Name n2 = ValUtils.longestCommonName(domain, nsec.getNext());
        return n1.labels() > n2.labels() ? n1 : n2;
    }

    public static Name nsecWildcard(Name domain, NSECRecord nsec) throws NameTooLongException {
        Name origin = ValUtils.closestEncloser(domain, nsec);
        return Name.concatenate((Name)WILDCARD, (Name)origin);
    }

    public static boolean nsecProvesNameError(NSECRecord nsec, Name qname, Name signerName) {
        Name owner = nsec.getName();
        Name next = nsec.getNext();
        if (qname.equals((Object)owner)) {
            return false;
        }
        if (!next.subdomain(signerName)) {
            return false;
        }
        if (qname.subdomain(owner)) {
            if (nsec.hasType(39)) {
                return false;
            }
            if (nsec.hasType(2) && !nsec.hasType(6)) {
                return false;
            }
        }
        return owner.equals((Object)next) ? ValUtils.strictSubdomain(qname, next) : (owner.compareTo((Object)next) > 0 ? owner.compareTo((Object)qname) < 0 && ValUtils.strictSubdomain(qname, next) : owner.compareTo((Object)qname) < 0 && qname.compareTo((Object)next) < 0);
    }

    public static boolean nsecProvesNoWC(NSECRecord nsec, Name qname, Name signerName) {
        int qnameLabels = qname.labels();
        Name ce = ValUtils.closestEncloser(qname, nsec);
        int ceLabels = ce.labels();
        for (int i = qnameLabels - ceLabels; i > 0; --i) {
            Name wcName = qname.wild(i);
            if (!ValUtils.nsecProvesNameError(nsec, wcName, signerName)) continue;
            return true;
        }
        return false;
    }

    public static NsecProvesNodataResponse nsecProvesNodata(NSECRecord nsec, Name qname, int qtype) {
        NsecProvesNodataResponse result = new NsecProvesNodataResponse();
        if (!nsec.getName().equals((Object)qname)) {
            if (ValUtils.strictSubdomain(nsec.getNext(), qname) && nsec.getName().compareTo((Object)qname) < 0) {
                result.result = true;
                return result;
            }
            if (nsec.getName().isWild()) {
                Name ce = new Name(nsec.getName(), 1);
                if (ValUtils.strictSubdomain(qname, ce)) {
                    if (nsec.hasType(5)) {
                        result.result = false;
                        return result;
                    }
                    if (nsec.hasType(2) && !nsec.hasType(6)) {
                        result.result = false;
                        return result;
                    }
                    if (nsec.hasType(qtype)) {
                        result.result = false;
                        return result;
                    }
                }
                result.wc = ce;
                result.result = true;
                return result;
            }
            result.result = false;
            return result;
        }
        if (nsec.hasType(qtype)) {
            result.result = false;
            return result;
        }
        if (nsec.hasType(5)) {
            result.result = false;
            return result;
        }
        if (qtype != 43 && nsec.hasType(2) && !nsec.hasType(6)) {
            result.result = false;
            return result;
        }
        if (qtype == 43 && nsec.hasType(6) && !Name.root.equals((Object)qname)) {
            result.result = false;
            return result;
        }
        result.result = true;
        return result;
    }

    public JustifiedSecStatus nsecProvesNodataDsReply(Message request, SMessage response, SRRset keyRrset) {
        int qclass;
        Name qname = request.getQuestion().getName();
        SRRset nsecRrset = response.findRRset(qname, 47, qclass = request.getQuestion().getDClass(), 2);
        if (nsecRrset != null) {
            SecurityStatus status = this.verifySRRset(nsecRrset, keyRrset);
            if (status != SecurityStatus.SECURE) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, R.get("failed.ds.nsec", new Object[0]));
            }
            NSECRecord nsec = (NSECRecord)nsecRrset.first();
            status = ValUtils.nsecProvesNoDS(nsec, qname);
            switch (status) {
                case INSECURE: {
                    return new JustifiedSecStatus(status, R.get("failed.ds.nodelegation", new Object[0]));
                }
                case SECURE: {
                    return new JustifiedSecStatus(status, R.get("insecure.ds.nsec", new Object[0]));
                }
            }
            return new JustifiedSecStatus(status, R.get("failed.ds.nsec.hasdata", new Object[0]));
        }
        NsecProvesNodataResponse ndp = new NsecProvesNodataResponse();
        Name ce = null;
        boolean hasValidNSEC = false;
        NSECRecord wcNsec = null;
        for (SRRset set : response.getSectionRRsets(2, 47)) {
            SecurityStatus status = this.verifySRRset(set, keyRrset);
            if (status != SecurityStatus.SECURE) {
                return new JustifiedSecStatus(status, R.get("failed.ds.nsec.ent", new Object[0]));
            }
            NSECRecord nsec = (NSECRecord)set.first();
            ndp = ValUtils.nsecProvesNodata(nsec, qname, 43);
            if (ndp.result) {
                hasValidNSEC = true;
                if (ndp.wc != null && nsec.getName().isWild()) {
                    wcNsec = nsec;
                }
            }
            if (!ValUtils.nsecProvesNameError(nsec, qname, set.getSignerName())) continue;
            ce = ValUtils.closestEncloser(qname, nsec);
        }
        if (!(ndp.wc == null || ce != null && ce.equals((Object)ndp.wc))) {
            hasValidNSEC = false;
        }
        if (hasValidNSEC) {
            if (ndp.wc != null) {
                SecurityStatus status = ValUtils.nsecProvesNoDS(wcNsec, qname);
                return new JustifiedSecStatus(status, R.get("failed.ds.nowildcardproof", new Object[0]));
            }
            return new JustifiedSecStatus(SecurityStatus.INSECURE, R.get("insecure.ds.nsec.ent", new Object[0]));
        }
        return new JustifiedSecStatus(SecurityStatus.UNCHECKED, R.get("failed.ds.nonconclusive", new Object[0]));
    }

    public boolean hasSignedNsecs(SMessage message) {
        for (SRRset set : message.getSectionRRsets(2)) {
            if (set.getType() != 47 && set.getType() != 50 || !set.sigs().hasNext()) continue;
            return true;
        }
        return false;
    }

    public static SecurityStatus nsecProvesNoDS(NSECRecord nsec, Name qname) {
        if (nsec.hasType(6) && !Name.root.equals((Object)qname) || nsec.hasType(43)) {
            return SecurityStatus.BOGUS;
        }
        if (!nsec.hasType(2)) {
            return SecurityStatus.INSECURE;
        }
        return SecurityStatus.SECURE;
    }

    static boolean atLeastOneSupportedAlgorithm(RRset dsRRset) {
        Iterator it = dsRRset.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            if (r.getType() != 43 || !ValUtils.isAlgorithmSupported(((DSRecord)r).getAlgorithm())) continue;
            return true;
        }
        return false;
    }

    static boolean isAlgorithmSupported(int alg) {
        switch (alg) {
            case 1: {
                return false;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    static boolean atLeastOneDigestSupported(RRset dsRRset) {
        Iterator it = dsRRset.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            if (r.getType() != 43 || !ValUtils.isDigestSupported(((DSRecord)r).getDigestID())) continue;
            return true;
        }
        return false;
    }

    static boolean isDigestSupported(int digestID) {
        switch (digestID) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static class NsecProvesNodataResponse {
        boolean result;
        Name wc;
    }
}

