/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.msofficecomm;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.msofficecomm.MessengerContact;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.xml.XMLUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Messenger {
    private static final Logger logger = Logger.getLogger(Messenger.class);
    static final int CONVERSATION_TYPE_AUDIO = 8;
    static final int CONVERSATION_TYPE_IM = 1;
    static final int CONVERSATION_TYPE_LIVEMEETING = 4;
    static final int CONVERSATION_TYPE_PHONE = 2;
    static final int CONVERSATION_TYPE_PSTN = 32;
    static final int CONVERSATION_TYPE_VIDEO = 16;
    static final int MISTATUS_AWAY = 34;
    static final int MISTATUS_MAY_BE_AVAILABLE = 162;
    static final int MISTATUS_OFFLINE = 1;
    static final int MISTATUS_ON_THE_PHONE = 50;
    static final int MISTATUS_IN_A_MEETING = 82;
    static final int MISTATUS_ONLINE = 2;
    static final int MISTATUS_UNKNOWN = 0;
    static final int MPHONE_TYPE_CUSTOM = 3;
    static final int MPHONE_TYPE_HOME = 0;
    static final int MPHONE_TYPE_MOBILE = 2;
    static final int MPHONE_TYPE_WORK = 1;
    private static final String PNAME_CREATE_CALL_BY_PHONE_NUMBER = "net.java.sip.communicator.plugin.msofficecomm.CREATE_CALL_BY_PHONE_NUMBER";
    private static final String PNAME_MPHONE_TYPE_SORT_ORDER = "net.java.sip.communicator.plugin.msofficecomm.MPHONE_TYPE_SORT_ORDER";
    private static BundleContext bundleContext;
    private static MetaContactListService metaContactListService;
    private static final int[] MPHONE_TYPE_SORT_ORDER;
    private static final Map<String, Self> selves;
    private static final ServiceListener serviceListener;

    private static synchronized void addSelf(String signinName, ProtocolProviderService pps, OperationSetPresence presenceOpSet) {
        Self self = selves.get(signinName);
        if (self == null) {
            self = new Self(signinName);
            selves.put(signinName, self);
        }
        self.addProtocolProviderService(pps, presenceOpSet);
    }

    private static List<Contact> findContactsBySigninName(ProtocolProviderService pps, OperationSetPresence presenceOpSet, String signinName) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        Iterator metaContactIt = metaContactListService.findAllMetaContactsForProvider(pps);
        while (metaContactIt.hasNext()) {
            MetaContact metaContact = (MetaContact)metaContactIt.next();
            Iterator contactIt = metaContact.getContacts();
            block1: while (contactIt.hasNext()) {
                Contact contact = (Contact)contactIt.next();
                if (signinName.equalsIgnoreCase(Messenger.getSigninName(contact, pps))) {
                    contacts.add(0, contact);
                    continue;
                }
                OperationSetServerStoredContactInfo serverStoredContactInfoOpSet = (OperationSetServerStoredContactInfo)pps.getOperationSet(OperationSetServerStoredContactInfo.class);
                if (serverStoredContactInfoOpSet == null) continue;
                Iterator emailAddressDetailIt = serverStoredContactInfoOpSet.getDetailsAndDescendants(contact, ServerStoredDetails.EmailAddressDetail.class);
                while (emailAddressDetailIt.hasNext()) {
                    ServerStoredDetails.EmailAddressDetail emailAddressDetail = (ServerStoredDetails.EmailAddressDetail)emailAddressDetailIt.next();
                    if (!signinName.equalsIgnoreCase(emailAddressDetail.getEMailAddress())) continue;
                    contacts.add(contact);
                    continue block1;
                }
            }
        }
        return contacts;
    }

    private static List<Contact> findContactsBySigninName(String signinName, Class<? extends OperationSet> opSetClass, int limit) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (Self self : selves.values()) {
            self.findContactsBySigninName(signinName, opSetClass, limit, contacts);
            if (contacts.size() < limit) continue;
            break;
        }
        return contacts;
    }

    private static Set<ServerStoredDetails.PhoneNumberDetail> findPhoneNumbersBySigninName(String signinName, int limit) {
        TreeSet<ServerStoredDetails.PhoneNumberDetail> phoneNumbers = new TreeSet<ServerStoredDetails.PhoneNumberDetail>(new Comparator<ServerStoredDetails.PhoneNumberDetail>(){

            @Override
            public int compare(ServerStoredDetails.PhoneNumberDetail pn1, ServerStoredDetails.PhoneNumberDetail pn2) {
                int so2;
                int so1 = Messenger.getMPHONE_TYPESortOrder(Messenger.getMPHONE_TYPE(pn1));
                return so1 == (so2 = Messenger.getMPHONE_TYPESortOrder(Messenger.getMPHONE_TYPE(pn2))) ? pn1.getNumber().compareTo(pn2.getNumber()) : so1 - so2;
            }
        });
        for (Self self : selves.values()) {
            self.findPhoneNumbersBySigninName(signinName, Integer.MAX_VALUE, phoneNumbers);
        }
        return phoneNumbers;
    }

    private static int getMPHONE_TYPE(ServerStoredDetails.PhoneNumberDetail phoneNumber) {
        if (phoneNumber.getClass().equals(ServerStoredDetails.PhoneNumberDetail.class)) {
            return 0;
        }
        if (phoneNumber instanceof ServerStoredDetails.MobilePhoneDetail) {
            return 2;
        }
        if (phoneNumber instanceof ServerStoredDetails.WorkPhoneDetail) {
            return 1;
        }
        return 3;
    }

    private static int getMPHONE_TYPESortOrder(int mphonetype) {
        for (int i = 0; i < MPHONE_TYPE_SORT_ORDER.length; ++i) {
            if (MPHONE_TYPE_SORT_ORDER[i] != mphonetype) continue;
            return i;
        }
        return MPHONE_TYPE_SORT_ORDER.length;
    }

    static String getPhoneNumber(MessengerContact messengerContact, int type) {
        Set<ServerStoredDetails.PhoneNumberDetail> phoneNumbers = Messenger.findPhoneNumbersBySigninName(messengerContact.signinName, Integer.MAX_VALUE);
        for (ServerStoredDetails.PhoneNumberDetail phoneNumber : phoneNumbers) {
            if (Messenger.getMPHONE_TYPE(phoneNumber) != type) continue;
            return phoneNumber.getNumber();
        }
        return null;
    }

    private static Self getSelf(String signinName) {
        Self self = selves.get(signinName);
        if (self == null) {
            for (Self aSelf : selves.values()) {
                if (!aSelf.isSelf(signinName)) continue;
                self = aSelf;
                break;
            }
        }
        return self;
    }

    private static String getSigninName(Contact contact, ProtocolProviderService pps) {
        String signinName;
        String address;
        String string = address = contact == null ? pps.getAccountID().getAccountAddress() : contact.getAddress();
        if (address.contains("@")) {
            String protocol = (pps == null ? contact.getProtocolProvider() : pps).getProtocolName() + ":";
            signinName = address.toLowerCase().startsWith(protocol.toLowerCase()) ? address.substring(protocol.length()) : address;
        } else {
            signinName = null;
        }
        return signinName;
    }

    static int getStatus(MessengerContact messengerContact) {
        ProtocolPresenceStatus presenceStatus;
        String signinName = messengerContact.signinName;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Got getStatus for " + signinName));
        }
        if (signinName == null) {
            presenceStatus = null;
        } else {
            Self self = Messenger.getSelf(signinName);
            if (self == null) {
                presenceStatus = null;
                for (Self aSelf : selves.values()) {
                    ProtocolPresenceStatus aPresenceStatus = aSelf.getPresenceStatus(signinName);
                    if (aPresenceStatus == null) continue;
                    if (presenceStatus == null) {
                        presenceStatus = aPresenceStatus;
                    } else if (presenceStatus.compareTo(aPresenceStatus) < 0) {
                        presenceStatus = aPresenceStatus;
                    }
                    if (presenceStatus.toInt() < 100) continue;
                    break;
                }
            } else {
                presenceStatus = self.getPresenceStatus();
            }
        }
        return ProtocolPresenceStatus.toMISTATUS(presenceStatus);
    }

    static boolean isSelf(MessengerContact messengerContact) {
        String signinName = messengerContact.signinName;
        return signinName == null ? false : Messenger.getSelf(signinName) != null;
    }

    private static native void onContactStatusChange(String var0, int var1);

    private static synchronized void removeSelf(String signinName, ProtocolProviderService pps) {
        Self self = selves.get(signinName);
        if (self != null && self.removeProtocolProviderService(pps) < 1) {
            Iterator<Self> it = selves.values().iterator();
            while (it.hasNext()) {
                if (it.next() != self) continue;
                it.remove();
            }
            self.dispose();
        }
    }

    private static void serviceChanged(ServiceEvent event) {
        String signinName;
        ProtocolProviderService pps;
        OperationSetPresence presenceOpSet;
        Object service = bundleContext.getService(event.getServiceReference());
        if (service instanceof ProtocolProviderService && (presenceOpSet = (OperationSetPresence)(pps = (ProtocolProviderService)service).getOperationSet(OperationSetPresence.class)) != null && (signinName = Messenger.getSigninName(null, pps)) != null) {
            switch (event.getType()) {
                case 1: {
                    Messenger.addSelf(signinName, pps, presenceOpSet);
                    break;
                }
                case 4: {
                    Messenger.removeSelf(signinName, pps);
                }
            }
        }
    }

    static synchronized void start(BundleContext bundleContext) throws Exception {
        Messenger.bundleContext = bundleContext;
        metaContactListService = (MetaContactListService)ServiceUtils.getService((BundleContext)bundleContext, MetaContactListService.class);
        bundleContext.addServiceListener(serviceListener);
        ServiceReference[] serviceReferences = bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        if (serviceReferences != null && serviceReferences.length != 0) {
            for (ServiceReference serviceReference : serviceReferences) {
                serviceListener.serviceChanged(new ServiceEvent(1, serviceReference));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Messenger [REGISTERED] as service listener.");
        }
    }

    static synchronized void stop(BundleContext bundleContext) throws Exception {
        bundleContext.removeServiceListener(serviceListener);
        Messenger.bundleContext = null;
        metaContactListService = null;
        Iterator<Self> it = selves.values().iterator();
        while (it.hasNext()) {
            it.next().dispose();
            it.remove();
        }
    }

    public void startConversation(final int conversationType, String[] participants, String conversationData) {
        Class<OperationSetBasicTelephony> opSetClass;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Got startConversation participants:" + participants == null ? "" : Arrays.asList(participants) + ", conversationData=" + conversationData));
        }
        switch (conversationType) {
            case 2: 
            case 8: 
            case 32: {
                opSetClass = OperationSetBasicTelephony.class;
                if (conversationData == null || conversationData.length() == 0) break;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("conversationData = \"" + conversationData + "\""));
                }
                if (conversationData.startsWith("<")) {
                    try {
                        NodeList childNodes;
                        Document document = XMLUtils.createDocument((String)conversationData);
                        Element documentElement = document.getDocumentElement();
                        if (!"TelURIs".equalsIgnoreCase(documentElement.getTagName()) || (childNodes = documentElement.getChildNodes()) == null) break;
                        int childNodeCount = childNodes.getLength();
                        ArrayList<String> phoneNumbers = new ArrayList<String>(childNodeCount);
                        for (int childNodeIndex = 0; childNodeIndex < childNodeCount; ++childNodeIndex) {
                            Node childNode = childNodes.item(childNodeIndex);
                            if (childNode.getNodeType() != 1) continue;
                            phoneNumbers.add(childNode.getTextContent());
                        }
                        int count = participants.length;
                        if (phoneNumbers.size() != count) break;
                        for (int i = 0; i < count; ++i) {
                            String phoneNumber = (String)phoneNumbers.get(i);
                            if (phoneNumber == null || phoneNumber.length() == 0) continue;
                            if (phoneNumber.toLowerCase().startsWith("tel:")) {
                                phoneNumber = phoneNumber.substring(4);
                            }
                            participants[i] = phoneNumber;
                        }
                        break;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to parse IMessengerAdvanced::StartConversation vConversationData: " + conversationData), (Throwable)e);
                        break;
                    }
                }
                if (participants.length != 1) break;
                participants[0] = conversationData;
                break;
            }
            case 1: {
                opSetClass = OperationSetBasicInstantMessaging.class;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        ArrayList<String> contactList = new ArrayList<String>();
        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        boolean createCallByPhoneNumber = cfg != null && cfg.getBoolean(PNAME_CREATE_CALL_BY_PHONE_NUMBER, false);
        for (String participant : participants) {
            List<Contact> participantContacts = Messenger.findContactsBySigninName(participant, opSetClass, 1);
            if (participantContacts.size() > 0) {
                contactList.add(Messenger.getSigninName(participantContacts.get(0), null));
                continue;
            }
            if (!opSetClass.equals(OperationSetBasicTelephony.class)) continue;
            if (createCallByPhoneNumber) {
                Set<ServerStoredDetails.PhoneNumberDetail> participantPhoneNumbers = Messenger.findPhoneNumbersBySigninName(participant, 1);
                if (participantPhoneNumbers.size() <= 0) continue;
                contactList.add(participantPhoneNumbers.iterator().next().getNumber());
                continue;
            }
            participantContacts = Messenger.findContactsBySigninName(participant, null, 1);
            if (participantContacts.size() > 0) {
                contactList.add(Messenger.getSigninName(participantContacts.get(0), null));
                continue;
            }
            contactList.add(participant);
        }
        final String[] contactArray = contactList.toArray(new String[contactList.size()]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIService uiService;
                BundleContext bundleContext = bundleContext;
                if (bundleContext != null && (uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class)) != null) {
                    switch (conversationType) {
                        case 2: 
                        case 8: 
                        case 32: {
                            uiService.createCall(contactArray);
                            break;
                        }
                        case 1: {
                            uiService.startChat(contactArray);
                        }
                    }
                }
            }
        });
    }

    static {
        MPHONE_TYPE_SORT_ORDER = new int[]{1, 0, 2, 3};
        selves = new HashMap<String, Self>();
        serviceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                Messenger.serviceChanged(event);
            }
        };
        try {
            System.loadLibrary("jmsofficecomm");
        }
        catch (Throwable t) {
            logger.error((Object)("Couldn't load jmsofficecomm. If you are debugging, make sure that HKLM\\SOFTWARE[\\Wow6432Node]\\Microsoft\\Office\\Outlook\\Call Integration\\IMApplication is set to javaw.exe; " + t.getMessage()));
            throw new RuntimeException(t);
        }
    }

    private static class Self
    implements ContactPresenceStatusListener,
    ProviderPresenceStatusListener {
        private final Map<ProtocolProviderService, OperationSetPresence> ppss = new HashMap<ProtocolProviderService, OperationSetPresence>();
        private ProtocolPresenceStatus presenceStatus;
        public final String signinName;

        public Self(String signinName) {
            this.signinName = signinName;
        }

        void addProtocolProviderService(ProtocolProviderService pps, OperationSetPresence presenceOpSet) {
            if (!this.ppss.containsKey(pps)) {
                this.ppss.put(pps, presenceOpSet);
                presenceOpSet.addContactPresenceStatusListener((ContactPresenceStatusListener)this);
                presenceOpSet.addProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
                this.providerStatusChanged(null);
            }
        }

        public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent event) {
            String signinName = Messenger.getSigninName(event.getSourceContact(), event.getSourceProvider());
            if (signinName != null) {
                String oldProtocolName = event.getSourceProvider().getProtocolName();
                PresenceStatus oldStatus = event.getOldStatus();
                Messenger.onContactStatusChange(signinName, ProtocolPresenceStatus.toMISTATUS(oldProtocolName, oldStatus));
            }
        }

        void dispose() {
            Iterator<Map.Entry<ProtocolProviderService, OperationSetPresence>> it = this.ppss.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ProtocolProviderService, OperationSetPresence> e = it.next();
                OperationSetPresence presenceOpSet = e.getValue();
                presenceOpSet.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
                presenceOpSet.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
                it.remove();
            }
        }

        void findContactsBySigninName(String signinName, Class<? extends OperationSet> opSetClass, int limit, List<Contact> contacts) {
            for (Map.Entry<ProtocolProviderService, OperationSetPresence> e : this.ppss.entrySet()) {
                ProtocolProviderService pps = e.getKey();
                OperationSetContactCapabilities contactCapabilitiesOpSet = opSetClass == null ? null : (OperationSetContactCapabilities)pps.getOperationSet(OperationSetContactCapabilities.class);
                for (Contact contact : Messenger.findContactsBySigninName(pps, e.getValue(), signinName)) {
                    if (contactCapabilitiesOpSet != null && contactCapabilitiesOpSet.getOperationSet(contact, opSetClass) == null) continue;
                    contacts.add(contact);
                    if (contacts.size() < limit) continue;
                    break;
                }
                if (contacts.size() < limit) continue;
                break;
            }
        }

        void findPhoneNumbersBySigninName(String signinName, int limit, Set<ServerStoredDetails.PhoneNumberDetail> phoneNumbers) {
            for (Map.Entry<ProtocolProviderService, OperationSetPresence> e : this.ppss.entrySet()) {
                ProtocolProviderService pps = e.getKey();
                OperationSetServerStoredContactInfo serverStoredContactInfoOpSet = (OperationSetServerStoredContactInfo)pps.getOperationSet(OperationSetServerStoredContactInfo.class);
                if (serverStoredContactInfoOpSet == null) continue;
                block1: for (Contact contact : Messenger.findContactsBySigninName(pps, e.getValue(), signinName)) {
                    Iterator iter = serverStoredContactInfoOpSet.getDetailsAndDescendants(contact, ServerStoredDetails.PhoneNumberDetail.class);
                    if (iter == null) continue;
                    while (iter.hasNext()) {
                        ServerStoredDetails.PhoneNumberDetail phoneNumber = (ServerStoredDetails.PhoneNumberDetail)iter.next();
                        if (Messenger.getMPHONE_TYPE(phoneNumber) == 3) continue;
                        phoneNumbers.add(phoneNumber);
                        if (phoneNumbers.size() < limit) continue;
                        continue block1;
                    }
                }
                if (phoneNumbers.size() < limit) continue;
                break;
            }
        }

        ProtocolPresenceStatus getPresenceStatus() {
            return this.presenceStatus;
        }

        ProtocolPresenceStatus getPresenceStatus(String signinName) {
            ProtocolPresenceStatus presenceStatus;
            if (this.signinName.equalsIgnoreCase(signinName)) {
                presenceStatus = this.getPresenceStatus();
            } else {
                presenceStatus = null;
                for (Map.Entry<ProtocolProviderService, OperationSetPresence> e : this.ppss.entrySet()) {
                    try {
                        ProtocolProviderService pps = e.getKey();
                        List contacts = Messenger.findContactsBySigninName(pps, e.getValue(), signinName);
                        String protocolName = pps.getProtocolName();
                        for (Contact contact : contacts) {
                            PresenceStatus contactPresenceStatus = contact.getPresenceStatus();
                            if (contactPresenceStatus == null) continue;
                            if (presenceStatus == null) {
                                presenceStatus = new ProtocolPresenceStatus(protocolName, contactPresenceStatus);
                            } else if (presenceStatus.compareTo(contactPresenceStatus) < 0) {
                                presenceStatus.setPresenceStatus(protocolName, contactPresenceStatus);
                            }
                            if (presenceStatus.toInt() < 100) continue;
                            break;
                        }
                        if (presenceStatus == null || presenceStatus.toInt() < 100) continue;
                        break;
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        t.printStackTrace(System.err);
                    }
                }
            }
            return presenceStatus;
        }

        boolean isSelf(String signinName) {
            boolean self;
            if (this.signinName.equalsIgnoreCase(signinName)) {
                self = true;
            } else {
                self = false;
                for (ProtocolProviderService pps : this.ppss.keySet()) {
                    OperationSetServerStoredAccountInfo serverStoredAccountInfoOpSet;
                    if (!pps.isRegistered() || (serverStoredAccountInfoOpSet = (OperationSetServerStoredAccountInfo)pps.getOperationSet(OperationSetServerStoredAccountInfo.class)) == null) continue;
                    Iterator emailAddressDetailIt = serverStoredAccountInfoOpSet.getDetailsAndDescendants(ServerStoredDetails.EmailAddressDetail.class);
                    while (emailAddressDetailIt.hasNext()) {
                        ServerStoredDetails.EmailAddressDetail emailAddressDetail = (ServerStoredDetails.EmailAddressDetail)emailAddressDetailIt.next();
                        if (!signinName.equalsIgnoreCase(emailAddressDetail.getEMailAddress())) continue;
                        self = true;
                        break;
                    }
                    if (!self) continue;
                    break;
                }
            }
            return self;
        }

        public void providerStatusChanged(ProviderPresenceStatusChangeEvent event) {
            ProtocolPresenceStatus protocolPresenceStatus = null;
            for (Map.Entry<ProtocolProviderService, OperationSetPresence> e : this.ppss.entrySet()) {
                OperationSetPresence presenceOpSet = e.getValue();
                PresenceStatus presenceOpSetStatus = presenceOpSet.getPresenceStatus();
                if (presenceOpSetStatus == null) continue;
                if (protocolPresenceStatus == null) {
                    protocolPresenceStatus = new ProtocolPresenceStatus(e.getKey().getProtocolName(), presenceOpSetStatus);
                } else if (protocolPresenceStatus.compareTo(presenceOpSetStatus) < 0) {
                    protocolPresenceStatus.setPresenceStatus(e.getKey().getProtocolName(), presenceOpSetStatus);
                }
                if (protocolPresenceStatus.toInt() < 100) continue;
                break;
            }
            this.setPresenceStatus(protocolPresenceStatus);
        }

        public void providerStatusMessageChanged(PropertyChangeEvent event) {
        }

        int removeProtocolProviderService(ProtocolProviderService pps) {
            OperationSetPresence presenceOpSet = this.ppss.get(pps);
            if (presenceOpSet != null) {
                presenceOpSet.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
                presenceOpSet.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
                this.ppss.remove(pps);
                this.providerStatusChanged(null);
            }
            return this.ppss.size();
        }

        private void setPresenceStatus(ProtocolPresenceStatus presenceStatus) {
            int newMISTATUS;
            int oldMISTATUS = ProtocolPresenceStatus.toMISTATUS(this.presenceStatus);
            if (oldMISTATUS != (newMISTATUS = ProtocolPresenceStatus.toMISTATUS(presenceStatus))) {
                this.presenceStatus = presenceStatus;
                Messenger.onContactStatusChange(this.signinName, oldMISTATUS);
            }
        }
    }

    private static class ProtocolPresenceStatus {
        private PresenceStatus presenceStatus;
        private String protocolName;

        public ProtocolPresenceStatus(String protocolName, PresenceStatus presenceStatus) {
            this.setPresenceStatus(protocolName, presenceStatus);
        }

        public int compareTo(PresenceStatus presenceStatus) {
            return this.presenceStatus.compareTo(presenceStatus);
        }

        public int compareTo(ProtocolPresenceStatus protocolPresenceStatus) {
            return this.compareTo(protocolPresenceStatus.presenceStatus);
        }

        public void setPresenceStatus(String protocolName, PresenceStatus presenceStatus) {
            this.protocolName = protocolName;
            this.presenceStatus = presenceStatus;
        }

        public int toInt() {
            return this.presenceStatus.getStatus();
        }

        public int toMISTATUS() {
            return ProtocolPresenceStatus.toMISTATUS(this.protocolName, this.presenceStatus);
        }

        public static int toMISTATUS(ProtocolPresenceStatus protocolPresenceStatus) {
            return protocolPresenceStatus == null ? 0 : protocolPresenceStatus.toMISTATUS();
        }

        public static int toMISTATUS(String protocolName, PresenceStatus presenceStatus) {
            int i;
            int n = i = presenceStatus == null ? Integer.MIN_VALUE : presenceStatus.getStatus();
            int mistatus = i == Integer.MIN_VALUE ? 0 : (i == 31 && "Jabber".equalsIgnoreCase(protocolName) && "On the phone".equalsIgnoreCase(presenceStatus.getStatusName()) ? 50 : (i == 32 && "Jabber".equalsIgnoreCase(protocolName) && "In a meeting".equalsIgnoreCase(presenceStatus.getStatusName()) ? 82 : (i < 20 ? 1 : (i < 36 ? 162 : (i < 50 ? 34 : 2)))));
            return mistatus;
        }
    }
}

