/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.bliptv;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ReplacementServiceBliptvImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceBliptvImpl.class);
    public static final String BLIPTV_PATTERN = "(http:\\/\\/(?:www\\.)?blip\\.tv\\/.*)";
    public static final String BLIPTV_CONFIG_LABEL = "Blip.tv";
    public static final String SOURCE_NAME = "BLIPTV";

    public ReplacementServiceBliptvImpl() {
        logger.trace((Object)"Creating a Blip.TV Source.");
    }

    public String getReplacement(String sourceString) {
        try {
            String inputLine;
            String url = "http://api.embed.ly/1/oembed?url=" + sourceString + "&key=cff57b37766440a6a8aa45df88097efe";
            URL sourceURL = new URL(url);
            URLConnection conn = sourceURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String holder = "";
            while ((inputLine = in.readLine()) != null) {
                holder = holder + inputLine;
            }
            in.close();
            JSONObject wrapper = (JSONObject)JSONValue.parseWithException((String)holder);
            String thumbUrl = (String)wrapper.get((Object)"thumbnail_url");
            if (thumbUrl != null) {
                return thumbUrl;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Error parsing", e);
        }
        return sourceString;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return BLIPTV_PATTERN;
    }
}

