/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.util.collections.AbstractMapEntry;

public class Cache<K, V>
implements Map<K, V> {
    protected Map<K, CacheObject<V>> map;
    protected LinkedList lastAccessedList;
    protected LinkedList ageList;
    protected int maxCacheSize;
    protected long maxLifetime;
    protected long cacheHits;
    protected long cacheMisses = 0L;

    public Cache(int maxSize, long maxLifetime) {
        if (maxSize == 0) {
            throw new IllegalArgumentException("Max cache size cannot be 0.");
        }
        this.maxCacheSize = maxSize;
        this.maxLifetime = maxLifetime;
        this.map = new HashMap<K, CacheObject<V>>(103);
        this.lastAccessedList = new LinkedList();
        this.ageList = new LinkedList();
    }

    @Override
    public synchronized V put(K key, V value) {
        V oldValue = null;
        if (this.map.containsKey(key)) {
            oldValue = this.remove(key, true);
        }
        CacheObject<V> cacheObject = new CacheObject<V>(value);
        this.map.put(key, cacheObject);
        cacheObject.lastAccessedListNode = this.lastAccessedList.addFirst(key);
        LinkedListNode ageNode = this.ageList.addFirst(key);
        ageNode.timestamp = System.currentTimeMillis();
        cacheObject.ageListNode = ageNode;
        this.cullCache();
        return oldValue;
    }

    @Override
    public synchronized V get(Object key) {
        this.deleteExpiredEntries();
        CacheObject<V> cacheObject = this.map.get(key);
        if (cacheObject == null) {
            ++this.cacheMisses;
            return null;
        }
        cacheObject.lastAccessedListNode.remove();
        this.lastAccessedList.addFirst(cacheObject.lastAccessedListNode);
        ++this.cacheHits;
        ++cacheObject.readCount;
        return cacheObject.object;
    }

    @Override
    public synchronized V remove(Object key) {
        return this.remove(key, false);
    }

    public synchronized V remove(Object key, boolean internal) {
        CacheObject<V> cacheObject = this.map.remove(key);
        if (cacheObject == null) {
            return null;
        }
        cacheObject.lastAccessedListNode.remove();
        cacheObject.ageListNode.remove();
        cacheObject.ageListNode = null;
        cacheObject.lastAccessedListNode = null;
        return cacheObject.object;
    }

    @Override
    public synchronized void clear() {
        Object[] keys;
        for (Object key : keys = this.map.keySet().toArray()) {
            this.remove(key);
        }
        this.map.clear();
        this.lastAccessedList.clear();
        this.ageList.clear();
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
    }

    @Override
    public synchronized int size() {
        this.deleteExpiredEntries();
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        this.deleteExpiredEntries();
        return this.map.isEmpty();
    }

    @Override
    public synchronized Collection<V> values() {
        this.deleteExpiredEntries();
        return Collections.unmodifiableCollection(new AbstractCollection<V>(){
            Collection<CacheObject<V>> values;
            {
                this.values = Cache.this.map.values();
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<CacheObject<V>> it;
                    {
                        this.it = values.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.it.next().object;
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.values.size();
            }
        });
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        this.deleteExpiredEntries();
        return this.map.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value = entry.getValue();
            if (value instanceof CacheObject) {
                value = ((CacheObject)value).object;
            }
            this.put(entry.getKey(), value);
        }
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        this.deleteExpiredEntries();
        CacheObject<Object> cacheObject = new CacheObject<Object>(value);
        return this.map.containsValue(cacheObject);
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        this.deleteExpiredEntries();
        return new AbstractSet<Map.Entry<K, V>>(){
            private final Set<Map.Entry<K, CacheObject<V>>> set;
            {
                this.set = Cache.this.map.entrySet();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, CacheObject<V>>> it;
                    {
                        this.it = set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Map.Entry entry = this.it.next();
                        return new AbstractMapEntry<K, V>(entry.getKey(), entry.getValue().object){

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException("Cannot set");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.set.size();
            }
        };
    }

    @Override
    public synchronized Set<K> keySet() {
        this.deleteExpiredEntries();
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public synchronized void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.cullCache();
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    protected synchronized void deleteExpiredEntries() {
        if (this.maxLifetime <= 0L) {
            return;
        }
        LinkedListNode node = this.ageList.getLast();
        if (node == null) {
            return;
        }
        long expireTime = System.currentTimeMillis() - this.maxLifetime;
        while (expireTime > node.timestamp) {
            if (this.remove(node.object, true) == null) {
                System.err.println("Error attempting to remove(" + node.object.toString() + ") - cacheObject not found in cache!");
                node.remove();
            }
            if ((node = this.ageList.getLast()) != null) continue;
            return;
        }
    }

    protected synchronized void cullCache() {
        if (this.maxCacheSize < 0) {
            return;
        }
        if (this.map.size() > this.maxCacheSize) {
            this.deleteExpiredEntries();
            int desiredSize = (int)((double)this.maxCacheSize * 0.9);
            for (int i = this.map.size(); i > desiredSize; --i) {
                if (this.remove(this.lastAccessedList.getLast().object, true) != null) continue;
                System.err.println("Error attempting to cullCache with remove(" + this.lastAccessedList.getLast().object.toString() + ") - " + "cacheObject not found in cache!");
                this.lastAccessedList.getLast().remove();
            }
        }
    }

    private static class LinkedListNode {
        public LinkedListNode previous;
        public LinkedListNode next;
        public Object object;
        public long timestamp;

        public LinkedListNode(Object object, LinkedListNode next, LinkedListNode previous) {
            this.object = object;
            this.next = next;
            this.previous = previous;
        }

        public void remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
        }

        public String toString() {
            return this.object.toString();
        }
    }

    private static class LinkedList {
        private LinkedListNode head;

        public LinkedList() {
            this.head.next = this.head.previous = (this.head = new LinkedListNode("head", null, null));
        }

        public LinkedListNode getFirst() {
            LinkedListNode node = this.head.next;
            if (node == this.head) {
                return null;
            }
            return node;
        }

        public LinkedListNode getLast() {
            LinkedListNode node = this.head.previous;
            if (node == this.head) {
                return null;
            }
            return node;
        }

        public LinkedListNode addFirst(LinkedListNode node) {
            node.next = this.head.next;
            node.previous = this.head;
            node.previous.next = node;
            node.next.previous = node;
            return node;
        }

        public LinkedListNode addFirst(Object object) {
            LinkedListNode node;
            node.previous.next = node = new LinkedListNode(object, this.head.next, this.head);
            node.next.previous = node;
            return node;
        }

        public LinkedListNode addLast(Object object) {
            LinkedListNode node;
            node.previous.next = node = new LinkedListNode(object, this.head, this.head.previous);
            node.next.previous = node;
            return node;
        }

        public void clear() {
            LinkedListNode node = this.getLast();
            while (node != null) {
                node.remove();
                node = this.getLast();
            }
            this.head.next = this.head.previous = this.head;
        }

        public String toString() {
            LinkedListNode node = this.head.next;
            StringBuilder buf = new StringBuilder();
            while (node != this.head) {
                buf.append(node.toString()).append(", ");
                node = node.next;
            }
            return buf.toString();
        }
    }

    private static class CacheObject<V> {
        public V object;
        public LinkedListNode lastAccessedListNode;
        public LinkedListNode ageListNode;
        public int readCount = 0;

        public CacheObject(V object) {
            this.object = object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheObject)) {
                return false;
            }
            CacheObject cacheObject = (CacheObject)o;
            return this.object.equals(cacheObject.object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }
}

