/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.Result;
import net.java.sip.communicator.util.Logger;

public class ServerChannelLister {
    private static final Logger LOGGER = Logger.getLogger(ServerChannelLister.class);
    private static final long CACHE_CLEAN_UP_DELAY = 1000L;
    private static final long RATIO_MILLISECONDS_TO_NANOSECONDS = 1000000L;
    private static final long CHAT_ROOM_LIST_CACHE_EXPIRATION = 60000000000L;
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final Container<List<String>> channellist = new Container(null);

    public ServerChannelLister(IRCApi irc, IIRCState connectionState) {
        if (irc == null) {
            throw new IllegalArgumentException("irc instance cannot be null");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState instance cannot be null");
        }
        this.connectionState = connectionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getList() {
        LOGGER.trace((Object)"Start retrieve server chat room list.");
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to an IRC server.");
        }
        Container<List<String>> container = this.channellist;
        synchronized (container) {
            List list = this.channellist.get(60000000000L);
            if (list == null) {
                Result listSignal;
                LOGGER.trace((Object)"Chat room list null or outdated. Start retrieving new chat room list.");
                Result result = listSignal = new Result(new LinkedList());
                synchronized (result) {
                    try {
                        this.irc.addListener((IMessageListener)new ChannelListListener(listSignal));
                        this.irc.rawMessage("LIST");
                        while (!listSignal.isDone()) {
                            LOGGER.trace((Object)"Waiting for list ...");
                            listSignal.wait();
                        }
                        LOGGER.trace((Object)"Done waiting for list.");
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn((Object)"INTERRUPTED while waiting for list.", (Throwable)e);
                    }
                }
                list = listSignal.getValue();
                this.channellist.set(list);
                LOGGER.trace((Object)"Finished retrieving server chat room list.");
                ServerChannelLister.createCleanUpJob(this.channellist);
            } else {
                LOGGER.trace((Object)"Using cached list of server chat rooms.");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Server channel list contains " + list.size() + " channels."));
            }
            return Collections.unmodifiableList(list);
        }
    }

    private static void createCleanUpJob(Container<List<String>> channellist) {
        Timer cleanUpJob = new Timer();
        long timestamp = channellist.getTimestamp();
        cleanUpJob.schedule((TimerTask)new ChannelListCacheCleanUpTask(channellist, timestamp), 61000L);
    }

    private static final class Container<T> {
        private T instance;
        private long time;

        private Container(T instance) {
            this.instance = instance;
            this.time = System.nanoTime();
        }

        public T get(long bound) {
            if (System.nanoTime() - this.time > bound) {
                return null;
            }
            return this.instance;
        }

        public void set(T instance) {
            this.instance = instance;
            this.time = System.nanoTime();
        }

        public long getTimestamp() {
            return this.time;
        }
    }

    private final class ChannelListListener
    extends AbstractIrcMessageListener {
        private static final int RPL_LISTSTART = 321;
        private static final int RPL_LIST = 322;
        private static final int RPL_LISTEND = 323;
        private final Result<List<String>, Exception> signal;

        private ChannelListListener(Result<List<String>, Exception> signal) {
            super(ServerChannelLister.this.irc, ServerChannelLister.this.connectionState);
            this.signal = signal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServerNumericMessage(ServerNumericMessage msg) {
            if (this.signal.isDone()) {
                return;
            }
            switch (msg.getNumericCode()) {
                case 321: {
                    Result<List<String>, Exception> result = this.signal;
                    synchronized (result) {
                        this.signal.getValue().clear();
                        break;
                    }
                }
                case 322: {
                    String channel = this.parse(msg.getText());
                    if (channel == null) break;
                    Result<List<String>, Exception> result = this.signal;
                    synchronized (result) {
                        this.signal.getValue().add(channel);
                        break;
                    }
                }
                case 323: {
                    Result<List<String>, Exception> result = this.signal;
                    synchronized (result) {
                        ServerChannelLister.this.irc.deleteListener((IMessageListener)this);
                        this.signal.setDone();
                        this.signal.notifyAll();
                        break;
                    }
                }
            }
        }

        private String parse(String text) {
            int endOfChannelName = text.indexOf(32);
            if (endOfChannelName == -1) {
                return null;
            }
            return new String(text.substring(0, endOfChannelName));
        }
    }

    private static final class ChannelListCacheCleanUpTask
    extends TimerTask {
        private final long timestamp;
        private final Container<List<String>> container;

        private ChannelListCacheCleanUpTask(Container<List<String>> listContainer, long timestamp) {
            if (listContainer == null) {
                throw new IllegalArgumentException("listContainer cannot be null");
            }
            this.container = listContainer;
            this.timestamp = timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Container<List<String>> container = this.container;
            synchronized (container) {
                if (this.container.getTimestamp() != this.timestamp) {
                    LOGGER.trace((Object)"Not cleaning up channel list cache. The timestamp does not match.");
                    return;
                }
                this.container.set(null);
            }
            LOGGER.debug((Object)"Old channel list cache has been cleared.");
        }
    }
}

