/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.launcher;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import net.java.sip.communicator.launcher.ChangeJVMFrame;
import net.java.sip.communicator.util.ScStdOut;
import net.java.sip.communicator.util.launchutils.LaunchArgHandler;
import net.java.sip.communicator.util.launchutils.SipCommunicatorLock;
import org.apache.felix.main.Main;

public class SIPCommunicator {
    private static final String[] LEGACY_DIR_NAMES = new String[]{".sip-communicator", "SIP Communicator"};
    public static final String PNAME_SC_CACHE_DIR_LOCATION = "net.java.sip.communicator.SC_CACHE_DIR_LOCATION";
    public static final String PNAME_SC_LOG_DIR_LOCATION = "net.java.sip.communicator.SC_LOG_DIR_LOCATION";
    private static final String[] LEGACY_CONFIGURATION_FILE_NAMES = new String[]{"sip-communicator.properties", "jitsi.properties", "sip-communicator.xml", "jitsi.xml"};
    private static final String OVERRIDABLE_DIR_NAME = "Jitsi";
    public static final String PNAME_SC_HOME_DIR_LOCATION = "net.java.sip.communicator.SC_HOME_DIR_LOCATION";
    public static final String PNAME_SC_HOME_DIR_NAME = "net.java.sip.communicator.SC_HOME_DIR_NAME";

    public static void main(String[] args) throws Exception {
        String version = System.getProperty("java.version");
        String vmVendor = System.getProperty("java.vendor");
        String osName = System.getProperty("os.name");
        SIPCommunicator.setSystemProperties(osName);
        SIPCommunicator.setScHomeDir(osName);
        File f = new File(System.getProperty(PNAME_SC_HOME_DIR_LOCATION), System.getProperty(PNAME_SC_HOME_DIR_NAME) + File.separator + ".usednsjava");
        if (f.exists()) {
            System.setProperty("sun.net.spi.nameservice.provider.1", "dns,jitsi");
        }
        if (version.startsWith("1.5") || vmVendor.startsWith("Gnu") || vmVendor.startsWith("Free")) {
            String os = "";
            if (osName.startsWith("Mac")) {
                os = "MacOSX";
            } else if (osName.startsWith("Linux")) {
                os = "Linux";
            } else if (osName.startsWith("Windows")) {
                os = "Windows";
            }
            ChangeJVMFrame changeJVMFrame = new ChangeJVMFrame(os);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            changeJVMFrame.setLocation(screenSize.width / 2 - changeJVMFrame.getWidth() / 2, screenSize.height / 2 - changeJVMFrame.getHeight() / 2);
            changeJVMFrame.setVisible(true);
            return;
        }
        LaunchArgHandler argHandler = LaunchArgHandler.getInstance();
        int argHandlerRes = argHandler.handleArgs(args);
        if (argHandlerRes == 0 || argHandlerRes == 2) {
            System.exit(argHandler.getErrorCode());
        }
        if (argHandlerRes != 3) {
            switch (new SipCommunicatorLock().tryLock(args)) {
                case 300: {
                    System.err.println("Failed to lock Jitsi's configuration directory.\nTry launching with the --multiple param.");
                    System.exit(300);
                    break;
                }
                case 301: {
                    System.out.println("Jitsi is already running and will handle your parameters (if any).\nLaunch with the --multiple param to override this behaviour.");
                    System.exit(0);
                    break;
                }
            }
        }
        String currentVersion = "2.10";
        File jitsiVersion = new File(new File(System.getProperty(PNAME_SC_CACHE_DIR_LOCATION), System.getProperty(PNAME_SC_HOME_DIR_NAME)), ".lastversion");
        if (jitsiVersion.exists()) {
            File felixCache;
            BufferedReader r = new BufferedReader(new FileReader(jitsiVersion));
            String lastVersion = r.readLine();
            r.close();
            if (!currentVersion.equals(lastVersion) && (felixCache = new File(new File(System.getProperty(PNAME_SC_CACHE_DIR_LOCATION), System.getProperty(PNAME_SC_HOME_DIR_NAME)), "sip-communicator.bin")).exists()) {
                SIPCommunicator.deleteRecursive(felixCache);
            }
        }
        FileWriter fw = new FileWriter(jitsiVersion);
        fw.write(currentVersion);
        fw.close();
        System.setOut((PrintStream)new ScStdOut(System.out));
        Main.main((String[])new String[0]);
    }

    private static void deleteRecursive(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                SIPCommunicator.deleteRecursive(c);
            }
        }
        f.delete();
    }

    static void setScHomeDir(String osName) {
        boolean isHomeDirnameForced;
        String profileLocation = System.getProperty(PNAME_SC_HOME_DIR_LOCATION);
        String cacheLocation = System.getProperty(PNAME_SC_CACHE_DIR_LOCATION);
        String logLocation = System.getProperty(PNAME_SC_LOG_DIR_LOCATION);
        String name = System.getProperty(PNAME_SC_HOME_DIR_NAME);
        boolean bl = isHomeDirnameForced = name != null;
        if (profileLocation == null || cacheLocation == null || logLocation == null || name == null) {
            boolean chekLegacyDirNames;
            String defaultLocation = System.getProperty("user.home");
            String defaultName = ".jitsi";
            boolean bl2 = chekLegacyDirNames = name == null || name.equals(OVERRIDABLE_DIR_NAME);
            if (osName.startsWith("Mac")) {
                if (profileLocation == null) {
                    profileLocation = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support";
                }
                if (cacheLocation == null) {
                    cacheLocation = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Caches";
                }
                if (logLocation == null) {
                    logLocation = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Logs";
                }
                if (name == null) {
                    name = OVERRIDABLE_DIR_NAME;
                }
            } else if (osName.startsWith("Windows")) {
                if (profileLocation == null) {
                    profileLocation = System.getenv("APPDATA");
                }
                if (cacheLocation == null) {
                    cacheLocation = System.getenv("LOCALAPPDATA");
                }
                if (logLocation == null) {
                    logLocation = System.getenv("LOCALAPPDATA");
                }
                if (name == null) {
                    name = OVERRIDABLE_DIR_NAME;
                }
            }
            if (profileLocation == null) {
                profileLocation = defaultLocation;
            }
            if (cacheLocation == null) {
                cacheLocation = profileLocation;
            }
            if (logLocation == null) {
                logLocation = profileLocation;
            }
            if (name == null) {
                name = defaultName;
            }
            if (!isHomeDirnameForced && !new File(profileLocation, name).isDirectory() && new File(defaultLocation, defaultName).isDirectory()) {
                profileLocation = defaultLocation;
                name = defaultName;
            }
            if (chekLegacyDirNames && !SIPCommunicator.checkHomeFolderExist(profileLocation, name, osName)) {
                for (int i = 0; i < LEGACY_DIR_NAMES.length; ++i) {
                    String dir = LEGACY_DIR_NAMES[i];
                    if (SIPCommunicator.checkHomeFolderExist(profileLocation, dir, osName)) {
                        name = dir;
                        break;
                    }
                    if (!SIPCommunicator.checkHomeFolderExist(defaultLocation, dir, osName)) continue;
                    name = dir;
                    profileLocation = defaultLocation;
                    break;
                }
            }
            System.setProperty(PNAME_SC_HOME_DIR_LOCATION, profileLocation);
            System.setProperty(PNAME_SC_CACHE_DIR_LOCATION, cacheLocation);
            System.setProperty(PNAME_SC_LOG_DIR_LOCATION, logLocation);
            System.setProperty(PNAME_SC_HOME_DIR_NAME, name);
        }
        new File(new File(logLocation, name), "log").mkdirs();
    }

    static boolean checkHomeFolderExist(String parent, String name, String osName) {
        if (osName.startsWith("Mac")) {
            for (int i = 0; i < LEGACY_CONFIGURATION_FILE_NAMES.length; ++i) {
                String f = LEGACY_CONFIGURATION_FILE_NAMES[i];
                if (!new File(new File(parent, name), f).exists()) continue;
                return true;
            }
            return false;
        }
        return new File(parent, name).isDirectory();
    }

    private static void setSystemProperties(String osName) {
        if (osName.startsWith("Windows")) {
            System.setProperty("sun.java2d.d3d", "false");
        } else if (osName.startsWith("Mac")) {
            System.setProperty("apple.awt.fullscreencapturealldisplays", "false");
        }
    }
}

