/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.carbon;

import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.carbon.ForwardedPacketExtension;
import org.jivesoftware.smack.packet.PacketExtension;
import org.xmlpull.v1.XmlPullParser;

public class CarbonPacketExtension
extends AbstractPacketExtension {
    public static final String NAMESPACE = "urn:xmpp:carbons:2";
    public static final String RECEIVED_ELEMENT_NAME = "received";
    public static final String SENT_ELEMENT_NAME = "sent";
    public static final String PRIVATE_ELEMENT_NAME = "private";

    public CarbonPacketExtension(String elementName) {
        super(NAMESPACE, elementName);
    }

    public static class PrivateExtension
    extends AbstractPacketExtension {
        public PrivateExtension() {
            super(CarbonPacketExtension.NAMESPACE, CarbonPacketExtension.PRIVATE_ELEMENT_NAME);
        }
    }

    public static class Provider
    extends ForwardedPacketExtension.Provider {
        private String elementName;

        public Provider(String elementName) {
            this.elementName = elementName;
        }

        @Override
        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            CarbonPacketExtension packetExtension = new CarbonPacketExtension(this.elementName);
            boolean done = false;
            ForwardedPacketExtension extension = null;
            while (!done) {
                switch (parser.next()) {
                    case 2: {
                        String elementName = parser.getName();
                        if (!"forwarded".equals(elementName) || (extension = (ForwardedPacketExtension)super.parseExtension(parser)) == null) break;
                        packetExtension.addChildExtension(extension);
                        break;
                    }
                    case 3: {
                        String elementName = parser.getName();
                        if (!this.elementName.equals(elementName)) break;
                        done = true;
                    }
                }
            }
            return packetExtension;
        }
    }
}

