/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.keybindingchooser.KeybindingChooserActivator;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingAdaptor;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingEntry;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingPanel;
import net.java.sip.communicator.service.keybindings.KeybindingSet;

public class BindingChooser
extends BindingPanel {
    private static final long serialVersionUID = 0L;
    private IndentStyle indentStyle = IndentStyle.INDEX;
    private boolean isShortcutEditable = true;
    private BindingEntry selectedEntry = null;
    private KeybindingSet set = null;

    public void putAllBindings(KeybindingSet set) {
        this.set = set;
        this.putAllBindings(set.getBindings());
    }

    public static LinkedHashMap<KeyStroke, String> showDialog(Component parent, final BindingChooser display, String dialogTitle, boolean showLabels, BindingAdaptor adaptor) {
        final JDialog dialog = new JDialog();
        dialog.setTitle(dialogTitle);
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(false);
        if (showLabels) {
            dialog.add((Component)((Object)display.makeLabels()), "North");
        }
        dialog.add((Component)((Object)display));
        TransparentPanel controlSection = new TransparentPanel((LayoutManager)new GridLayout(1, 0));
        String PRESSED_STATE = "pressed";
        final JButton okButton = new JButton("OK");
        okButton.setName("not pressed");
        okButton.setPreferredSize(new Dimension(okButton.getPreferredSize().width, 25));
        okButton.setFocusable(false);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                okButton.setName("pressed");
                dialog.dispose();
            }
        });
        controlSection.add(okButton);
        final JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(cancelButton.getPreferredSize().width, 25));
        cancelButton.setFocusable(false);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        });
        controlSection.add(cancelButton);
        dialog.add((Component)controlSection, "South");
        dialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (display.selectedEntry == null) {
                    if (event.getKeyCode() == 10) {
                        okButton.doClick();
                    } else if (event.getKeyCode() == 27) {
                        cancelButton.doClick();
                    }
                }
            }
        });
        dialog.addKeyListener(adaptor);
        dialog.pack();
        dialog.setVisible(true);
        if (okButton.getName().equals("pressed")) {
            return display.getBindingMap();
        }
        return null;
    }

    @Override
    protected void onUpdate(int index, BindingEntry entry, boolean isNew) {
        this.indentStyle.apply(entry, index);
    }

    @Override
    protected void onClick(MouseEvent event, BindingEntry entry, BindingEntry.Field field) {
        if (field == BindingEntry.Field.SHORTCUT) {
            if (entry.equals((Object)this.selectedEntry)) {
                this.setSelected(null);
            } else {
                this.setSelected(entry);
            }
        }
    }

    public void setEditable(boolean editable) {
        if (!editable && this.selectedEntry != null) {
            this.setSelected(null);
        }
        this.isShortcutEditable = editable;
    }

    public IndentStyle getIndentStyle() {
        return this.indentStyle;
    }

    public void setIndentStyle(IndentStyle style) {
        this.indentStyle = style;
        if (style == IndentStyle.NONE) {
            return;
        }
        ArrayList<BindingEntry> bindings = this.getBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            this.onUpdate(i, bindings.get(i), false);
        }
    }

    public boolean isBindingSelected() {
        return this.selectedEntry != null;
    }

    public BindingEntry getSelected() {
        return this.selectedEntry;
    }

    public void setSelected(BindingEntry entry) {
        if (!this.isShortcutEditable) {
            return;
        }
        if (entry != null && entry.equals((Object)this.selectedEntry)) {
            return;
        }
        if (entry != null && !this.getBindings().contains((Object)entry)) {
            throw new IllegalArgumentException("BindingEntry not contained in display.");
        }
        BindingEntry previousSelection = this.selectedEntry;
        this.selectedEntry = entry;
        if (previousSelection != null) {
            this.onUpdate(this.getBindingIndex(previousSelection), previousSelection, false);
            previousSelection.setShortcut(previousSelection.getShortcut());
        }
        if (this.selectedEntry != null) {
            this.onUpdate(this.getBindingIndex(this.selectedEntry), this.selectedEntry, false);
            this.selectedEntry.getField(BindingEntry.Field.SHORTCUT).setText(KeybindingChooserActivator.getResources().getI18NString("plugin.keybindings.WAITING"));
        }
    }

    public BindingAdaptor makeAdaptor() {
        return new BindingAdaptor(this);
    }

    public BindingEntry makeLabels() {
        BindingEntry labels = new BindingEntry(null, "");
        labels.setOpaque(false);
        for (BindingEntry.Field field : BindingEntry.Field.values()) {
            JLabel fieldLabel = labels.getField(field);
            if (field == BindingEntry.Field.INDENT) {
                fieldLabel.setVisible(this.indentStyle != IndentStyle.EMPTY);
                continue;
            }
            if (field == BindingEntry.Field.ACTION) {
                fieldLabel.setText(" Action:");
                continue;
            }
            if (field == BindingEntry.Field.SHORTCUT) {
                fieldLabel.setText(" Shortcut:");
                continue;
            }
            assert (false) : BindingChooser.class.getName() + " doesn't recognize the '" + (Object)((Object)field) + "' field.";
        }
        return labels;
    }

    void doInput(KeyStroke input) {
        if (this.isBindingSelected()) {
            this.selectedEntry.setShortcut(input);
            this.set.setBindings(this.getBindingMap());
            this.setSelected(null);
        }
    }

    public void validate() {
        super.validate();
        ArrayList<BindingEntry> bindings = this.getBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            this.onUpdate(i, bindings.get(i), false);
        }
    }

    public static String getReadableConstant(String input) {
        char[] name = input.toCharArray();
        boolean isStartOfWord = true;
        for (int i = 0; i < name.length; ++i) {
            char chr = name[i];
            name[i] = chr == '_' ? 32 : (isStartOfWord ? Character.toUpperCase(chr) : Character.toLowerCase(chr));
            isStartOfWord = chr == '_';
        }
        return new String(name);
    }

    public static final class IndentStyle
    extends Enum<IndentStyle> {
        public static final /* enum */ IndentStyle NONE = new IndentStyle();
        public static final /* enum */ IndentStyle EMPTY = new IndentStyle();
        public static final /* enum */ IndentStyle SPACER = new IndentStyle();
        public static final /* enum */ IndentStyle TYPE = new IndentStyle();
        public static final /* enum */ IndentStyle INDEX = new IndentStyle();
        private static final /* synthetic */ IndentStyle[] $VALUES;

        public static IndentStyle[] values() {
            return (IndentStyle[])$VALUES.clone();
        }

        public static IndentStyle valueOf(String name) {
            return Enum.valueOf(IndentStyle.class, name);
        }

        public static IndentStyle fromString(String str) {
            for (IndentStyle type : IndentStyle.values()) {
                if (!str.equals(type.toString())) continue;
                return type;
            }
            throw new IllegalArgumentException();
        }

        private void apply(BindingEntry entry, int index) {
            if (this == NONE) {
                return;
            }
            JLabel indentField = entry.getField(BindingEntry.Field.INDENT);
            indentField.setVisible(this != EMPTY);
            indentField.setIcon(null);
            String fieldText = "";
            if (this == TYPE) {
                if (entry.getShortcut() == BindingEntry.DISABLED) {
                    fieldText = "  X";
                } else {
                    int type = entry.getShortcut().getKeyEventType();
                    if (type == 401) {
                        fieldText = "  \u2193";
                    } else if (type == 402) {
                        fieldText = "  \u2191";
                    } else if (type == 400) {
                        fieldText = "  \u2195";
                    } else {
                        assert (false) : "Unrecognized key type: " + type;
                        fieldText = "";
                    }
                }
            } else if (this == INDEX) {
                fieldText = " " + (index + 1) + ".";
            }
            indentField.setText(fieldText);
        }

        public String toString() {
            if (this == TYPE) {
                return "Event Type";
            }
            return BindingChooser.getReadableConstant(this.name());
        }

        static {
            $VALUES = new IndentStyle[]{NONE, EMPTY, SPACER, TYPE, INDEX};
        }
    }
}

