/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;

public class RoomInvitation
implements PacketExtension {
    public static final String ELEMENT_NAME = "invite";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private Type type;
    private String invitee;
    private String inviter;
    private String sessionID;
    private String room;
    private String reason;

    public RoomInvitation(Type type, String invitee, String sessionID, String reason) {
        this.type = type;
        this.invitee = invitee;
        this.sessionID = sessionID;
        this.reason = reason;
    }

    private RoomInvitation() {
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public String getInviter() {
        return this.inviter;
    }

    public String getRoom() {
        return this.room;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE);
        buf.append("\" type=\"").append((Object)this.type).append("\">");
        buf.append("<session xmlns=\"http://jivesoftware.com/protocol/workgroup\" id=\"").append(this.sessionID).append("\"></session>");
        if (this.invitee != null) {
            buf.append("<invitee>").append(this.invitee).append("</invitee>");
        }
        if (this.inviter != null) {
            buf.append("<inviter>").append(this.inviter).append("</inviter>");
        }
        if (this.reason != null) {
            buf.append("<reason>").append(this.reason).append("</reason>");
        }
        buf.append("</").append(ELEMENT_NAME).append("> ");
        return buf.toString();
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            RoomInvitation invitation = new RoomInvitation();
            invitation.type = Type.valueOf(parser.getAttributeValue("", "type"));
            boolean done = false;
            while (!done) {
                parser.next();
                String elementName = parser.getName();
                if (parser.getEventType() == 2) {
                    if ("session".equals(elementName)) {
                        invitation.sessionID = parser.getAttributeValue("", "id");
                        continue;
                    }
                    if ("invitee".equals(elementName)) {
                        invitation.invitee = parser.nextText();
                        continue;
                    }
                    if ("inviter".equals(elementName)) {
                        invitation.inviter = parser.nextText();
                        continue;
                    }
                    if ("reason".equals(elementName)) {
                        invitation.reason = parser.nextText();
                        continue;
                    }
                    if (!"room".equals(elementName)) continue;
                    invitation.room = parser.nextText();
                    continue;
                }
                if (parser.getEventType() != 3 || !RoomInvitation.ELEMENT_NAME.equals(elementName)) continue;
                done = true;
            }
            return invitation;
        }
    }

    public static enum Type {
        user,
        queue,
        workgroup;

    }
}

