/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;

public class InstantMessage {
    public static final int ENCRYPTIONCODE_DEFAULT = 1;
    private final boolean encrypted;
    private final String message;
    private final int encryptionCode;
    private final ByteBlock encryptedData;

    public InstantMessage(String message) {
        DefensiveTools.checkNull(message, "message");
        this.encrypted = false;
        this.message = message;
        this.encryptionCode = -1;
        this.encryptedData = null;
    }

    public InstantMessage(ByteBlock encryptedData) {
        this(1, encryptedData);
    }

    public InstantMessage(int encryptionCode, ByteBlock encryptedData) {
        DefensiveTools.checkRange(encryptionCode, "encryptionCode", 0);
        DefensiveTools.checkNull(encryptedData, "encryptedData");
        this.encrypted = true;
        this.message = null;
        this.encryptionCode = encryptionCode;
        this.encryptedData = encryptedData;
    }

    public final boolean isEncrypted() {
        return this.encrypted;
    }

    public final String getMessage() {
        return this.message;
    }

    public final int getEncryptionCode() {
        return this.encryptionCode;
    }

    public final ByteBlock getEncryptedData() {
        return this.encryptedData;
    }

    public String toString() {
        return "IM: " + (this.message != null ? this.message : "<encrypted, code=" + this.encryptionCode + ">");
    }
}

