/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.DeleteItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataModResponse;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.BuddyItem;
import net.kano.joscar.ssiitem.GroupItem;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddy;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddyGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiServiceImpl;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SsiBuddyGroup
extends SimpleBuddyGroup
implements MutableGroup {
    private static final Logger LOGGER = Logger.getLogger(SsiBuddyGroup.class.getName());

    public SsiBuddyGroup(SsiBuddyList list, GroupItem item) {
        super(list, item);
    }

    @Override
    protected SsiBuddyList getBuddyList() {
        return (SsiBuddyList)super.getBuddyList();
    }

    @Override
    public void rename(String newName) {
        GroupItem item = new GroupItem(this.getItem());
        item.setGroupName(newName);
        SsiServiceImpl ssiService = this.getSsiService();
        ssiService.sendSsiModification(new ModifyItemsCmd(item.toSsiItem()));
    }

    @Override
    public void addBuddy(String screenname) {
        SsiServiceImpl service = this.getSsiService();
        int parentid = this.getItem().getId();
        int id = service.getUniqueItemId(0, parentid);
        this.addBuddies(Arrays.asList(new BuddyItem(screenname, parentid, id).toSsiItem()));
    }

    @Override
    public void copyBuddies(Collection<? extends Buddy> buddies) {
        SsiServiceImpl service = this.getSsiService();
        int parentid = this.getItem().getId();
        ArrayList<SsiItem> items = new ArrayList<SsiItem>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Buddy buddy : buddies) {
            BuddyItem item;
            int id;
            while (ids.contains(id = service.getUniqueItemId(0, parentid))) {
            }
            ids.add(id);
            if (buddy instanceof SimpleBuddy) {
                SimpleBuddy simpleBuddy = (SimpleBuddy)buddy;
                item = new BuddyItem(simpleBuddy.getItem());
                item.setGroupid(parentid);
                item.setId(id);
            } else {
                item = new BuddyItem(buddy.getScreenname().getFormatted(), parentid, id, buddy.getAlias(), buddy.getBuddyComment(), buddy.getAlertEventMask(), buddy.getAlertActionMask(), buddy.getAlertSound());
            }
            items.add(item.toSsiItem());
        }
        this.addBuddies((List<SsiItem>)items);
    }

    private void addBuddies(List<SsiItem> items) {
        SsiServiceImpl service = this.getSsiService();
        final List<Integer> ids = SsiTools.getIdsForItems(items);
        LOGGER.fine("Adding buddies " + items + " - ID's: " + ids);
        CreateItemsCmd cmd = new CreateItemsCmd(items);
        service.sendSsiModification(cmd, new SnacRequestAdapter(){

            @Override
            public void handleResponse(SnacResponseEvent e) {
                if (e.getSnacCommand() instanceof SsiDataModResponse) {
                    SsiDataModResponse dataModResponse = (SsiDataModResponse)e.getSnacCommand();
                    int[] results = dataModResponse.getResults();
                    if (results.length != 1) {
                        LOGGER.warning("Got multiple results for addBuddies: " + results);
                    }
                    int result = results[0];
                    LOGGER.fine("Got SSI response: " + result);
                    if (result == 0) {
                        this.addBuddiesToGroup(ids);
                    }
                }
            }

            private boolean addBuddiesToGroup(List<Integer> toAdd) {
                GroupItem item = SsiBuddyGroup.this.getItem();
                LOGGER.fine("Adding buddies to group " + item + ": " + toAdd);
                ArrayList<Integer> result = new ArrayList<Integer>();
                int[] oldIds = item.getBuddies();
                if (oldIds != null) {
                    for (int id : oldIds) {
                        result.add(id);
                    }
                }
                assert (oldIds == null || result.size() == oldIds.length);
                LOGGER.finer("Old ID list: " + oldIds);
                ArrayList<Integer> ids2 = new ArrayList<Integer>(toAdd);
                ids2.removeAll(result);
                LOGGER.finer("Actually adding " + ids2);
                result.addAll(ids2);
                int[] newIds = new int[result.size()];
                int i = 0;
                Iterator i$ = result.iterator();
                while (i$.hasNext()) {
                    int id;
                    newIds[i] = id = ((Integer)i$.next()).intValue();
                    ++i;
                }
                assert (i == newIds.length);
                GroupItem newGroupItem = new GroupItem(item);
                newGroupItem.setBuddies(newIds);
                LOGGER.fine("New group item: " + newGroupItem);
                ModifyItemsCmd cmd = new ModifyItemsCmd(newGroupItem.toSsiItem());
                SsiBuddyGroup.this.getSsiService().sendSsiModification(cmd);
                return true;
            }
        });
    }

    private SsiServiceImpl getSsiService() {
        return this.getBuddyList().getSsiService();
    }

    @Override
    public void deleteBuddy(Buddy buddy) {
        this.deleteBuddies(Arrays.asList(buddy));
    }

    @Override
    public void deleteBuddies(List<Buddy> ingroup) {
        List<SsiItem> items = SsiTools.getBuddiesToDelete(ingroup);
        final List<Integer> ids = SsiTools.getIdsForItems(items);
        assert (SsiTools.isOnlyBuddies(items));
        DeleteItemsCmd deleteCmd = new DeleteItemsCmd(items);
        SsiServiceImpl service = this.getSsiService();
        service.sendSsiModification(deleteCmd, new SnacRequestAdapter(){

            @Override
            public void handleResponse(SnacResponseEvent e) {
                SsiDataModResponse dataModResponse;
                int result;
                if (e.getSnacCommand() instanceof SsiDataModResponse && (result = (dataModResponse = (SsiDataModResponse)e.getSnacCommand()).getResults()[0]) == 0) {
                    this.removeItemsFromGroup(ids);
                }
            }

            private boolean removeItemsFromGroup(List<Integer> removeIds) {
                GroupItem groupItem = SsiBuddyGroup.this.getItem();
                int[] oldIds = groupItem.getBuddies();
                ArrayList<Integer> result = new ArrayList<Integer>();
                if (oldIds == null) {
                    return false;
                }
                for (int id : oldIds) {
                    result.add(id);
                }
                result.removeAll(removeIds);
                int[] newIds = new int[result.size()];
                int i = 0;
                Iterator i$ = result.iterator();
                while (i$.hasNext()) {
                    int val;
                    newIds[i] = val = ((Integer)i$.next()).intValue();
                    ++i;
                }
                assert (i == newIds.length);
                GroupItem newGroupItem = new GroupItem(groupItem);
                newGroupItem.setBuddies(newIds);
                SsiServiceImpl service = SsiBuddyGroup.this.getSsiService();
                service.sendSsiModification(new ModifyItemsCmd(newGroupItem.toSsiItem()));
                return true;
            }
        });
    }
}

