/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.browserlauncher;

import com.apple.eio.FileManager;
import net.java.sip.communicator.impl.browserlauncher.BrowserLauncherActivator;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;

public class BrowserLauncherImpl
implements BrowserLauncherService {
    private static String LINUX_BROWSERS_PROP_NAME = "net.java.sip.communicator.impl.browserlauncher.LINUX_BROWSERS";
    private static final Logger logger = Logger.getLogger(BrowserLauncherImpl.class);
    private static String linuxBrowser = null;

    private void launchBrowser(String url) throws Exception {
        if (OSUtils.IS_MAC) {
            FileManager.openURL((String)url);
        } else if (OSUtils.IS_WINDOWS) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            String browser = this.getLinuxBrowser();
            if (browser == null) {
                logger.error((Object)"Could not find web browser");
            } else {
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
    }

    private String getLinuxBrowser() throws Exception {
        ConfigurationService cfg;
        if (linuxBrowser == null && (cfg = BrowserLauncherActivator.getConfigurationService()) != null) {
            String browsers = cfg.getString(LINUX_BROWSERS_PROP_NAME);
            if (browsers == null) {
                logger.error((Object)("Required property not set: " + LINUX_BROWSERS_PROP_NAME));
                return null;
            }
            Runtime runtime = Runtime.getRuntime();
            for (String b : browsers.split(":")) {
                if (runtime.exec(new String[]{"which", b}).waitFor() != 0) continue;
                linuxBrowser = b;
                break;
            }
        }
        return linuxBrowser;
    }

    @Override
    public void openURL(final String url) {
        Thread launchBrowserThread = new Thread(this.getClass().getName()){

            @Override
            public void run() {
                try {
                    BrowserLauncherImpl.this.launchBrowser(url);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to launch browser", (Throwable)e);
                }
            }
        };
        launchBrowserThread.start();
    }
}

