/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.common.collect.Maps;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.util.LogUtils;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.util.common.base.StringUtil;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import com.google.gdata.wireformats.ContentValidationException;
import com.google.gdata.wireformats.SaxEventSource;
import com.google.gdata.wireformats.StreamProperties;
import com.google.gdata.wireformats.WireFormatParser;
import com.google.gdata.wireformats.XmlHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends DefaultHandler
implements WireFormatParser {
    private static final Logger logger = Logger.getLogger(XmlParser.class.getName());
    protected final StreamProperties props;
    private final XmlEventSource eventSource;
    protected ElementHandler rootHandler;
    protected String rootNamespace;
    protected String rootElementName;
    ElementHandler curHandler;
    int unrecognizedElements = 0;
    Locator locator;
    protected Map<String, Stack<NamespaceDecl>> namespaceMap = Maps.newHashMap();
    ArrayList<XmlNamespace> elementNamespaces = new ArrayList();

    public XmlParser(StreamProperties props, Reader r, Charset cs) {
        this(props, new SaxEventSource(r));
        Preconditions.checkNotNull(cs, "cs");
    }

    public XmlParser(StreamProperties props, XmlEventSource eventSource) {
        Preconditions.checkNotNull(props, "stream properties");
        Preconditions.checkNotNull(eventSource, "eventSource");
        this.props = props;
        this.eventSource = eventSource;
    }

    @Override
    public Element parse(Element element) throws IOException, ParseException, ContentValidationException {
        ValidationContext vc = new ValidationContext();
        ElementMetadata<?, ?> metadata = this.props.getRootMetadata();
        this.rootHandler = this.createRootHandler(vc, element, metadata);
        QName elementName = metadata == null ? element.getElementId() : metadata.getName();
        XmlNamespace elementNs = elementName.getNs();
        this.rootNamespace = elementNs == null ? null : elementNs.getUri();
        this.rootElementName = elementName.getLocalName();
        try {
            this.eventSource.parse(this);
        }
        catch (SAXException e) {
            Exception rootException = e.getException();
            if (rootException instanceof ParseException) {
                this.throwParseException((ParseException)rootException);
            }
            if (rootException instanceof IOException) {
                LogUtils.logException(logger, Level.WARNING, null, e);
                throw (IOException)rootException;
            }
            LogUtils.logException(logger, Level.FINE, null, e);
            throw new ParseException(e);
        }
        return element.resolve(metadata);
    }

    protected XmlHandler createRootHandler(ValidationContext vc, Element element, ElementMetadata<?, ?> metadata) {
        return new XmlHandler(vc, null, element, metadata);
    }

    protected void throwParseException(ParseException e) throws ParseException {
        if (this.locator != null) {
            String elementLocation = "";
            if (this.curHandler != null) {
                elementLocation = elementLocation + ", element " + this.curHandler.qName;
            }
            String location = "[Line " + String.valueOf(this.locator.getLineNumber()) + ", Column " + String.valueOf(this.locator.getColumnNumber()) + elementLocation + "] ";
            LogUtils.logException(logger, Level.FINE, location, e);
            throw new ParseException(location + e.getMessage(), (Throwable)e);
        }
        LogUtils.logException(logger, Level.FINE, null, e);
        throw e;
    }

    static String getCumulativeXmlBase(String curBase, String newBase) throws URISyntaxException {
        URI newBaseUri = new URI(newBase);
        if (curBase == null || curBase.equals("")) {
            if (!newBaseUri.isAbsolute()) {
                throw new URISyntaxException(newBase, "No xml:base established--need an absolute URI.");
            }
            return newBase;
        }
        URI curBaseUri = new URI(curBase);
        URI resultUri = curBaseUri.resolve(newBaseUri);
        assert (resultUri.isAbsolute());
        return resultUri.toString();
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes attrs) throws SAXException {
        logger.fine("Start element " + qName);
        ElementHandler parentHandler = this.curHandler;
        if (this.curHandler == null) {
            if (namespace.equals(this.rootNamespace) && localName.equals(this.rootElementName)) {
                this.curHandler = this.rootHandler;
            } else if (this.rootElementName != null) {
                throw new SAXException(new ParseException("Invalid root element, expected (namespace uri:local name) of (" + this.rootNamespace + ":" + this.rootElementName + ")" + ", found (" + namespace + ":" + localName));
            }
        } else if (this.curHandler != null && this.unrecognizedElements == 0) {
            try {
                this.curHandler = this.curHandler.getChildHandler(XmlParser.createQName(qName, namespace, localName), attrs, this.elementNamespaces);
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        if (this.curHandler != null && this.unrecognizedElements == 0) {
            this.curHandler.parent = parentHandler;
            this.curHandler.qName = qName;
            if (parentHandler != null) {
                this.curHandler.xmlLang = parentHandler.xmlLang;
                this.curHandler.xmlBase = parentHandler.xmlBase;
            }
            try {
                String attrNamespace;
                int i;
                for (i = 0; i < attrs.getLength(); ++i) {
                    attrNamespace = attrs.getURI(i);
                    String attrLocalName = attrs.getLocalName(i);
                    String attrValue = attrs.getValue(i);
                    if (!attrNamespace.equals("http://www.w3.org/XML/1998/namespace")) continue;
                    if (attrLocalName.equals("lang")) {
                        this.curHandler.xmlLang = attrValue;
                        logger.finer("xml:lang=" + attrValue);
                        continue;
                    }
                    if (!attrLocalName.equals("base")) continue;
                    this.curHandler.xmlBase = XmlParser.getCumulativeXmlBase(this.curHandler.xmlBase, attrValue);
                    logger.finer("xml:base=" + this.curHandler.xmlBase);
                }
                for (i = 0; i < attrs.getLength(); ++i) {
                    attrNamespace = attrs.getURI(i);
                    String attrQName = attrs.getQName(i);
                    String attrLocalName = attrs.getLocalName(i);
                    String attrValue = attrs.getValue(i);
                    logger.finer("Attribute " + attrLocalName + "='" + attrValue + "'");
                    this.curHandler.processAttribute(XmlParser.createQName(attrQName, attrNamespace, attrLocalName), attrValue);
                }
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            catch (URISyntaxException e) {
                throw new SAXException(new ParseException(e.getMessage()));
            }
            catch (NumberFormatException e) {
                throw new SAXException(new ParseException("Invalid integer format. " + e.getMessage()));
            }
            this.curHandler.okToInitializeXmlBlob = false;
            if (this.curHandler.xmlBlob != null) {
                if (this.curHandler.xmlLang != null) {
                    this.curHandler.xmlBlob.setLang(this.curHandler.xmlLang);
                }
                if (this.curHandler.xmlBase != null) {
                    this.curHandler.xmlBlob.setBase(this.curHandler.xmlBase);
                }
            }
        } else {
            ++this.unrecognizedElements;
            for (XmlNamespace ns : this.elementNamespaces) {
                Stack<NamespaceDecl> nsDecls = this.namespaceMap.get(ns.getAlias());
                if (nsDecls == null || nsDecls.size() <= 0) continue;
                nsDecls.peek().inBlob = true;
            }
            if (this.curHandler == null) {
                this.curHandler = parentHandler;
            }
            if (this.curHandler != null && this.curHandler.innerXml != null) {
                ArrayList<XmlWriter.Attribute> attrList = new ArrayList<XmlWriter.Attribute>(attrs.getLength());
                for (int i = attrs.getLength() - 1; i >= 0; --i) {
                    String qNameAttr = attrs.getQName(i);
                    this.ensureBlobNamespace(this.curHandler, qNameAttr);
                    String value = attrs.getValue(i);
                    XmlWriter.Attribute attr = new XmlWriter.Attribute(qNameAttr, value);
                    attrList.add(attr);
                    if (!this.curHandler.fullTextIndex) continue;
                    this.curHandler.fullTextIndexWriter.write(value);
                    this.curHandler.fullTextIndexWriter.write(" ");
                }
                try {
                    this.ensureBlobNamespace(this.curHandler, qName);
                    this.curHandler.innerXml.startElement(null, qName, attrList, this.elementNamespaces);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }
        this.elementNamespaces.clear();
    }

    @Override
    public void endElement(String namespace, String localName, String qName) throws SAXException {
        logger.fine("End element " + qName);
        if (this.unrecognizedElements > 0) {
            --this.unrecognizedElements;
            if (this.curHandler != null && this.curHandler.innerXml != null) {
                try {
                    this.curHandler.innerXml.endElement();
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        } else if (this.curHandler != null) {
            StringBuffer blob;
            if (this.curHandler.xmlBlob != null && (blob = this.curHandler.innerXmlStringWriter.getBuffer()).length() != 0) {
                this.curHandler.xmlBlob.setBlob(blob.toString());
                if (this.curHandler.fullTextIndex) {
                    this.curHandler.xmlBlob.setFullText(this.curHandler.fullTextIndexWriter.toString());
                }
            }
            try {
                if (this.curHandler.buffer != null) {
                    this.curHandler.value = this.curHandler.buffer.toString();
                    this.curHandler.buffer = null;
                }
                this.curHandler.processEndElement();
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            this.curHandler = this.curHandler.parent;
        }
    }

    @Override
    public void characters(char[] text, int start, int len) throws SAXException {
        if (this.curHandler != null) {
            if (this.unrecognizedElements == 0) {
                if (this.curHandler.buffer == null) {
                    this.curHandler.buffer = new StringBuffer();
                }
                this.curHandler.buffer.append(text, start, len);
            }
            if (this.curHandler.innerXml != null && (this.curHandler.mixedContent || this.unrecognizedElements > 0)) {
                if (this.curHandler.fullTextIndex) {
                    this.curHandler.fullTextIndexWriter.write(text, start, len);
                    this.curHandler.fullTextIndexWriter.write("\n");
                }
                try {
                    this.curHandler.innerXml.characters(new String(text, start, len));
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int len) throws SAXException {
        if (this.curHandler != null && this.curHandler.innerXml != null && (this.curHandler.mixedContent || this.unrecognizedElements > 0)) {
            try {
                this.curHandler.innerXml.writeUnescaped(new String(text, start, len));
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator newLocator) {
        this.locator = newLocator;
    }

    @Override
    public void startPrefixMapping(String alias, String uri) {
        Stack<NamespaceDecl> mapping = this.namespaceMap.get(alias);
        if (mapping == null) {
            mapping = new Stack();
            this.namespaceMap.put(alias, mapping);
        }
        XmlNamespace ns = new XmlNamespace(alias, uri);
        NamespaceDecl nsDecl = new NamespaceDecl(ns);
        mapping.push(nsDecl);
        this.elementNamespaces.add(ns);
    }

    @Override
    public void endPrefixMapping(String alias) {
        this.namespaceMap.get(alias).pop();
    }

    private void ensureBlobNamespace(ElementHandler handler, String qName) {
        NamespaceDecl nsDecl = null;
        String alias = qName.substring(0, Math.max(0, qName.indexOf(":")));
        if (alias.equals("xml")) {
            return;
        }
        Stack<NamespaceDecl> mapping = this.namespaceMap.get(alias);
        if (mapping != null) {
            nsDecl = mapping.peek();
        }
        assert (alias.length() == 0 || nsDecl != null) : "Namespace alias '" + alias + "' should be mapped in 'namespaceMap'.";
        if (nsDecl != null && !nsDecl.inBlob && nsDecl.ns != null && !handler.blobNamespaces.contains(alias)) {
            handler.blobNamespaces.add(alias);
            handler.xmlBlob.getNamespaces().add(new XmlNamespace(alias, nsDecl.ns.getUri()));
        }
    }

    private static QName createQName(String qName, String nsUri, String localName) {
        XmlNamespace ns = null;
        if (!StringUtil.isEmpty(nsUri)) {
            String[] parts = qName.split(":");
            ns = parts.length == 2 ? new XmlNamespace(parts[0], nsUri) : new XmlNamespace(null, nsUri);
        }
        return new QName(ns, localName);
    }

    private static class NamespaceDecl {
        XmlNamespace ns;
        boolean inBlob;

        private NamespaceDecl(XmlNamespace ns) {
            this.ns = ns;
        }
    }

    static class ElementHandler {
        public String qName;
        public String value;
        private StringBuffer buffer;
        public String xmlLang;
        public String xmlBase;
        ElementHandler parent;
        XmlBlob xmlBlob = null;
        boolean okToInitializeXmlBlob = true;
        boolean mixedContent = false;
        boolean fullTextIndex = false;
        XmlWriter innerXml;
        Set<String> blobNamespaces = new HashSet<String>();
        StringWriter innerXmlStringWriter;
        StringWriter fullTextIndexWriter;

        ElementHandler() {
        }

        public ElementHandler getChildHandler(QName qn, Attributes attrs, List<XmlNamespace> namespaces) throws ParseException, IOException {
            if (this.xmlBlob == null) {
                ParseException pe = new ParseException(CoreErrorDomain.ERR.unrecognizedElement);
                pe.setInternalReason("Unrecognized element '" + qn.getLocalName() + "'.");
                throw pe;
            }
            logger.fine("No child handler for " + qn.getLocalName() + ". Treating as arbitrary foreign XML.");
            return null;
        }

        public void processAttribute(QName qn, String attrValue) throws ParseException {
        }

        public void processEndElement() throws ParseException {
            if (this.value != null && !this.value.trim().equals("") && !this.mixedContent) {
                throw new ParseException(CoreErrorDomain.ERR.textNotAllowed);
            }
        }

        public void initializeXmlBlob(XmlBlob xmlBlob, boolean mixedContent, boolean fullTextIndex) throws IOException {
            assert (this.okToInitializeXmlBlob);
            this.xmlBlob = xmlBlob;
            this.mixedContent = mixedContent;
            this.innerXmlStringWriter = new StringWriter();
            this.innerXml = new XmlWriter(this.innerXmlStringWriter);
            this.fullTextIndex = fullTextIndex;
            if (fullTextIndex) {
                this.fullTextIndexWriter = new StringWriter();
            }
        }

        public String getAbsoluteUri(String uriValue) throws ParseException {
            try {
                return XmlParser.getCumulativeXmlBase(this.xmlBase, uriValue);
            }
            catch (URISyntaxException e) {
                throw new ParseException(e.getMessage());
            }
        }

        public Boolean getBooleanAttribute(Attributes attrs, String attrName) throws ParseException {
            Boolean result = null;
            String attrValue = attrs.getValue("", attrName);
            try {
                result = this.parseBooleanValue(attrValue);
            }
            catch (ParseException ex) {
                ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidAttributeValue);
                pe.setInternalReason("Invalid value for " + attrName + " attribute: " + attrValue);
                throw pe;
            }
            return result;
        }

        protected Boolean parseBooleanValue(String booleanValue) throws ParseException {
            if (booleanValue == null) {
                return null;
            }
            if (booleanValue.equalsIgnoreCase("false") || booleanValue.equals("0")) {
                return Boolean.FALSE;
            }
            if (booleanValue.equalsIgnoreCase("true") || booleanValue.equals("1")) {
                return Boolean.TRUE;
            }
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidBooleanAttribute);
            pe.setInternalReason("Invalid value for boolean attribute: " + booleanValue);
            throw pe;
        }
    }
}

