/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.icqconstants.IcqStatusEnum;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestProtocolProviderServiceIcqImpl
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestProtocolProviderServiceIcqImpl.class);
    private IcqSlickFixture fixture = new IcqSlickFixture();
    private Object registrationLock = new Object();
    public RegistrationEventCollector regEvtCollector = new RegistrationEventCollector();

    public TestProtocolProviderServiceIcqImpl(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        if (!IcqSlickFixture.onlineTestingDisabled) {
            suite.addTest((Test)new TestProtocolProviderServiceIcqImpl("testRegister"));
            suite.addTest((Test)new TestProtocolProviderServiceIcqImpl("testIsRegistered"));
            suite.addTest((Test)new TestProtocolProviderServiceIcqImpl("testGetRegistrationState"));
            suite.addTest((Test)new TestProtocolProviderServiceIcqImpl("testOperationSetTypes"));
        }
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegister() throws OperationFailedException {
        Object lock;
        this.fixture.provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector);
        this.fixture.provider.register((SecurityAuthority)new SecurityAuthorityImpl());
        try {
            Object object = this.registrationLock;
            synchronized (object) {
                logger.debug((Object)"Waiting for registration to complete ...");
                this.registrationLock.wait(40000L);
                logger.debug((Object)"Registration was completed or we lost patience.");
            }
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"Interrupted while waiting for registration", (Throwable)ex);
        }
        catch (Throwable t) {
            logger.debug((Object)"We got thrown out while waiting for registration", t);
        }
        OperationSetBasicInstantMessaging opSetBasicIM = (OperationSetBasicInstantMessaging)this.fixture.provider.getOperationSet(OperationSetBasicInstantMessaging.class);
        IcqSlickFixture.offlineMsgCollector.register(opSetBasicIM);
        Object object = lock = new Object();
        synchronized (object) {
            try {
                logger.debug((Object)"Giving the aim server time to notify for our arrival!");
                lock.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TestProtocolProviderServiceIcqImpl.assertTrue((String)"The tested ICQ implementation on-line status was OFFLINE", (!IcqStatusEnum.OFFLINE.equals((Object)IcqSlickFixture.testerAgent.getBuddyStatus(this.fixture.ourUserID)) ? 1 : 0) != 0);
        TestProtocolProviderServiceIcqImpl.assertTrue((String)"No events were dispatched during the registration process.", (this.regEvtCollector.collectedNewStates.size() > 0 ? 1 : 0) != 0);
        TestProtocolProviderServiceIcqImpl.assertTrue((String)("No registration event notifying of registration was dispatched. All events were: " + this.regEvtCollector.collectedNewStates), (boolean)this.regEvtCollector.collectedNewStates.contains(RegistrationState.REGISTERED));
        this.fixture.provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector);
    }

    public void testIsRegistered() {
        if (!IcqStatusEnum.OFFLINE.equals((Object)IcqSlickFixture.testerAgent.getBuddyStatus(this.fixture.ourUserID))) {
            TestProtocolProviderServiceIcqImpl.assertTrue((String)"provider.isRegistered() returned false while registered", (boolean)this.fixture.provider.isRegistered());
        } else {
            TestProtocolProviderServiceIcqImpl.assertFalse((String)"provider.isRegistered() returned true while unregistered", (boolean)this.fixture.provider.isRegistered());
        }
    }

    public void testGetRegistrationState() {
        if (!IcqStatusEnum.OFFLINE.equals((Object)IcqSlickFixture.testerAgent.getBuddyStatus(this.fixture.ourUserID))) {
            TestProtocolProviderServiceIcqImpl.assertEquals((String)"a provider was not in a REGISTERED state while registered.", (Object)RegistrationState.REGISTERED, (Object)this.fixture.provider.getRegistrationState());
        } else {
            TestProtocolProviderServiceIcqImpl.assertFalse((String)"a provider had a REGISTERED reg state while unregistered.", (boolean)this.fixture.provider.getRegistrationState().equals((Object)RegistrationState.REGISTERED));
        }
    }

    public void testOperationSetTypes() throws Exception {
        Map supportedOperationSets = this.fixture.provider.getSupportedOperationSets();
        for (Map.Entry entry : supportedOperationSets.entrySet()) {
            String setName = (String)entry.getKey();
            Object opSet = entry.getValue();
            TestProtocolProviderServiceIcqImpl.assertTrue((String)(opSet + " was not an instance of " + setName + " as declared"), (boolean)Class.forName(setName).isInstance(opSet));
        }
    }

    public class SecurityAuthorityImpl
    implements SecurityAuthority {
        private boolean isUserNameEditable = false;

        public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues, int reasonCode) {
            return this.obtainCredentials(realm, defaultValues);
        }

        public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues) {
            String passwd = System.getProperty("accounts.icq.TESTED_IMPL_PWD", null);
            defaultValues.setPassword(passwd.toCharArray());
            return defaultValues;
        }

        public void setUserNameEditable(boolean isUserNameEditable) {
            this.isUserNameEditable = isUserNameEditable;
        }

        public boolean isUserNameEditable() {
            return this.isUserNameEditable;
        }
    }

    public class RegistrationEventCollector
    implements RegistrationStateChangeListener {
        public List<RegistrationState> collectedNewStates = new LinkedList<RegistrationState>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            logger.debug((Object)("Received a RegistrationStateChangeEvent: " + evt));
            this.collectedNewStates.add(evt.getNewState());
            if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                logger.debug((Object)"We're registered and will notify those who wait");
                Object object = TestProtocolProviderServiceIcqImpl.this.registrationLock;
                synchronized (object) {
                    TestProtocolProviderServiceIcqImpl.this.registrationLock.notifyAll();
                }
            }
        }
    }
}

