/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.search.SearchCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultsCmd
extends SearchCommand {
    public static final int CODE_DEFAULT = 5;
    public static final int SUBCODE_DEFAULT = 0;
    private final int code;
    private final int subCode;
    private final List<DirInfo> results;

    protected SearchResultsCmd(SnacPacket packet) {
        super(3);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUShort(snacData, 0);
        this.subCode = BinaryTools.getUShort(snacData, 2);
        if (snacData.getLength() >= 6) {
            int resultCount = BinaryTools.getUShort(snacData, 4);
            ArrayList<DirInfo> resultList = new ArrayList<DirInfo>();
            ByteBlock block = snacData.subBlock(6);
            for (int i = 0; i < resultCount; ++i) {
                int tlvCount = BinaryTools.getUShort(block, 0);
                ByteBlock dirBlock = block.subBlock(2);
                DirInfo dirInfo = DirInfo.readDirInfo(dirBlock, tlvCount);
                if (dirInfo == null) break;
                resultList.add(dirInfo);
                block = block.subBlock(2 + dirInfo.getTotalSize());
            }
            this.results = DefensiveTools.getUnmodifiable(resultList);
        } else {
            this.results = null;
        }
    }

    public SearchResultsCmd(Collection<DirInfo> results) {
        this(5, 0, results);
    }

    public SearchResultsCmd(int code, int subCode, Collection<DirInfo> results) {
        super(3);
        DefensiveTools.checkRange(code, "code", 0);
        DefensiveTools.checkRange(subCode, "subCode", 0);
        this.code = code;
        this.subCode = subCode;
        this.results = DefensiveTools.getSafeNonnullListCopy(results, "results");
    }

    public final int getResultCode() {
        return this.code;
    }

    public final int getResultSubCode() {
        return this.subCode;
    }

    public List<DirInfo> getResults() {
        return this.results;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.code);
        BinaryTools.writeUShort(out, this.subCode);
        if (this.results != null) {
            BinaryTools.writeUShort(out, this.results.size());
            for (DirInfo result : this.results) {
                BinaryTools.writeUShort(out, result.getTlvCount());
                result.write(out);
            }
        }
    }

    public String toString() {
        return "SearchResultsCmd: " + this.results.size() + " results";
    }
}

