/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.MinExpiresHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSupport;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.Logger;

public abstract class EventPackageNotifier
extends EventPackageSupport {
    private static final Logger logger = Logger.getLogger(EventPackageNotifier.class);
    private static final int SUBSCRIBE_MIN_EXPIRE = 120;
    private final SipMessageFactory messageFactory;

    public EventPackageNotifier(ProtocolProviderServiceSipImpl protocolProvider, String eventPackage, int subscriptionDuration, String contentSubType, TimerScheduler timer) {
        super(protocolProvider, eventPackage, subscriptionDuration, contentSubType, timer);
        this.messageFactory = protocolProvider.getMessageFactory();
    }

    protected ClientTransaction createNotify(Dialog dialog, byte[] content, String subscriptionState, String reason) throws OperationFailedException {
        ClientTransaction transac;
        ContentTypeHeader cTypeHeader;
        SubscriptionStateHeader sStateHeader;
        EventHeader evHeader;
        MaxForwardsHeader maxForwards;
        ArrayList<ViaHeader> viaHeaders;
        Request req = this.messageFactory.createRequest(dialog, "NOTIFY");
        Address toAddress = dialog.getRemoteTarget();
        if (toAddress == null) {
            toAddress = dialog.getRemoteParty();
        }
        try {
            viaHeaders = this.protocolProvider.getLocalViaHeaders(toAddress);
            maxForwards = this.protocolProvider.getMaxForwardsHeader();
        }
        catch (OperationFailedException e) {
            logger.error((Object)"Can't retrive the via headers or the max forwards header", (Throwable)e);
            throw new OperationFailedException("Can't retrive the via headers or the max forwards header", 4, (Throwable)e);
        }
        try {
            evHeader = this.protocolProvider.getHeaderFactory().createEventHeader(this.eventPackage);
        }
        catch (ParseException e) {
            logger.error((Object)"Can't create the Event header", (Throwable)e);
            throw new OperationFailedException("Can't create the Event header", 4, (Throwable)e);
        }
        try {
            sStateHeader = this.protocolProvider.getHeaderFactory().createSubscriptionStateHeader(subscriptionState);
            if (reason != null && reason.trim().length() != 0) {
                sStateHeader.setReasonCode(reason);
            }
        }
        catch (ParseException e) {
            logger.error((Object)"can't create the Subscription-State header", (Throwable)e);
            throw new OperationFailedException("Can't create the Subscription-State header", 4, (Throwable)e);
        }
        try {
            cTypeHeader = this.protocolProvider.getHeaderFactory().createContentTypeHeader("application", this.contentSubType);
        }
        catch (ParseException e) {
            logger.error((Object)"can't create the Content-Type header", (Throwable)e);
            throw new OperationFailedException("Can't create the Content-Type header", 4, (Throwable)e);
        }
        req.setHeader((Header)maxForwards);
        req.setHeader((Header)evHeader);
        req.setHeader((Header)sStateHeader);
        try {
            transac = this.protocolProvider.getDefaultJainSipProvider().getNewClientTransaction(req);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Failed to create subscriptionTransaction. This is most probably a network connection error.", (Throwable)ex);
            throw new OperationFailedException("Failed to create subscriptionTransaction.", 2, (Throwable)ex);
        }
        req.setHeader((Header)viaHeaders.get(0));
        try {
            req.setContent((Object)content, cTypeHeader);
        }
        catch (ParseException e) {
            logger.error((Object)"Failed to add the presence document", (Throwable)e);
            throw new OperationFailedException("Can't add the presence document to the request", 4, (Throwable)e);
        }
        return transac;
    }

    private ClientTransaction createNotify(Dialog dialog, Subscription subscription, String subscriptionState, String reason) throws OperationFailedException {
        if (dialog == null && (dialog = subscription.getDialog()) == null) {
            throw new OperationFailedException("the dialog of the subscription is null", 4);
        }
        return this.createNotify(dialog, subscription.createNotifyContent(subscriptionState, reason), subscriptionState, reason);
    }

    protected abstract Subscription createSubscription(Address var1, String var2);

    @Override
    protected Subscription getSubscription(Address fromAddress, String eventId) {
        return (Subscription)super.getSubscription(fromAddress, eventId);
    }

    @Override
    protected Subscription getSubscription(String callId) {
        return (Subscription)super.getSubscription(callId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Subscription subscription, String subscriptionState, String reason) throws OperationFailedException {
        String callId;
        Dialog dialog;
        Dialog dialog2 = dialog = subscription.getDialog();
        synchronized (dialog2) {
            ClientTransaction transac = this.createNotify(dialog, subscription, subscriptionState, reason);
            callId = dialog.getCallId().getCallId();
            try {
                dialog.sendRequest(transac);
            }
            catch (SipException sex) {
                logger.error((Object)"Failed to send NOTIFY request.", (Throwable)sex);
                throw new OperationFailedException("Failed to send NOTIFY request.", 2, (Throwable)sex);
            }
        }
        if ("terminated".equals(subscriptionState)) {
            this.removeSubscription(callId, subscription);
        }
    }

    public void notifyAll(String subscriptionState, String reason) throws OperationFailedException {
        this.notifyAll(subscriptionState, reason, null);
    }

    public void notifyAll(String subscriptionState, String reason, SubscriptionFilter filter) throws OperationFailedException {
        for (EventPackageSupport.Subscription subscription : this.getSubscriptions()) {
            Subscription s = (Subscription)subscription;
            if (filter != null && !filter.accept(s)) continue;
            this.notify(s, subscriptionState, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        Response response;
        Subscription fromAddress;
        Dialog dialog;
        Request request = requestEvent.getRequest();
        EventHeader eventHeader = (EventHeader)request.getHeader("Event");
        if (eventHeader == null || !this.eventPackage.equalsIgnoreCase(eventHeader.getEventType())) {
            return false;
        }
        if (!"SUBSCRIBE".equals(request.getMethod())) {
            return false;
        }
        ServerTransaction serverTransaction = EventPackageNotifier.getOrCreateServerTransaction(requestEvent);
        if (serverTransaction == null) {
            return false;
        }
        ExpiresHeader expHeader = request.getExpires();
        int expires = expHeader == null ? this.subscriptionDuration : expHeader.getExpires();
        CallIdHeader callIdHeader = (CallIdHeader)request.getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        if (expires < 120 && expires > 0) {
            MinExpiresHeader min;
            Response response2;
            try {
                response2 = this.protocolProvider.getMessageFactory().createResponse(423, request);
            }
            catch (Exception e) {
                logger.error((Object)"Error while creating the response 423", (Throwable)e);
                return false;
            }
            try {
                min = this.protocolProvider.getHeaderFactory().createMinExpiresHeader(120);
            }
            catch (InvalidArgumentException e) {
                logger.error((Object)"can't create the min expires header", (Throwable)e);
                return false;
            }
            response2.setHeader((Header)min);
            try {
                serverTransaction.sendResponse(response2);
            }
            catch (Exception e) {
                logger.error((Object)"Error while sending the response 423", (Throwable)e);
                return false;
            }
            return true;
        }
        Subscription subscription = this.getSubscription(callId);
        if (subscription != null && expires != 0) {
            dialog = subscription.getDialog();
            if (dialog.equals(serverTransaction.getDialog())) {
                Response response3;
                SubscriptionTimeoutTask timeout = new SubscriptionTimeoutTask(subscription);
                subscription.setTimerTask(timeout);
                this.timer.schedule(timeout, expires * 1000);
                try {
                    response3 = this.protocolProvider.getMessageFactory().createResponse(200, request);
                }
                catch (Exception e) {
                    logger.error((Object)"Error while creating the response 200", (Throwable)e);
                    return false;
                }
                try {
                    expHeader = this.protocolProvider.getHeaderFactory().createExpiresHeader(expires);
                }
                catch (InvalidArgumentException e) {
                    logger.error((Object)"Can't create the expires header");
                    return false;
                }
                response3.setHeader((Header)expHeader);
                try {
                    serverTransaction.sendResponse(response3);
                }
                catch (Exception e) {
                    logger.error((Object)"Error while sending the response 200", (Throwable)e);
                    return false;
                }
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("refreshing subscription " + subscription + ", we will remove the first subscription"));
            }
            ClientTransaction transac = null;
            try {
                transac = this.createNotify(dialog, subscription, "terminated", "rejected");
            }
            catch (OperationFailedException e) {
                logger.error((Object)"failed to create the new notify", (Throwable)e);
                return false;
            }
            this.removeSubscription(callId, subscription);
            try {
                dialog.sendRequest(transac);
            }
            catch (Exception e) {
                logger.error((Object)"Can't send the request", (Throwable)e);
                return false;
            }
        }
        if (subscription == null) {
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            fromAddress = fromHeader.getAddress();
            String eventId = eventHeader.getEventId();
            subscription = this.createSubscription((Address)fromAddress, eventId);
        }
        fromAddress = subscription;
        synchronized (fromAddress) {
            subscription.setDialog(serverTransaction.getDialog());
            dialog = subscription.getDialog();
        }
        if (expires == 0) {
            this.removeSubscription(callId, subscription);
            try {
                response = this.protocolProvider.getMessageFactory().createResponse(200, request);
            }
            catch (Exception e) {
                logger.error((Object)"Error while creating the response 200", (Throwable)e);
                return false;
            }
            try {
                expHeader = this.protocolProvider.getHeaderFactory().createExpiresHeader(0);
            }
            catch (InvalidArgumentException e) {
                logger.error((Object)"Can't create the expires header", (Throwable)e);
                return false;
            }
            response.setHeader((Header)expHeader);
            try {
                serverTransaction.sendResponse(response);
            }
            catch (Exception e) {
                logger.error((Object)"Error while sending the response 200", (Throwable)e);
                return false;
            }
            ClientTransaction transac = null;
            try {
                transac = this.createNotify(dialog, subscription, "terminated", "timeout");
            }
            catch (OperationFailedException e) {
                logger.error((Object)"failed to create the new notify", (Throwable)e);
                return false;
            }
            try {
                dialog.sendRequest(transac);
            }
            catch (Exception e) {
                logger.error((Object)"Can't send the request", (Throwable)e);
                return false;
            }
            return true;
        }
        try {
            response = this.protocolProvider.getMessageFactory().createResponse(200, request);
        }
        catch (Exception e) {
            logger.error((Object)"Error while creating the response 200", (Throwable)e);
            return false;
        }
        try {
            expHeader = this.protocolProvider.getHeaderFactory().createExpiresHeader(expires);
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"Can't create the expires header", (Throwable)e);
            return false;
        }
        response.setHeader((Header)expHeader);
        try {
            serverTransaction.sendResponse(response);
        }
        catch (Exception e) {
            logger.error((Object)"Error while sending the response 200", (Throwable)e);
            return false;
        }
        this.addSubscription(callId, subscription);
        Dialog e = dialog;
        synchronized (e) {
            ClientTransaction transac;
            try {
                transac = this.createNotify(dialog, subscription, "active", null);
            }
            catch (OperationFailedException e2) {
                logger.error((Object)"failed to create the new notify", (Throwable)e2);
                return false;
            }
            try {
                dialog.sendRequest(transac);
            }
            catch (Exception e3) {
                logger.error((Object)"Can't send the request", (Throwable)e3);
                return false;
            }
        }
        SubscriptionTimeoutTask timeout = new SubscriptionTimeoutTask(subscription);
        subscription.setTimerTask(timeout);
        this.timer.schedule(timeout, expires * 1000);
        return true;
    }

    @Override
    public boolean processResponse(ResponseEvent responseEvent) {
        Response response = responseEvent.getResponse();
        CSeqHeader cseqHeader = (CSeqHeader)response.getHeader("CSeq");
        if (cseqHeader == null) {
            logger.error((Object)"An incoming response did not contain a CSeq header");
            return false;
        }
        if (!"NOTIFY".equals(cseqHeader.getMethod())) {
            return false;
        }
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        Request notifyRequest = clientTransaction.getRequest();
        String eventId = null;
        if (notifyRequest != null) {
            EventHeader eventHeader = (EventHeader)notifyRequest.getHeader("Event");
            if (eventHeader == null || !this.eventPackage.equalsIgnoreCase(eventHeader.getEventType())) {
                return false;
            }
            eventId = eventHeader.getEventId();
        }
        switch (response.getStatusCode()) {
            case 200: {
                break;
            }
            case 401: 
            case 407: {
                try {
                    this.processAuthenticationChallenge(clientTransaction, response, (SipProvider)responseEvent.getSource());
                }
                catch (OperationFailedException e) {
                    logger.error((Object)"can't handle the challenge", (Throwable)e);
                    this.removeSubscription(response, eventId, clientTransaction);
                }
                break;
            }
            default: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("error received from the network" + response));
                }
                this.removeSubscription(response, eventId, clientTransaction);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(Response response, String eventId, ClientTransaction clientTransaction) {
        CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        Subscription subscription = this.getSubscription(callId);
        if (subscription != null) {
            Subscription subscription2 = subscription;
            synchronized (subscription2) {
                if (subscription.getDialog().equals(clientTransaction.getDialog())) {
                    this.removeSubscription(callId, subscription);
                }
            }
        }
    }

    private class SubscriptionTimeoutTask
    extends TimerTask {
        private final Subscription subscription;

        public SubscriptionTimeoutTask(Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        public void run() {
            Dialog dialog = this.subscription.getDialog();
            if (dialog == null) {
                logger.warn((Object)("null dialog associated with " + this.subscription + ", can't send the closing NOTIFY"));
                return;
            }
            try {
                EventPackageNotifier.this.notify(this.subscription, "terminated", "timeout");
            }
            catch (OperationFailedException ofex) {
                logger.error((Object)("Failed to timeout subscription " + this.subscription), (Throwable)ofex);
            }
        }
    }

    public static interface SubscriptionFilter {
        public boolean accept(Subscription var1);
    }

    public static abstract class Subscription
    extends EventPackageSupport.Subscription {
        public Subscription(Address fromAddress, String eventId) {
            super(fromAddress, eventId);
        }

        protected abstract byte[] createNotifyContent(String var1, String var2);
    }
}

